/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.multiresource.tests;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.components.multiresource.MultiResourceListModel;

public class MultiResourceListModelTestCase
extends AbstractJenaTestCase {
    public void testGetAndSetValues() {
        OWLIndividual subject = this.owlThing.createOWLIndividual("Instance");
        RDFProperty predicate = this.owlModel.createRDFProperty("property");
        MultiResourceListModel listModel = new MultiResourceListModel(predicate);
        listModel.setSubject(subject);
        MultiResourceListModelTestCase.assertEquals((int)0, (int)listModel.getSize());
        subject.addPropertyValue(predicate, this.owlThing);
        listModel.updateValues();
        MultiResourceListModelTestCase.assertEquals((int)1, (int)listModel.getSize());
        MultiResourceListModelTestCase.assertEquals((Object)this.owlThing, (Object)listModel.getElementAt(0));
        MultiResourceListModelTestCase.assertTrue((boolean)listModel.isRDFResource(0));
        MultiResourceListModelTestCase.assertEquals((Object)this.owlThing, (Object)listModel.getResourceAt(0));
        MultiResourceListModelTestCase.assertTrue((boolean)listModel.isEditable(0));
    }

    public void testHasValueRestrictions() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLIndividual subject = cls.createOWLIndividual("Individual");
        OWLObjectProperty predicate = this.owlModel.createOWLObjectProperty("property");
        OWLIndividual a = this.owlThing.createOWLIndividual("A");
        OWLIndividual b = this.owlThing.createOWLIndividual("B");
        cls.addSuperclass(this.owlModel.createOWLHasValue(predicate, a));
        MultiResourceListModel listModel = new MultiResourceListModel(predicate);
        listModel.setSubject(subject);
        MultiResourceListModelTestCase.assertEquals((int)1, (int)listModel.getSize());
        MultiResourceListModelTestCase.assertEquals((Object)a, (Object)listModel.getResourceAt(0));
        MultiResourceListModelTestCase.assertFalse((boolean)listModel.isEditable(0));
        subject.addPropertyValue(predicate, b);
        listModel.updateValues();
        MultiResourceListModelTestCase.assertEquals((int)2, (int)listModel.getSize());
        MultiResourceListModelTestCase.assertEquals((Object)b, (Object)listModel.getResourceAt(0));
        MultiResourceListModelTestCase.assertEquals((Object)a, (Object)listModel.getResourceAt(1));
    }

    public void testSubpropertyValue() {
        OWLNamedClass type = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty predicate = this.owlModel.createOWLObjectProperty("superproperty");
        OWLObjectProperty subproperty = this.owlModel.createOWLObjectProperty("subproperty");
        subproperty.addSuperproperty(predicate);
        OWLIndividual subject = type.createOWLIndividual("Individual");
        subject.addPropertyValue(subproperty, this.owlThing);
        MultiResourceListModel listModel = new MultiResourceListModel(predicate);
        listModel.setSubject(subject);
        MultiResourceListModelTestCase.assertEquals((int)1, (int)listModel.getSize());
        MultiResourceListModelTestCase.assertEquals((Object)this.owlThing, (Object)listModel.getElementAt(0));
        MultiResourceListModelTestCase.assertFalse((boolean)listModel.isEditable(0));
    }
}

