/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.singleresource.tests;

import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.components.singleresource.SetResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.singleresource.SingleResourceComponent;
import java.util.Collections;

public class SetResourceActionTestCase
extends AbstractJenaTestCase {
    public void testRDFSRange() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setRange(cls);
        SingleResourceComponent component = new SingleResourceComponent(property);
        component.setSubject(this.owlThing);
        SetResourceAction action = new SetResourceAction(component);
        SetResourceActionTestCase.assertSize(0, action.getSelectableResources());
        RDFIndividual individual = cls.createRDFIndividual("individual");
        SetResourceActionTestCase.assertSize(1, action.getSelectableResources());
        SetResourceActionTestCase.assertContains((Object)individual, action.getSelectableResources());
    }

    public void testOWLAllValuesFrom() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLIndividual individual = cls.createOWLIndividual("individual");
        cls.createOWLIndividual("Other");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass rangeClass = this.owlModel.createOWLNamedClass("Color");
        cls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, rangeClass));
        OWLIndividual rangeIndividualA = rangeClass.createOWLIndividual("A");
        OWLIndividual rangeIndividualB = rangeClass.createOWLIndividual("B");
        SingleResourceComponent component = new SingleResourceComponent(property);
        component.setSubject(individual);
        SetResourceAction action = new SetResourceAction(component);
        SetResourceActionTestCase.assertSize(2, action.getSelectableResources());
        SetResourceActionTestCase.assertContains((Object)rangeIndividualA, action.getSelectableResources());
        SetResourceActionTestCase.assertContains((Object)rangeIndividualB, action.getSelectableResources());
    }

    public void testOWLAllValuesFromEnumeratedClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLIndividual individual = cls.createOWLIndividual("individual");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass rangeClass = this.owlModel.createOWLNamedClass("Color");
        OWLIndividual rangeIndividualA = rangeClass.createOWLIndividual("A");
        OWLIndividual rangeIndividualB = rangeClass.createOWLIndividual("B");
        OWLEnumeratedClass enumeratedClass = this.owlModel.createOWLEnumeratedClass(Collections.singleton(rangeIndividualA));
        cls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, enumeratedClass));
        SingleResourceComponent component = new SingleResourceComponent(property);
        component.setSubject(individual);
        SetResourceAction action = new SetResourceAction(component);
        SetResourceActionTestCase.assertSize(1, action.getSelectableResources());
        SetResourceActionTestCase.assertContains((Object)rangeIndividualA, action.getSelectableResources());
    }
}

