/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.components.triples.AbstractTriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.AddResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.CreateValueAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.DeleteTripleAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;

public class TriplesComponent
extends AbstractTriplesComponent {
    private Action deleteRowAction;

    public TriplesComponent(RDFProperty predicate) {
        this(predicate, "Triples", OWLIcons.getImageIcon("Triples"));
    }

    public TriplesComponent(RDFProperty predicate, String label, Icon icon) {
        super(predicate, label, icon);
    }

    protected void addButtons(LabeledComponent lc) {
        lc.addHeaderButton((Action)new CreateValueAction(this.getTable(), "Create datatype property value...", OWLIcons.getCreateIndividualIcon("DatatypeTriple")){

            protected Collection getAllowedProperties(OWLModel owlModel) {
                ArrayList<RDFProperty> results = new ArrayList<RDFProperty>();
                Iterator it = owlModel.getRDFProperties().iterator();
                RDFSNamedClass type = (RDFSNamedClass)this.table.getTableModel().getSubject().getRDFType();
                while (it.hasNext()) {
                    RDFProperty property = (RDFProperty)it.next();
                    if (!property.isVisible() || !property.hasDatatypeRange() && !TriplesComponent.this.isDatatypeProperty(property, type)) continue;
                    results.add(property);
                }
                results.remove(owlModel.getRDFProperty(":PAL-DESCRIPTION"));
                results.remove(owlModel.getRDFProperty(":PAL-NAME"));
                results.remove(owlModel.getRDFProperty(":PAL-RANGE"));
                results.remove(owlModel.getRDFProperty(":PAL-STATEMENT"));
                return results;
            }
        });
        lc.addHeaderButton((Action)new CreateValueAction(this.getTable(), "Create object property value...", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

            protected Collection getAllowedProperties(OWLModel owlModel) {
                ArrayList<RDFProperty> results = new ArrayList<RDFProperty>();
                Iterator it = super.getAllowedProperties(owlModel).iterator();
                RDFSNamedClass type = (RDFSNamedClass)this.table.getTableModel().getSubject().getRDFType();
                while (it.hasNext()) {
                    RDFProperty property = (RDFProperty)it.next();
                    if (TriplesComponent.this.isDatatypeProperty(property, type) || !property.isAnnotationProperty() && property.isSystem()) continue;
                    results.add(property);
                }
                return results;
            }
        });
        lc.addHeaderButton((Action)new AddResourceAction(this.getTable()));
        this.deleteRowAction = new DeleteTripleAction(this.getTable());
        lc.addHeaderButton(this.deleteRowAction);
        this.deleteRowAction.setEnabled(false);
    }

    private boolean isDatatypeProperty(RDFProperty property, RDFSNamedClass type) {
        if (!property.hasObjectRange()) {
            if (type instanceof OWLNamedClass) {
                RDFResource allValuesFrom = ((OWLNamedClass)type).getAllValuesFrom(property);
                if (allValuesFrom instanceof RDFSDatatype) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected void updateActions() {
        super.updateActions();
        int row = this.getTable().getSelectedRow();
        TriplesTableModel tableModel = this.getTable().getTableModel();
        boolean deleteRowEnabled = false;
        if (row >= 0) {
            deleteRowEnabled = tableModel.isDeleteEnabled(row);
        }
        this.deleteRowAction.setEnabled(deleteRowEnabled);
    }
}

