/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples.tests;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;

public class TriplesTableModelTestCase
extends AbstractJenaTestCase {
    public void testCreateTableModelForOWLThing() {
        TriplesTableModel tableModel = new TriplesTableModel(this.owlThing);
        TriplesTableModelTestCase.assertEquals((int)4, (int)tableModel.getColumnCount());
        TriplesTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        TriplesTableModelTestCase.assertEquals((Object)this.owlModel.getRDFTypeProperty(), (Object)tableModel.getPredicate(0));
        TriplesTableModelTestCase.assertEquals((Object)this.owlModel.getOWLNamedClassClass(), (Object)tableModel.getValue(0));
        TriplesTableModelTestCase.assertNull((Object)tableModel.getValueAt(0, 3));
    }

    public void testEditDatatype() {
        RDFResource subject = this.owlThing.createInstance("Instance");
        TriplesTableModel tableModel = new TriplesTableModel(subject);
        TriplesTableModelTestCase.assertEquals((int)4, (int)tableModel.getColumnCount());
        TriplesTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        RDFProperty predicate = this.owlModel.getOWLVersionInfoProperty();
        subject.addPropertyValue(predicate, "42");
        TriplesTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        TriplesTableModelTestCase.assertEquals((Object)predicate, (Object)tableModel.getValueAt(0, 0));
        TriplesTableModelTestCase.assertEquals((Object)this.owlModel.getXSDstring(), (Object)tableModel.getValueAt(0, 2));
        TriplesTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(0, 2));
        tableModel.setValueAt(this.owlModel.getXSDint(), 0, 2);
        TriplesTableModelTestCase.assertEquals((Object)this.owlModel.getXSDint(), (Object)tableModel.getValueAt(0, 2));
    }

    public void testEditLanguage() {
        RDFResource subject = this.owlThing.createInstance("Instance");
        TriplesTableModel tableModel = new TriplesTableModel(subject);
        TriplesTableModelTestCase.assertEquals((int)4, (int)tableModel.getColumnCount());
        String text = "Test";
        RDFProperty property = this.owlModel.getRDFSLabelProperty();
        subject.addPropertyValue(property, text);
        TriplesTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        TriplesTableModelTestCase.assertEquals((Object)property, (Object)tableModel.getPredicate(1));
        tableModel.setValueAt("de", 1, 3);
        TriplesTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        TriplesTableModelTestCase.assertEquals((Object)"de", (Object)tableModel.getValueAt(1, 3));
        tableModel.setValueAt("es", 1, 3);
        TriplesTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
    }
}

