/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.tests.AbstractConditionsTableTestCase;
import java.util.Arrays;

public class FillConditionsTableModelTestCase
extends AbstractConditionsTableTestCase {
    public void testEmptyClass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        FillConditionsTableModelTestCase.assertEquals((int)3, (int)tableModel.getRowCount());
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing});
        FillConditionsTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(2, 0));
        FillConditionsTableModelTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(2));
    }

    public void testSingleRestrictionClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(property, 1);
        cls.addSuperclass(restriction);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing, restriction});
        FillConditionsTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(2, 0));
        FillConditionsTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(3, 0));
        FillConditionsTableModelTestCase.assertTrue((boolean)tableModel.isDeleteEnabledFor(restriction));
        FillConditionsTableModelTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(3));
    }

    public void testSortRestrictions() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty childrenProperty = this.owlModel.createOWLObjectProperty("children");
        OWLObjectProperty genderProperty = this.owlModel.createOWLObjectProperty("gender");
        OWLMinCardinality minCardiRestriction = this.owlModel.createOWLMinCardinality(childrenProperty, 1);
        personCls.addSuperclass(minCardiRestriction);
        OWLMaxCardinality maxCardiRestriction = this.owlModel.createOWLMaxCardinality(childrenProperty, 3);
        personCls.addSuperclass(maxCardiRestriction);
        OWLSomeValuesFrom someRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)childrenProperty, personCls);
        personCls.addSuperclass(someRestriction);
        OWLMinCardinality genderRestriction = this.owlModel.createOWLMinCardinality(genderProperty, 1);
        personCls.addSuperclass(genderRestriction);
        OWLAllValuesFrom allRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)childrenProperty, personCls);
        personCls.addSuperclass(allRestriction);
        OWLHasValue hasRestriction = this.owlModel.createOWLHasValue(childrenProperty, personCls.createInstance("hans"));
        personCls.addSuperclass(hasRestriction);
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing, allRestriction, someRestriction, hasRestriction, minCardiRestriction, maxCardiRestriction, genderRestriction});
    }

    public void testTwoRestrictionsClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality minRestriction = this.owlModel.createOWLMinCardinality(property, 1);
        cls.addSuperclass(minRestriction);
        OWLAllValuesFrom allRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, cls);
        cls.addSuperclass(allRestriction);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing, allRestriction, minRestriction});
    }

    public void testBothSuperclassAndEquivalentClass() {
        OWLObjectProperty genderProperty = this.owlModel.createOWLObjectProperty("gender");
        OWLNamedClass genderCls = this.owlModel.createOWLNamedClass("Gender");
        RDFResource male = genderCls.createInstance("male");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass malePersonCls = this.owlModel.createOWLNamedClass("MalePerson");
        malePersonCls.addSuperclass(personCls);
        malePersonCls.removeSuperclass(this.owlModel.getOWLThingClass());
        OWLHasValue hasRestriction = this.owlModel.createOWLHasValue(genderProperty, male);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass(Arrays.asList(personCls, hasRestriction));
        malePersonCls.setDefinition(intersectionCls);
        ConditionsTableModel tableModel = this.getTableModel(malePersonCls);
        FillConditionsTableModelTestCase.assertEquals((int)4, (int)tableModel.getRowCount());
        int i = 0;
        FillConditionsTableModelTestCase.assertTrue((boolean)tableModel.isSeparator(i));
        FillConditionsTableModelTestCase.assertEquals((Object)personCls, (Object)tableModel.getClass(++i));
        FillConditionsTableModelTestCase.assertEquals((int)0, (int)tableModel.getType(i));
        FillConditionsTableModelTestCase.assertEquals((int)i, (int)tableModel.getClassRow(personCls));
        FillConditionsTableModelTestCase.assertEquals((Object)intersectionCls, (Object)tableModel.getDefinition(i));
        FillConditionsTableModelTestCase.assertEquals((Object)hasRestriction, (Object)tableModel.getClass(++i));
        FillConditionsTableModelTestCase.assertEquals((int)0, (int)tableModel.getType(i));
        FillConditionsTableModelTestCase.assertEquals((Object)intersectionCls, (Object)tableModel.getDefinition(i));
        FillConditionsTableModelTestCase.assertTrue((boolean)tableModel.isSeparator(++i));
    }

    public void testMultipleEquivalentClasses() {
        OWLNamedClass aldiCls = this.owlModel.createOWLNamedClass("Aldi");
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality minRestriction = this.owlModel.createOWLMinCardinality(property, 1);
        OWLMaxCardinality maxRestriction = this.owlModel.createOWLMaxCardinality(property, 4);
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        tableModel.addRow(menschCls, 0);
        personCls.addEquivalentClass(minRestriction);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(maxRestriction);
        intersectionCls.addOperand(aldiCls);
        personCls.addEquivalentClass(intersectionCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", aldiCls, OWLMaxCardinality.class, "SUFFICIENT", menschCls, "SUFFICIENT", OWLMinCardinality.class, NECESSARY, this.owlThing});
    }

    public void testMultipleEquivalentClassesPreordered() {
        OWLNamedClass aldiCls = this.owlModel.createOWLNamedClass("Aldi");
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality minRestriction = this.owlModel.createOWLMinCardinality(property, 1);
        OWLMaxCardinality maxRestriction = this.owlModel.createOWLMaxCardinality(property, 4);
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(aldiCls);
        intersectionCls.addOperand(maxRestriction);
        tableModel.addRow(intersectionCls, 0);
        tableModel.addEmptyDefinitionBlock();
        tableModel.addRow(menschCls, 0);
        tableModel.addEmptyDefinitionBlock();
        tableModel.addRow(minRestriction, 0);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", aldiCls, OWLMaxCardinality.class, "SUFFICIENT", menschCls, "SUFFICIENT", OWLMinCardinality.class, NECESSARY, this.owlThing});
    }
}

