/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.editors;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.widget.HTMLEditorPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetUtil;
import java.awt.Component;

public class StringValueEditor
implements PropertyValueEditor {
    public boolean canEdit(RDFResource instance, RDFProperty property, Object value) {
        OWLModel owlModel = instance.getOWLModel();
        if (value != null) {
            if (value instanceof RDFSLiteral) {
                RDFSLiteral literal = (RDFSLiteral)value;
                return instance.getOWLModel().getXSDstring().equals(literal.getDatatype());
            }
            return value instanceof String;
        }
        for (RDFSNamedClass type : instance.getProtegeTypes()) {
            if (!OWLWidgetUtil.isDatatypeProperty(owlModel.getXSDstring(), type, property)) continue;
            return true;
        }
        return false;
    }

    public Object createDefaultValue(RDFResource instance, RDFProperty property) {
        OWLModel owlModel = instance.getOWLModel();
        String lang = owlModel.getDefaultLanguage();
        if (lang != null) {
            return owlModel.createRDFSLiteral("", lang);
        }
        return "";
    }

    public Object editValue(Component parent, RDFResource instance, RDFProperty property, Object value) {
        RDFSLiteral newLiteral;
        OWLModel owlModel = instance.getOWLModel();
        RDFSLiteral oldLiteral = null;
        oldLiteral = value instanceof String ? owlModel.createRDFSLiteral((String)value, owlModel.getXSDstring()) : (value instanceof RDFSLiteral ? (RDFSLiteral)value : owlModel.createRDFSLiteral("", owlModel.getXSDstring()));
        if (parent == null) {
            parent = ProtegeUI.getTopLevelContainer(property.getProject());
        }
        if ((newLiteral = HTMLEditorPanel.show(parent, oldLiteral, "Edit " + property.getBrowserText() + " at " + instance.getBrowserText(), instance.getOWLModel())) != null && !oldLiteral.equals(newLiteral)) {
            if (newLiteral.getLanguage() == null || newLiteral.getLanguage().length() == 0) {
                return newLiteral.getString();
            }
            return newLiteral;
        }
        return null;
    }

    public boolean mustEdit(RDFResource subject, RDFProperty predicate, Object value) {
        return false;
    }
}

