/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.actions.OWLModelAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class OWLModelActionAction
extends AbstractAction
implements Disposable {
    private OWLModel owlModel;
    private OWLModelAction owlModelAction;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            OWLModelActionAction.this.setEnabled(OWLModelActionAction.this.owlModelAction.isSuitable(OWLModelActionAction.this.owlModel));
        }
    };

    public OWLModelActionAction(OWLModelAction owlModelAction, OWLModel owlModel) {
        super(owlModelAction.getName(), OWLModelActionAction.getIcon(owlModelAction));
        this.owlModelAction = owlModelAction;
        this.owlModel = owlModel;
        this.setEnabled(owlModelAction.isSuitable(owlModel));
        owlModelAction.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void actionPerformed(ActionEvent e) {
        this.owlModelAction.run(this.owlModel);
    }

    public void dispose() {
        this.owlModelAction.removePropertyChangeListener(this.propertyChangeListener);
    }

    public static Icon getIcon(OWLModelAction owlModelAction) {
        Icon icon = Icons.getBlankIcon();
        String fileName = owlModelAction.getIconFileName();
        if (fileName != null) {
            Class<OWLIcons> c = owlModelAction.getIconResourceClass();
            if (c == null) {
                c = OWLIcons.class;
            }
            if (!fileName.endsWith(".gif") && !fileName.endsWith(".png")) {
                fileName = String.valueOf(fileName) + ".gif";
            }
            icon = OWLIcons.getImageIcon(fileName, c);
        }
        return icon;
    }
}

