/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplayFactory;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class UISettingsPanel
extends JComponent {
    private JRadioButton[] classDisplayButtons;
    private JCheckBox constraintCheckingCheckBox;
    private JCheckBox dragAndDropCheckBox;
    private JCheckBox externalResourcesCheckBox;
    private JComboBox iconsComboBox;
    private String initialStyle;
    private boolean initialDDValue;
    private OWLModel owlModel;

    public UISettingsPanel(OWLModel aOWLModel) {
        this.owlModel = aOWLModel;
        Class[] classes = OWLClassDisplayFactory.getAvailableDisplayClasses();
        this.classDisplayButtons = new JRadioButton[classes.length];
        JPanel radioButtonsPanel = new JPanel(new GridLayout(classes.length, 1));
        radioButtonsPanel.setBorder(BorderFactory.createTitledBorder("Class Display Format"));
        ButtonGroup group = new ButtonGroup();
        int i = 0;
        while (i < classes.length) {
            JRadioButton radioButton;
            final Class c = classes[i];
            String text = "";
            try {
                text = (String)c.getMethod("getUIDescription", new Class[0]).invoke((Object)c, new Object[0]);
            }
            catch (Exception e) {
                text = c.getName();
            }
            int index = text.lastIndexOf(".");
            text = text.substring(index + 1);
            this.classDisplayButtons[i] = radioButton = new JRadioButton(text);
            group.add(radioButton);
            if (OWLClassDisplayFactory.getDefaultDisplay().getClass() == c) {
                radioButton.setSelected(true);
            }
            radioButtonsPanel.add(radioButton);
            radioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OWLClassDisplay display = OWLClassDisplayFactory.getDisplay(c);
                    OWLClassDisplayFactory.setDefaultDisplay(display);
                    UISettingsPanel.this.owlModel.setOWLClassDisplay(display);
                }
            });
            ++i;
        }
        this.constraintCheckingCheckBox = new JCheckBox("Constraint checking (red borders) at edit time");
        this.constraintCheckingCheckBox.setSelected(OWLUI.isConstraintChecking(this.owlModel));
        this.constraintCheckingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OWLUI.setConstraintChecking(UISettingsPanel.this.owlModel, UISettingsPanel.this.constraintCheckingCheckBox.isSelected());
            }
        });
        this.dragAndDropCheckBox = new JCheckBox("Drag and Drop");
        this.dragAndDropCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISettingsPanel.this.updateDragAndDrop();
            }
        });
        this.initialDDValue = OWLUI.isDragAndDropSupported(aOWLModel);
        this.dragAndDropCheckBox.setSelected(this.initialDDValue);
        this.externalResourcesCheckBox = new JCheckBox("Allow the creation of external resources (untyped URIs)");
        this.externalResourcesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISettingsPanel.this.updateExternalResources();
            }
        });
        this.externalResourcesCheckBox.setSelected(OWLUI.isExternalResourcesSupported(aOWLModel));
        this.iconsComboBox = new JComboBox<Object>(new Object[]{"Default", "Multicolored"});
        this.initialStyle = OWLIcons.style;
        this.iconsComboBox.setSelectedItem(this.initialStyle);
        Dimension size = new Dimension(100, this.iconsComboBox.getPreferredSize().height);
        this.iconsComboBox.setMaximumSize(size);
        this.iconsComboBox.setPreferredSize(size);
        this.iconsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISettingsPanel.this.updateIconsStyle();
            }
        });
        JPanel leftPanel = new JPanel(new GridLayout(3, 1));
        leftPanel.setBorder(BorderFactory.createTitledBorder("User Interface Features"));
        leftPanel.add(this.dragAndDropCheckBox);
        leftPanel.add(this.constraintCheckingCheckBox);
        leftPanel.add(this.externalResourcesCheckBox);
        Box iconsPanel = Box.createHorizontalBox();
        iconsPanel.add(new JLabel("Icon Style: "));
        iconsPanel.add(this.iconsComboBox);
        iconsPanel.add(Box.createHorizontalGlue());
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add("North", radioButtonsPanel);
        rightPanel.add("Center", iconsPanel);
        this.setLayout(new BorderLayout(8, 0));
        this.add("Center", leftPanel);
        this.add("East", rightPanel);
    }

    private void updateExternalResources() {
        boolean enabled = this.externalResourcesCheckBox.isSelected();
        OWLUI.setExternalResourcesSupported(this.owlModel, enabled);
    }

    public boolean getRequiresReloadUI() {
        return this.initialDDValue != this.dragAndDropCheckBox.isSelected() || !this.initialStyle.equals(this.iconsComboBox.getSelectedItem());
    }

    private void updateDragAndDrop() {
        boolean enabled = this.dragAndDropCheckBox.isSelected();
        OWLUI.setDragAndDropSupported(this.owlModel, enabled);
    }

    private void updateIconsStyle() {
        String newStyle = (String)this.iconsComboBox.getSelectedItem();
        OWLIcons.setStyle(newStyle);
        ApplicationProperties.setString((String)OWLIcons.STYLE_VARIABLE, (String)newStyle);
    }
}

