/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.properties.range.FacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.OWLRangeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.AssigningTextField;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class StringFacetsPanel
extends FacetsPanel {
    private JTextField patternField;
    private JTextField minLengthField = new AssigningTextField(new AssigningTextField.Assign(){

        public void assign(String value) {
            StringFacetsPanel.this.assignNewType();
        }
    });
    private JTextField maxLengthField;

    public StringFacetsPanel(OWLRangeWidget rangeWidget) {
        super(rangeWidget);
        this.minLengthField.setHorizontalAlignment(4);
        this.maxLengthField = new AssigningTextField(new AssigningTextField.Assign(){

            public void assign(String value) {
                StringFacetsPanel.this.assignNewType();
            }
        });
        this.maxLengthField.setHorizontalAlignment(4);
        Box lengthBox = Box.createHorizontalBox();
        lengthBox.add(new JLabel("  Min: "));
        lengthBox.add(this.minLengthField);
        lengthBox.add(new JLabel("   Max: "));
        lengthBox.add(this.maxLengthField);
        OWLLabeledComponent lengthComponent = new OWLLabeledComponent("String Length", lengthBox);
        this.add("North", (Component)((Object)lengthComponent));
        this.patternField = new AssigningTextField(new AssigningTextField.Assign(){

            public void assign(String value) {
                StringFacetsPanel.this.assignNewType();
            }
        });
        OWLLabeledComponent patternComponent = new OWLLabeledComponent("Regular Expression", this.patternField);
        this.add("Center", (Component)((Object)patternComponent));
    }

    private void assignNewType() {
        RDFResource range;
        int maxLength = this.getInt(this.maxLengthField);
        int minLength = this.getInt(this.minLengthField);
        String pattern = this.patternField.getText().trim();
        if (pattern.length() == 0) {
            pattern = null;
        }
        if ((range = this.rangeWidget.getEditedProperty().getRange()) instanceof RDFSDatatype) {
            RDFSDatatype datatype = (RDFSDatatype)range;
            RDFSDatatype baseDatatype = datatype.getBaseDatatype();
            RDFSDatatype target = datatype;
            if (baseDatatype != null) {
                target = baseDatatype;
            }
            if (pattern == null && minLength < 0 && maxLength < 0) {
                this.rangeWidget.setRange(target);
            } else {
                OWLModel owlModel = this.rangeWidget.getOWLModel();
                RDFSDatatypeFactory factory = owlModel.getRDFSDatatypeFactory();
                if (!target.isEditable()) {
                    target = factory.createAnonymousDatatype(target);
                }
                if (pattern != null) {
                    factory.setPattern(target, pattern);
                }
                if (maxLength >= 0) {
                    if (maxLength == minLength) {
                        factory.setLength(target, maxLength);
                    } else {
                        factory.setMaxLength(target, maxLength);
                        if (minLength >= 0) {
                            factory.setMinLength(target, minLength);
                        }
                    }
                } else if (minLength >= 0) {
                    factory.setMinLength(target, minLength);
                }
                this.rangeWidget.setRange(target);
            }
        }
    }

    private int getInt(JTextField textField) {
        String text = textField.getText().trim();
        if (text.length() > 0) {
            try {
                return Integer.parseInt(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setEditable(boolean value) {
        this.patternField.setEditable(value);
    }

    public void update(RDFSDatatype datatype) {
        String pattern = datatype.getPattern();
        this.patternField.setText(pattern == null ? "" : pattern);
        int length = datatype.getLength();
        if (length >= 0) {
            this.maxLengthField.setText("" + length);
            this.minLengthField.setText("" + length);
        } else {
            int minLength = datatype.getMinLength();
            if (minLength >= 0) {
                this.minLengthField.setText("" + minLength);
            } else {
                this.minLengthField.setText("");
            }
            int maxLength = datatype.getMaxLength();
            if (maxLength >= 0) {
                this.maxLengthField.setText("" + maxLength);
            } else {
                this.maxLengthField.setText("");
            }
        }
    }
}

