/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.swrl.ui.SWRLProjectPlugin;
import edu.stanford.smi.protegex.owl.swrl.ui.actions.FindRulesAction;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesComponent;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.AddPropertyWidgetToFormAction;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.EditTypeAction;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.EditTypeFormAction;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.InstanceNameComponent;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.RemovePropertyWidgetFromFormAction;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplayPluginManager;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageAction;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestInstanceAction;
import edu.stanford.smi.protegex.owl.ui.widget.InferredModeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class ResourceDisplay
extends InstanceDisplay
implements ResourcePanel {
    public static final int DEFAULT_TYPE_CLS = 0;
    public static final int DEFAULT_TYPE_SLOT = 1;
    public static final int DEFAULT_TYPE_INSTANCE = 2;
    private AddPropertyWidgetToFormAction addPropertyWidgetToFormAction;
    private JComponent centerComponent;
    private int defaultType;
    private EditTypeAction editTypeAction;
    private EditTypeFormAction editTypeFormAction;
    private FindUsageAction findUsageAction;
    private FindRulesAction findRulesAction;
    private JCheckBox inferredBox;
    private static boolean inferredBoxVisible = true;
    private InstanceNameComponent instanceNameComponent;
    private JPanel mainPanel;
    private JToolBar northToolBar;
    private OWLModel owlModel;
    private RemovePropertyWidgetFromFormAction removePropertyWidgetFromFormAction;
    private JScrollPane scrollPane;
    public static final int SMALL_BUTTON_WIDTH = 15;
    private JPanel southEastPanel;
    private JToolBar southToolBar;
    private Set suppressedTypes = new HashSet();
    private OWLTestInstanceAction testInstanceAction;
    private TriplesComponent triplesComponent;
    private Set actionRefreshProperties;
    private PropertyValueListener propertyValueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource resource, RDFProperty property, Collection oldValues) {
            if (ResourceDisplay.this.actionRefreshProperties.contains(property)) {
                ResourceDisplay.this.initInstanceDisplayActions(resource);
            }
        }
    };

    public ResourceDisplay(Project project, boolean showHeader, boolean showHeaderLabel) {
        this(project);
    }

    public ResourceDisplay(Project project) {
        this(project, 2);
    }

    public ResourceDisplay(Project project, int defaultType) {
        super(project);
        this.defaultType = defaultType;
        this.owlModel = (OWLModel)project.getKnowledgeBase();
        this.reworkHeaderComponent();
        this.actionRefreshProperties = new HashSet();
        if (defaultType == 0) {
            this.actionRefreshProperties.add(this.owlModel.getRDFSSubClassOfProperty());
        }
        this.centerComponent = (JComponent)this.getComponent(0);
        this.remove(this.centerComponent);
        int i = 0;
        while (i < this.centerComponent.getComponentCount()) {
            if (this.centerComponent.getComponent(i) instanceof JScrollPane) {
                this.scrollPane = (JScrollPane)this.centerComponent.getComponent(i);
            }
            ++i;
        }
        this.northToolBar = OWLUI.createToolBar();
        this.northToolBar.setOpaque(false);
        Container titlePanel = (Container)this.getHeaderComponent().getComponent(0);
        titlePanel.add("East", this.northToolBar);
        this.findUsageAction = new FindUsageAction(this);
        this.findRulesAction = new FindRulesAction(this);
        OWLModel testManager = this.owlModel;
        this.testInstanceAction = new OWLTestInstanceAction(this.owlModel, testManager, this);
        this.testInstanceAction.setEnabled(false);
        this.suppressedTypes.add(this.owlModel.getOWLFunctionalPropertyClass());
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:AnnotationProperty"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:InverseFunctionalProperty"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:SymmetricProperty"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:TransitiveProperty"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:DeprecatedClass"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:DeprecatedProperty"));
        this.mainPanel = new JPanel(new BorderLayout());
        this.addDefaultComponentsToMainPanel();
        this.add(this.mainPanel);
        this.inferredBox = new JCheckBox("Inferred View");
        this.inferredBox.setVisible(inferredBoxVisible);
        this.inferredBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourceDisplay.this.setInferredMode(ResourceDisplay.this.inferredBox.isSelected());
            }
        });
        this.loadHeader();
    }

    private void addDefaultComponentsToMainPanel() {
        this.mainPanel.add("Center", this.centerComponent);
        this.southToolBar = ComponentFactory.createToolBar();
        this.southEastPanel = new JPanel();
        this.southEastPanel.setLayout(new BoxLayout(this.southEastPanel, 0));
        this.addDefaultToolBarButtons();
        JPanel fillerPanel = new JPanel(new BorderLayout());
        fillerPanel.add("Center", this.southToolBar);
        fillerPanel.add("East", this.southEastPanel);
        this.mainPanel.add("South", fillerPanel);
    }

    private void addDefaultToolBarButtons() {
        this.southToolBar.addSeparator(new Dimension(7, 0));
        ComponentFactory.addToolBarButton((JToolBar)this.southToolBar, (Action)((Object)this.findUsageAction));
        if (SWRLProjectPlugin.isSWRLImported(this.owlModel)) {
            this.southToolBar.addSeparator();
            ComponentFactory.addToolBarButton((JToolBar)this.southToolBar, (Action)((Object)this.findRulesAction));
        }
        this.southToolBar.addSeparator();
        ComponentFactory.addToolBarButton((JToolBar)this.southToolBar, (Action)this.testInstanceAction);
    }

    public void addSelectionListener(SelectionListener listener) {
    }

    public void clearSelection() {
    }

    protected void reworkHeaderComponent() {
        if (this.defaultType != 3) {
            this.instanceNameComponent = new InstanceNameComponent();
            HeaderComponent hc = this.getHeaderComponent();
            JComponent comp = hc.getComponent();
            Container cont = comp.getParent();
            cont.remove(comp);
            cont.add("Center", this.instanceNameComponent);
        }
    }

    public boolean displayHostInstance(Instance instance) {
        if (instance instanceof RDFResource) {
            return this.displayHostResource((RDFResource)instance);
        }
        return false;
    }

    public boolean displayHostResource(RDFResource resource) {
        Object comp = this;
        while (comp != null) {
            if (!((comp = ((Component)comp).getParent()) instanceof HostResourceDisplay)) continue;
            return ((HostResourceDisplay)comp).displayHostResource(resource);
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.triplesComponent != null) {
            this.triplesComponent.dispose();
        }
    }

    protected InstanceNameComponent getInstanceNameComponent() {
        return this.instanceNameComponent;
    }

    public Dimension getPreferredSize() {
        return this.mainPanel.getPreferredSize();
    }

    public RDFResource getResource() {
        Instance instance = this.getCurrentInstance();
        if (instance instanceof RDFResource) {
            return (RDFResource)instance;
        }
        return null;
    }

    public Collection getSelection() {
        if (this.getCurrentInstance() != null) {
            return Collections.singleton(this.getCurrentInstance());
        }
        return Collections.EMPTY_LIST;
    }

    protected ClsWidget getWidget(Cls type, Instance instance, Cls associatedCls) {
        if (this.isSuppressedType(type)) {
            return null;
        }
        return super.getWidget(type, instance, associatedCls);
    }

    private void initInstanceDisplayActions(RDFResource resource) {
        this.findUsageAction.setEnabled(resource != null);
        this.findRulesAction.setEnabled(resource != null);
        this.testInstanceAction.setEnabled(resource != null);
        this.southToolBar.removeAll();
        this.southEastPanel.removeAll();
        this.addDefaultToolBarButtons();
        if (resource != null) {
            ResourceActionManager.addResourceActions(this.southToolBar, (Component)((Object)this), resource);
            ResourceDisplayPluginManager.initInstanceDisplay(resource, this.southEastPanel);
        }
        this.removeYellowStickyButtons();
        this.northToolBar.removeAll();
        this.editTypeAction = new EditTypeAction(resource);
        this.editTypeFormAction = new EditTypeFormAction(resource);
        this.addPropertyWidgetToFormAction = new AddPropertyWidgetToFormAction(resource, this);
        this.removePropertyWidgetFromFormAction = new RemovePropertyWidgetFromFormAction(resource, this);
        JButton addSlotWidgetToFormButton = ComponentFactory.addToolBarButton((JToolBar)this.northToolBar, (Action)this.addPropertyWidgetToFormAction, (int)15);
        addSlotWidgetToFormButton.setOpaque(false);
        this.addPropertyWidgetToFormAction.activateComboBox(addSlotWidgetToFormButton);
        JButton removeSlotWidgetFromFormAction = ComponentFactory.addToolBarButton((JToolBar)this.northToolBar, (Action)this.removePropertyWidgetFromFormAction, (int)15);
        removeSlotWidgetFromFormAction.setOpaque(false);
        this.removePropertyWidgetFromFormAction.activateComboBox(removeSlotWidgetFromFormAction);
        ComponentFactory.addToolBarButton((JToolBar)this.northToolBar, (Action)this.editTypeFormAction, (int)15).setOpaque(false);
        ComponentFactory.addToolBarButton((JToolBar)this.northToolBar, (Action)this.editTypeAction, (int)15).setOpaque(false);
        boolean enabled = false;
        if (resource != null) {
            enabled = resource.isEditable();
        }
        this.addPropertyWidgetToFormAction.setEnabled(enabled);
        this.removePropertyWidgetFromFormAction.setEnabled(enabled);
        boolean viewEnabled = resource != null;
        this.editTypeAction.setEnabled(viewEnabled);
        this.editTypeFormAction.setEnabled(viewEnabled);
    }

    protected boolean isSuppressedType(Cls type) {
        return this.suppressedTypes.contains(type);
    }

    public boolean isTriplesDisplayed() {
        return this.scrollPane.getParent() == null;
    }

    protected void loadHeader() {
        if (this.getCurrentInstance() == null) {
            switch (this.defaultType) {
                case 0: {
                    this.loadHeaderWithCls(null);
                    break;
                }
                case 1: {
                    this.loadHeaderWithSlot(null);
                    break;
                }
                case 3: {
                    this.loadHeaderWithOntology(null);
                    break;
                }
                default: {
                    this.loadHeaderWithSimpleInstance(null);
                    break;
                }
            }
        } else {
            if (this.getCurrentInstance() instanceof OWLNamedClass) {
                this.getHeaderComponent().add("East", (Component)this.inferredBox);
            }
            super.loadHeader();
        }
    }

    protected void loadHeaderLabel(Instance instance) {
        RDFResource RDFResource2;
        Collection inf;
        if (this.instanceNameComponent != null) {
            this.instanceNameComponent.setInstance(instance);
        } else {
            super.loadHeaderLabel(instance);
        }
        if (instance instanceof RDFResource && !(inf = (RDFResource2 = (RDFResource)instance).getInferredTypes()).isEmpty()) {
            JLabel label = this.getHeaderLabel();
            String str = "  (inferred types: ";
            Iterator it = inf.iterator();
            while (it.hasNext()) {
                RDFSClass cls = (RDFSClass)it.next();
                str = String.valueOf(str) + cls.getBrowserText();
                if (!it.hasNext()) continue;
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + ")";
            label.setText(String.valueOf(label.getText()) + str);
        }
    }

    protected void loadHeaderWithSimpleInstance(Instance instance) {
        super.loadHeaderWithSimpleInstance(instance);
        this.getHeaderComponent().setTitle("Individual Editor");
        this.getHeaderComponent().setComponentLabel("For Individual:");
    }

    protected void loadHeaderWithSlot(Slot slot) {
        super.loadHeaderWithSlot(slot);
        this.getHeaderComponent().setTitle("Property Editor");
        this.getHeaderComponent().setComponentLabel("For Property:");
    }

    protected void loadHeaderWithOntology(OWLOntology owlOntology) {
        super.loadHeaderWithSimpleInstance((Instance)owlOntology);
        this.getHeaderComponent().setTitle("Ontology Editor");
        this.getHeaderComponent().setComponentLabel("For Ontology:");
        this.getHeaderComponent().setColor(Colors.getInstanceColor());
    }

    public void notifySelectionListeners() {
    }

    protected void onDirectTypeAdded(Cls type) {
        if (!this.isSuppressedType(type)) {
            super.onDirectTypeAdded(type);
        } else {
            this.loadHeader();
        }
    }

    protected void onDirectTypeRemoved(Cls type) {
        if (!this.isSuppressedType(type)) {
            super.onDirectTypeRemoved(type);
        } else {
            this.loadHeader();
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
    }

    private void removeYellowStickyButtons() {
        this.getHeaderComponent().getToolBar().removeAll();
    }

    public void setInferredMode(boolean value) {
        if (value) {
            this.inferredBox.setVisible(true);
            inferredBoxVisible = true;
        }
        if (this.inferredBox.isSelected() != value) {
            this.inferredBox.setSelected(value);
        }
        Container root = (Container)this.getFirstClsWidget();
        this.setInferredMode(value, root);
    }

    private void setInferredMode(boolean value, Container cont) {
        int i = 0;
        while (i < cont.getComponentCount()) {
            Component comp = cont.getComponent(i);
            if (comp instanceof InferredModeWidget) {
                ((InferredModeWidget)((Object)comp)).setInferredMode(value);
            }
            if (comp instanceof Container) {
                this.setInferredMode(value, (Container)comp);
            }
            ++i;
        }
    }

    public void setMode(boolean formView, boolean triplesView) {
        JComponent newComponent = null;
        if (formView) {
            if (triplesView) {
                this.updateTriplesComponent();
                JSplitPane splitPane = new JSplitPane(0, this.scrollPane, this.triplesComponent);
                splitPane.setDividerLocation(0.5);
                newComponent = splitPane;
            } else {
                newComponent = this.scrollPane;
            }
        } else {
            this.updateTriplesComponent();
            newComponent = this.triplesComponent;
        }
        this.centerComponent.removeAll();
        this.centerComponent.add("North", (Component)this.getHeaderComponent());
        this.centerComponent.add("Center", newComponent);
        this.revalidate();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.mainPanel.setBounds(0, 0, width, height);
    }

    public void setInstance(Instance instance) {
        if (this.getCurrentInstance() instanceof RDFResource) {
            ((RDFResource)this.getCurrentInstance()).removePropertyValueListener(this.propertyValueListener);
        }
        if (instance instanceof RDFResource) {
            ((RDFResource)instance).addPropertyValueListener(this.propertyValueListener);
        }
        super.setInstance(instance);
        if (this.triplesComponent != null) {
            if (instance instanceof RDFResource) {
                this.triplesComponent.setSubject((RDFResource)instance);
                this.triplesComponent.setVisible(true);
            } else {
                this.triplesComponent.setSubject(null);
                this.triplesComponent.setVisible(false);
            }
        }
        this.initInstanceDisplayActions(instance instanceof RDFResource ? (RDFResource)instance : null);
    }

    public void setInstance(Instance instance, Cls associatedCls) {
        super.setInstance(instance, associatedCls);
        this.initInstanceDisplayActions(instance instanceof RDFResource ? (RDFResource)instance : null);
    }

    public void setResource(RDFResource resource) {
        this.setInstance(resource);
    }

    protected boolean shouldDisplaySlot(Cls cls, Slot slot) {
        return !(slot instanceof RDFProperty) || ((RDFProperty)slot).isDomainDefined();
    }

    public void updateInferredModeOfWidgets() {
        this.setInferredMode(this.inferredBox.isSelected(), (Container)((Object)this));
    }

    private void updateTriplesComponent() {
        if (this.triplesComponent == null) {
            this.triplesComponent = new TriplesComponent(this.owlModel.getOWLVersionInfoProperty());
        }
        this.triplesComponent.setSubject((RDFResource)this.getCurrentInstance());
    }
}

