/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.search.finder.AbstractFindAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.AbstractFindResultsView;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResultsPanel;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResultsViewModelFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Icon;
import javax.swing.JDialog;

public class FindInDialogAction
extends AbstractFindAction {
    private static Dimension savedSize = new Dimension(400, 200);
    AbstractFindResultsView view;
    FindResultsPanel resultsPanel;

    public FindInDialogAction(ResultsViewModelFind find, Icon icon, HostResourceDisplay hrd, boolean allowSave) {
        super(find, icon, hrd, allowSave);
    }

    protected void showResults(AbstractFindResultsView view) {
        this.view = view;
        this.resultsPanel = new FindResultsPanel(this.find, view);
        this.find.addResultListener(new SearchAdapter(){

            public void searchEvent(Find source) {
                FindInDialogAction.this.rename(source.getSummaryText());
            }
        });
        this.resultsPanel.setPreferredSize(savedSize);
        this.resultsPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                savedSize.setSize(e.getComponent().getWidth(), e.getComponent().getHeight());
            }
        });
        this.resultsPanel.setSaveResultsEnabled(this.allowSave);
        Component win = ProtegeUI.getTopLevelContainer(ProjectManager.getProjectManager().getCurrentProject());
        ModalDialogFactory fac = ProtegeUI.getModalDialogFactory();
        int result = fac.showDialog(win, this.resultsPanel, this.find.getSummaryText(), 11, new ModalDialogFactory.CloseCallback(){

            public boolean canClose(int result) {
                boolean canClose = true;
                if (result == 1) {
                    canClose = FindInDialogAction.this.view.getSelectedResource() != null;
                }
                return canClose;
            }
        });
        switch (result) {
            case 1: {
                this.resultsPanel.selectResource();
                break;
            }
            case 4: {
                this.find.cancelSearch();
            }
        }
    }

    private void rename(String name) {
        try {
            JDialog dialog = (JDialog)this.resultsPanel.getTopLevelAncestor();
            if (dialog != null) {
                dialog.setTitle(name);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

