/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.triplestore;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIField;
import edu.stanford.smi.protege.util.Validatable;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AddTripleStorePanel
extends JPanel
implements Validatable {
    private OWLModel owlModel;
    private JTextField prefixField;
    protected URIField uriField;

    protected AddTripleStorePanel(OWLModel owlModel) {
        this(owlModel, "Prefix");
    }

    protected AddTripleStorePanel(OWLModel owlModel, String prefixTitle) {
        this.owlModel = owlModel;
        try {
            URI uri = new URI("http://www.owl-ontologies.com/submodel.owl");
            this.uriField = new URIField("Ontology name (URI)", uri, ".owl", "");
            this.prefixField = new JTextField("submodel");
            JPanel mainPanel = new JPanel(new GridLayout(3, 1));
            mainPanel.add((Component)this.uriField);
            mainPanel.add((Component)new LabeledComponent(prefixTitle, (Component)this.prefixField));
            this.setLayout(new BorderLayout(0, 16));
            this.add("Center", mainPanel);
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
        }
    }

    protected String getNamespaceFromURI(URI uri) {
        String namespace = uri.toString();
        return Jena.getNamespaceFromURI(namespace);
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    protected String getPrefix() {
        return this.prefixField.getText();
    }

    protected URI getURI() {
        return this.uriField.getAbsoluteURI();
    }

    public void saveContents() {
    }

    protected void setPrefix(String prefix) {
        this.prefixField.setText(prefix);
    }

    public boolean validateContents() {
        URI uri = this.getURI();
        if (uri != null) {
            String uriString = uri.toString();
            TripleStoreModel tsm = this.owlModel.getTripleStoreModel();
            if (tsm.getTripleStore(uriString) == null) {
                String prefix = this.getPrefix();
                if (prefix != null) {
                    String namespace = this.owlModel.getNamespaceManager().getNamespaceForPrefix(prefix);
                    String nuri = this.getNamespaceFromURI(uri);
                    if (namespace == null || namespace.equals(nuri)) {
                        return true;
                    }
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Prefix \"" + prefix + "\" is already used.");
                } else {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Invalid Prefix.");
                }
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Model with this URI already exists:\n" + uriString);
            }
        } else {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Invalid URI.");
        }
        return false;
    }
}

