/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.triplestore;

import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.triplestore.CreateTripleStorePanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;

public class SplitClassesIntoImportedTripleStorePanel
extends CreateTripleStorePanel {
    private static final String HELP_TITLE = "How to split an ontology?";
    private static final String HELP_TEXT = "<P>It is a common design pattern to have a schema/ontology file (consisting of classes and properties) and one of more individuals files, which instantiate the ontology.  The instance file(s) will import the classes file.  This function will extract all classes and properties from your project into an imported ontology file.</P><P><strong>Ontology URI</strong>: Specifies the address of the new classes ontology.</P><P><strong>Local File</strong>: Specified the file to where the classes will be written into.</P><P><strong>Prefix</strong>: The prefix of the classes when used as import.</P>";

    public SplitClassesIntoImportedTripleStorePanel(OWLModel owlModel) {
        super(owlModel);
    }

    protected TripleStore performAction() {
        TripleStoreModel tripleStoreModel = this.getOWLModel().getTripleStoreModel();
        TripleStore oldActiveTS = tripleStoreModel.getActiveTripleStore();
        TripleStore tripleStore = super.performAction();
        TripleStoreUtil.switchTripleStore(this.getOWLModel(), oldActiveTS);
        if (tripleStore != null) {
            ArrayList<RDFResource> resourcesToMove = new ArrayList<RDFResource>();
            TripleStore activeTS = tripleStoreModel.getActiveTripleStore();
            Iterator resources = activeTS.listHomeResources();
            while (resources.hasNext()) {
                RDFResource resource = (RDFResource)resources.next();
                if (!(resource instanceof RDFSClass) && !(resource instanceof RDFProperty) && !(resource instanceof OWLDataRange) && !(resource instanceof RDFList)) continue;
                resourcesToMove.add(resource);
            }
            TripleStoreUtil.moveResources(resourcesToMove, activeTS, tripleStore);
            tripleStoreModel.setActiveTripleStore(tripleStore);
            String prefix = this.getPrefix();
            for (RDFResource resource : resourcesToMove) {
                if (resource.isAnonymous() || resource.getName().indexOf(58) >= 0) continue;
                String newName = String.valueOf(prefix) + ":" + resource.getName();
                if (this.getOWLModel().getRDFResource(newName) != null) continue;
                resource.setName(newName);
            }
            tripleStoreModel.setActiveTripleStore(oldActiveTS);
            tripleStoreModel.updateEditableResourceState();
            ProtegeUI.reloadUI(this.getOWLModel().getProject());
        }
        return tripleStore;
    }

    public static void showDialog(OWLModel owlModel) {
        SplitClassesIntoImportedTripleStorePanel panel = new SplitClassesIntoImportedTripleStorePanel(owlModel);
        JComponent helpPanel = OWLUI.createHelpPanel(HELP_TEXT, HELP_TITLE);
        panel.add("South", helpPanel);
        helpPanel.setPreferredSize(new Dimension(600, 150));
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(owlModel.getProject()), panel, "Move Classes into Imported Sub-Ontology", 11) == 1) {
            panel.performAction();
        }
    }
}

