/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OWLFormWidget
extends FormWidget {
    public static final String DISABLED_BY_USER = "DisabledByUser";

    protected Cls getCustomizedParent(Cls cls) {
        return this.getCustomizedParent(cls, new HashSet());
    }

    protected Cls getCustomizedParent(Cls cls, Set reached) {
        reached.add(cls);
        Project project = cls.getProject();
        Cls customizedParent = null;
        Iterator i = cls.getDirectSuperclasses().iterator();
        while (i.hasNext() && customizedParent == null) {
            Cls parent = (Cls)i.next();
            if (parent instanceof OWLAnonymousClass || reached.contains(parent)) continue;
            if (project.hasCustomizedDescriptor(parent)) {
                customizedParent = parent;
                break;
            }
            customizedParent = this.getCustomizedParent(parent, reached);
            break;
        }
        return customizedParent;
    }

    protected Collection getClsSlots() {
        Cls cls = this.getCls();
        if (cls instanceof RDFSNamedClass) {
            RDFSNamedClass namedClass = (RDFSNamedClass)cls;
            OWLModel owlModel = namedClass.getOWLModel();
            HashSet<Slot> properties = namedClass.getAssociatedProperties();
            properties = new HashSet<Slot>(owlModel.getVisibleResources(properties.iterator()));
            for (String name : this.getPropertyList().getNames()) {
                Slot property;
                if (name == null || (property = this.getKnowledgeBase().getSlot(name)) == null) continue;
                properties.add(property);
            }
            return properties;
        }
        return super.getClsSlots();
    }

    protected boolean isSuitable(WidgetDescriptor d, Cls cls, Slot slot) {
        if (slot instanceof RDFProperty && cls instanceof RDFSNamedClass) {
            String className = d.getWidgetClassName();
            if (className != null && OWLWidgetMapper.isIncompatibleWidgetName(className)) {
                return false;
            }
            Boolean disabledByUser = d.getPropertyList().getBoolean(DISABLED_BY_USER);
            if (className == null && !Boolean.TRUE.equals(disabledByUser)) {
                RDFProperty owlProperty = (RDFProperty)slot;
                RDFSNamedClass namedClass = (RDFSNamedClass)cls;
                if (!owlProperty.isDomainDefined()) {
                    return !OWLWidgetUtil.isRestrictedProperty(namedClass, owlProperty);
                }
            }
        }
        return super.isSuitable(d, cls, slot);
    }

    protected void onTemplateSlotAdded(Cls cls, Slot slot) {
        WidgetMapper widgetMapper = cls.getProject().getWidgetMapper();
        String name = widgetMapper.getDefaultWidgetClassName(cls, slot, null);
        if (name == null) {
            return;
        }
        super.onTemplateSlotAdded(cls, slot);
    }

    protected void onTemplateFacetValueChanged(Cls cls, Slot slot, Facet facet) {
        if (this.hasWidgetDescriptor(slot)) {
            super.onTemplateFacetValueChanged(cls, slot, facet);
        }
    }

    protected void onTemplateSlotRemoved(Cls cls, Slot slot) {
        if (this.hasWidgetDescriptor(slot)) {
            super.onTemplateSlotRemoved(cls, slot);
        }
    }

    public void reload() {
        if (!"owl:Ontology".equals(this.getCls().getName())) {
            super.reload();
        }
    }

    public void replaceSelectedWidget(String newWidgetClassName) {
        Collection sels = this.getSelection();
        super.replaceSelectedWidget(newWidgetClassName);
        if (sels.size() == 1) {
            AbstractSlotWidget slotWidget = (AbstractSlotWidget)sels.iterator().next();
            slotWidget.getDescriptor().getPropertyList().setBoolean(DISABLED_BY_USER, newWidgetClassName == null);
        }
    }
}

