/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFAxiomRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class OWLModelOrderedContentWriter
implements RDFXMLContentWriter {
    private OWLModel model;
    private TripleStore tripleStore;
    private Comparator comparator;

    public OWLModelOrderedContentWriter(OWLModel model, TripleStore tripleStore, Comparator comparator) {
        this.model = model;
        this.tripleStore = tripleStore;
        this.comparator = comparator;
    }

    protected Collection getResources() {
        TreeSet<RDFResource> resources = new TreeSet<RDFResource>(this.comparator);
        Iterator it = this.tripleStore.listHomeResources();
        while (it.hasNext()) {
            RDFResource curRes = (RDFResource)it.next();
            if (curRes.isSystem() || curRes.isAnonymous()) continue;
            resources.add(curRes);
        }
        for (RDFProperty curProp : this.model.getRDFProperties()) {
            Iterator subjIt = this.tripleStore.listSubjects(curProp);
            while (subjIt.hasNext()) {
                RDFResource curSubj;
                Object subj = subjIt.next();
                if (!(subj instanceof RDFResource) || (curSubj = (RDFResource)subj).isAnonymous() || curSubj.isSystem() || resources.contains(curSubj)) continue;
                resources.add(curSubj);
            }
        }
        return resources;
    }

    public void writeContent(XMLWriter writer) throws IOException {
        HashSet<RDFResource> renderedResources = new HashSet<RDFResource>();
        for (OWLOntology ont : this.model.getOWLOntologies()) {
            if (!ont.getOWLModel().getTripleStoreModel().getHomeTripleStore(ont).equals(this.tripleStore)) continue;
            RDFResourceRenderer renderer = new RDFResourceRenderer(ont, this.tripleStore, writer);
            renderer.write();
            renderedResources.add(ont);
        }
        for (OWLAllDifferent curAllDifferent : this.model.getOWLAllDifferents()) {
            if (!this.model.getTripleStoreModel().getHomeTripleStore(curAllDifferent).equals(this.tripleStore)) continue;
            RDFResourceRenderer ren = new RDFResourceRenderer(curAllDifferent, this.tripleStore, writer);
            ren.write();
            renderedResources.add(curAllDifferent);
        }
        for (RDFResource curRes : this.getResources()) {
            RDFAxiomRenderer axiomRenderer = new RDFAxiomRenderer(curRes, this.tripleStore, writer);
            axiomRenderer.write();
            renderedResources.add(curRes);
        }
    }
}

