/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.util;

import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.Visitable;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.InlineResourceChecker;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterNamespaceManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public class Util {
    private static HashSet excludedPropertyNames = new HashSet();

    static {
        excludedPropertyNames.add("rdfs:subClassOf");
        excludedPropertyNames.add("owl:equivalentClass");
        excludedPropertyNames.add("rdf:type");
        excludedPropertyNames.add("protege:classificationStatus");
        excludedPropertyNames.add("protege:inferredSuperclassOf");
        excludedPropertyNames.add("protege:inferredSubclassOf");
        excludedPropertyNames.add("protege:inferredType");
        excludedPropertyNames.add("owl:distinctMembers");
        excludedPropertyNames.add("owl:allValuesFrom");
        excludedPropertyNames.add("owl:cardinality");
        excludedPropertyNames.add("owl:complementOf");
        excludedPropertyNames.add("owl:hasValue");
        excludedPropertyNames.add("owl:intersectionOf");
        excludedPropertyNames.add("owl:maxCardinality");
        excludedPropertyNames.add("owl:minCardinality");
        excludedPropertyNames.add("owl:onProperty");
        excludedPropertyNames.add("owl:oneOf");
        excludedPropertyNames.add("owl:someValuesFrom");
        excludedPropertyNames.add("owl:unionOf");
        excludedPropertyNames.add("owl");
        excludedPropertyNames.add(":OWL-ONTOLOGY-PREFIXES");
        excludedPropertyNames.add("owl:imports");
        excludedPropertyNames.add("rdfs:domain");
    }

    public static boolean isExcludedProperty(RDFProperty property) {
        return excludedPropertyNames.contains(property.getName());
    }

    public static void insertProperties(RDFResource resource, TripleStore tripleStore, XMLWriter writer) throws IOException {
        for (RDFProperty curProp : resource.getRDFProperties()) {
            if (excludedPropertyNames.contains(curProp.getName())) continue;
            for (Object curVal : resource.getPropertyValues(curProp)) {
                if (!tripleStore.contains(resource, curProp, curVal)) continue;
                if (curVal instanceof RDFResource || curVal instanceof RDFExternalResource) {
                    Util.insertResourceAsElement(curProp, writer);
                    Visitable valRes = (Visitable)curVal;
                    Util.inlineObject(valRes, tripleStore, writer);
                    writer.writeEndElement();
                    continue;
                }
                Util.insertResourceAsElement(curProp, writer);
                RDFSLiteral literal = resource.getOWLModel().asRDFSLiteral(curVal);
                if (literal.getLanguage() != null) {
                    writer.writeAttribute("xml:lang", literal.getLanguage());
                } else {
                    writer.writeAttribute("rdf:datatype", literal.getDatatype().getURI());
                }
                writer.writeTextContent(literal.toString());
                writer.writeEndElement();
            }
        }
    }

    public static void inlineObject(Visitable object, TripleStore tripleStore, XMLWriter writer) throws IOException {
        InlineResourceChecker inlineResourceChecker = new InlineResourceChecker();
        object.accept(inlineResourceChecker);
        if (inlineResourceChecker.isCanInline()) {
            if (object instanceof RDFResource) {
                RDFResource rdfRes = (RDFResource)object;
                Util.insertResourceAttribute(rdfRes, writer);
            } else if (object instanceof RDFExternalResource) {
                writer.writeAttribute("rdf:resource", ((RDFExternalResource)object).getResourceURI());
            }
        } else {
            new RDFResourceRenderer(object, tripleStore, writer).write();
        }
    }

    public static void insertAboutAttribute(RDFResource resource, XMLWriter writer) throws IOException {
        writer.writeAttribute("rdf:about", Util.getResourceAttributeName(resource, writer));
    }

    public static void insertIDOrAboutAttribute(RDFResource resource, TripleStore tripleStore, XMLWriter writer) throws IOException {
        String name = Util.getResourceAttributeName(resource, writer);
        if (name.startsWith("#")) {
            writer.writeAttribute("rdf:ID", name.substring(1, name.length()));
        } else {
            writer.writeAttribute("rdf:about", name);
        }
    }

    public static void insertResourceAttribute(RDFResource resource, XMLWriter writer) throws IOException {
        writer.writeAttribute("rdf:resource", Util.getResourceAttributeName(resource, writer));
    }

    public static String getResourceAttributeName(RDFResource resource, XMLWriter writer) {
        String name = resource.getURI().startsWith(writer.getXMLBase()) ? resource.getURI().substring(writer.getXMLBase().length(), resource.getURI().length()) : resource.getURI();
        return name;
    }

    public static void insertResourceAsElement(RDFResource resource, XMLWriter writer) throws IOException {
        String tagName = "rdf:resource";
        if (writer.getDefaultNamespace().equals(resource.getNamespace())) {
            tagName = resource.getLocalName();
        } else {
            String prefix = writer.getNamespacePrefixes().getPrefixForNamespace(resource.getNamespace());
            tagName = String.valueOf(prefix) + ":" + resource.getLocalName();
        }
        writer.writeStartElement(tagName);
    }

    public static boolean isInDefaultNamespace(RDFResource resource, XMLWriter writer) {
        return writer.getNamespacePrefixes().getDefaultNamespace().equals(resource.getNamespace());
    }

    public static XMLWriterNamespaceManager getNamespacePrefixes(NamespaceManager nsm, String defaultNamespace) {
        XMLWriterNamespaceManager xmlWriterNamespaceManager = new XMLWriterNamespaceManager(defaultNamespace);
        for (String curPrefix : nsm.getPrefixes()) {
            String curNamespace = nsm.getNamespaceForPrefix(curPrefix);
            if (curNamespace.equals(defaultNamespace)) continue;
            xmlWriterNamespaceManager.setPrefix(curPrefix, nsm.getNamespaceForPrefix(curPrefix));
        }
        if (!nsm.getDefaultNamespace().equals(defaultNamespace)) {
            xmlWriterNamespaceManager.createPrefixForNamespace(nsm.getDefaultNamespace());
        }
        return xmlWriterNamespaceManager;
    }

    public static void renderTypes(RDFResource resource, TripleStore tripleStore, RDFResource excludeType, XMLWriter writer) throws IOException {
        RDFProperty prop = resource.getOWLModel().getRDFProperty("rdf:type");
        Iterator it = tripleStore.listObjects(resource, prop);
        while (it.hasNext()) {
            RDFResource curType = (RDFResource)it.next();
            if (curType.equals(excludeType)) continue;
            writer.writeStartElement("rdf:type");
            Util.inlineObject(curType, tripleStore, writer);
            writer.writeEndElement();
        }
    }

    public static RDFResource getType(RDFResource resource, TripleStore ts) {
        RDFResource type = null;
        RDFProperty typeProp = resource.getOWLModel().getRDFProperty("rdf:type");
        Iterator it = ts.listObjects(resource, typeProp);
        while (it.hasNext()) {
            RDFResource curType = (RDFResource)it.next();
            if (curType.isAnonymous()) continue;
            type = curType;
            break;
        }
        return type;
    }

    public static String getOntologyName(OWLModel model, TripleStore tripleStore) {
        for (OWLOntology ont : model.getOWLOntologies()) {
            if (!model.getTripleStoreModel().getHomeTripleStore(ont).equals(tripleStore)) continue;
            return ont.getURI();
        }
        return "<null>";
    }
}

