/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.log;

import edu.stanford.smi.protegex.owl.inference.protegeowl.log.MessageLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ErrorMessageLogRecord
extends MessageLogRecord {
    public ErrorMessageLogRecord(RDFResource cause, String message, ReasonerLogRecord parent) {
        super(cause, message, parent);
        String causeText;
        if (cause != null) {
            OWLNamedClass namedCls;
            causeText = cause.getBrowserText();
            if (cause instanceof OWLAnonymousClass && (namedCls = ReasonerUtil.getInstance().getNamedReferent((OWLAnonymousClass)cause)) != null) {
                causeText = String.valueOf(causeText) + " (on <font color=\"000000\">" + namedCls.getBrowserText() + "</font>)";
            }
        } else {
            causeText = " (Unknown)";
        }
        JLabel label = this.getJLabel();
        label.setIcon(OWLIcons.getOWLTestErrorIcon());
        label.setText("<html><body color=\"6E6E6E\"><font color=\"ff6600\">ERROR<br></font><font color=\"ff6600\">CAUSE: </font><font color=\"000000\">" + causeText + "</font><br>" + this.getHTMLMessage() + "</body></html>");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }
}

