/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.CollectionResultReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Document;

public abstract class AbstractSingleConceptWithConceptCollectionResultTask
extends AbstractReasonerTask
implements CollectionResultReasonerTask {
    private OWLClass aClass;
    private ProtegeOWLReasoner protegeOWLReasoner;
    private HashSet parents;
    private String taskDesciption;

    public AbstractSingleConceptWithConceptCollectionResultTask(String taskDescription, OWLClass aClass, ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.taskDesciption = taskDescription;
        this.aClass = aClass;
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.parents = new HashSet();
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        this.setDescription(this.taskDesciption);
        this.setMessage("Building reasoner query...");
        this.setProgress(0);
        this.doAbortCheck();
        Document doc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.createQuery(doc);
        this.setMessage("Querying reasoner...");
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(doc);
        this.doAbortCheck();
        Iterator it = this.getTranslator().getDIGQueryResponseIterator(this.protegeOWLReasoner.getKnowledgeBase(), responseDoc);
        while (it.hasNext()) {
            DIGQueryResponse response = (DIGQueryResponse)it.next();
            this.parents.addAll(response.getConcepts());
        }
        ReasonerLogRecordFactory factory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord parentRecord = factory.createInformationMessageLogRecord("Concepts", null);
        this.postLogRecord(parentRecord);
        it = this.parents.iterator();
        while (it.hasNext()) {
            this.postLogRecord(factory.createOWLInstanceLogRecord((RDFResource)it.next(), parentRecord));
        }
        this.setProgress(1);
        this.doAbortCheck();
        this.setTaskCompleted();
    }

    public Collection getResult() {
        return this.parents;
    }

    public abstract void createQuery(Document var1) throws DIGReasonerException;

    protected RDFSClass getCls() {
        return this.aClass;
    }

    protected ProtegeOWLReasoner getProtegeOWLReasoner() {
        return this.protegeOWLReasoner;
    }
}

