/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.w3c.dom.Document;

public class UpdateInferredTypesTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public UpdateInferredTypesTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getIndividuals(this.protegeOWLReasoner.getKnowledgeBase()).size();
    }

    public void run() throws DIGReasonerException {
        OWLModel kb = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecordFactory logRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord parentRecord = logRecordFactory.createInformationMessageLogRecord("Computing inferred types", null);
        this.postLogRecord(parentRecord);
        this.setDescription("Computing inferred types");
        this.setMessage("Building reasoner query");
        TimeDifference td = new TimeDifference();
        td.markStart();
        Document doc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        for (RDFIndividual curInd : ReasonerUtil.getInstance().getIndividuals(kb)) {
            this.getTranslator().createIndividualTypesQuery(doc, curInd.getName(), curInd);
        }
        td.markEnd();
        this.postLogRecord(logRecordFactory.createInformationMessageLogRecord("Time to build query = " + td, parentRecord));
        this.setMessage("Querying reasoner...");
        td.markStart();
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(doc);
        td.markEnd();
        this.postLogRecord(logRecordFactory.createInformationMessageLogRecord("Time to query reasoner = " + td, parentRecord));
        this.setMessage("Updating Protege-OWL...");
        td.markStart();
        kb.setGenerateEventsEnabled(false);
        kb.beginTransaction("Compute and update inferred types");
        Iterator responseIt = this.getTranslator().getDIGQueryResponseIterator(kb, responseDoc);
        RDFProperty inferredTypesSlot = kb.getRDFProperty("protege:inferredType");
        RDFProperty classificationStatusSlot = ((AbstractOWLModel)kb).getProtegeClassificationStatusProperty();
        while (responseIt.hasNext()) {
            DIGQueryResponse curResponse = (DIGQueryResponse)responseIt.next();
            RDFIndividual curInd = kb.getRDFIndividual(curResponse.getID());
            if (curInd != null) {
                Collection inferredTypes = curResponse.getConcepts();
                if (inferredTypes.size() == 0) {
                    inferredTypes.add(curInd.getOWLModel().getOWLThingClass());
                }
                Collection assertedTypes = curInd.getProtegeTypes();
                OWLModel k = kb;
                k.setOwnSlotValues((Frame)curInd, inferredTypesSlot, inferredTypes);
                if (!inferredTypes.containsAll(assertedTypes) && !assertedTypes.containsAll(inferredTypes)) {
                    k.setOwnSlotValues((Frame)curInd, classificationStatusSlot, Collections.singleton(new Integer(3)));
                } else {
                    k.setOwnSlotValues((Frame)curInd, classificationStatusSlot, Collections.singleton(new Integer(1)));
                }
            }
            this.setProgress(this.getProgress() + 1);
            this.doAbortCheck();
        }
        kb.endTransaction();
        kb.setGenerateEventsEnabled(true);
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + td, parentRecord));
        this.setTaskCompleted();
    }
}

