/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIField;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JenaKnowledgeBaseSourcesEditor
extends KnowledgeBaseSourcesEditor {
    public static final String EXTENSION = "owl";
    private URIField owlFileURIField;
    private JComboBox languageComboBox;
    private boolean callback = false;

    public JenaKnowledgeBaseSourcesEditor(String projectURIString, final PropertyList sources) {
        super(projectURIString, sources);
        String[] langs = new String[]{JenaKnowledgeBaseFactory.fileLanguages[0], JenaKnowledgeBaseFactory.fileLanguages[1]};
        this.languageComboBox = new JComboBox<String>(langs);
        this.languageComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String value = (String)JenaKnowledgeBaseSourcesEditor.this.languageComboBox.getSelectedItem();
                JenaKnowledgeBaseFactory.setOWLFileLanguage(sources, value);
                String path = JenaKnowledgeBaseSourcesEditor.this.getProjectPath();
                JenaKnowledgeBaseSourcesEditor.this.updatePath(path);
            }
        });
        LabeledComponent languagePanel = new LabeledComponent("Language", (Component)this.languageComboBox);
        String name = JenaKnowledgeBaseFactory.getOWLFilePath(this.getSources());
        if (name == null) {
            String language = JenaKnowledgeBaseFactory.getOWLFileLanguage(sources);
            name = this.constructName(this.getProjectPath(), JenaKnowledgeBaseFactory.getExtension(language));
        }
        this.owlFileURIField = new URIField("OWL file name or URL", this.getURI(name), EXTENSION, "Web Ontology Language (OWL) files");
        this.owlFileURIField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
            }
        });
        this.updateComboBox();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(8, 8));
        panel.add("North", (Component)this.owlFileURIField);
        panel.add("Center", (Component)languagePanel);
        this.add(panel);
    }

    private String constructName(String projectPath, String extension) {
        return FileUtilities.replaceExtension((String)projectPath, (String)extension);
    }

    public JComponent createIncludedProjectsList() {
        return null;
    }

    public String getProjectPath() {
        String path = super.getProjectPath();
        if (path == null) {
            if (this.owlFileURIField != null) {
                URI absoluteURI = this.owlFileURIField.getAbsoluteURI();
                if (absoluteURI != null) {
                    path = absoluteURI.toString();
                    path = FileUtilities.replaceExtension((String)path, (String)".pprj");
                } else {
                    path = "";
                }
            } else {
                path = "";
            }
        }
        return path;
    }

    private URI getURI(String str) {
        try {
            return new URI(str);
        }
        catch (Exception ex) {
            return URIUtilities.createURI((String)str);
        }
    }

    protected void onProjectPathChange(String oldPath, String newPath) {
        if (newPath != null) {
            this.updatePath(newPath);
        }
    }

    public void saveContents() {
        URI relativeURI = this.owlFileURIField.getRelativeURI();
        String owlFileURI = relativeURI != null ? relativeURI.toString() : "";
        String language = (String)this.languageComboBox.getSelectedItem();
        JenaKnowledgeBaseFactory.setOWLFileLanguage(this.getSources(), language);
        JenaKnowledgeBaseFactory.setOWLFileName(this.getSources(), owlFileURI);
    }

    private void updateComboBox() {
        URI fileURI = this.owlFileURIField.getAbsoluteURI();
        if (fileURI != null) {
            int i = 0;
            while (i < JenaKnowledgeBaseFactory.extensions.length) {
                String extension = JenaKnowledgeBaseFactory.extensions[i];
                if (fileURI.toString().endsWith("." + extension)) {
                    this.callback = true;
                    this.languageComboBox.setSelectedIndex(i);
                    this.callback = false;
                }
                ++i;
            }
        }
    }

    private void updatePath(String newPath) {
        if (this.getProjectPath() != null && !this.callback) {
            String language = (String)this.languageComboBox.getSelectedItem();
            String ext = "." + JenaKnowledgeBaseFactory.getExtension(language);
            int index = newPath.lastIndexOf(47);
            if (index >= 0) {
                newPath = newPath.substring(index + 1);
            }
            String name = new File(newPath).getName();
            String fieldText = FileUtilities.replaceExtension((String)name, (String)ext);
            this.owlFileURIField.setURI(this.getURI(fieldText));
        }
    }

    public boolean validateContents() {
        if (this.owlFileURIField.getRelativeURI() == null) {
            OWLUI.showErrorMessageDialog("You need to enter a valid URI for an OWL/RDF file.\nCurrently, these URIs should not contain spaces.", "Invalid URI");
            return false;
        }
        return true;
    }
}

