/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator.tests;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import edu.stanford.smi.protegex.owl.jena.creator.tests.AbstractJenaCreatorTestCase;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.util.Iterator;

public class CreateProtegeFramesTestCase
extends AbstractJenaCreatorTestCase {
    public void testCreateUnlinkedPALConstraint() {
        this.owlModel.ensureProtegeMetaOntologyImported();
        RDFSNamedClass constraintClass = this.owlModel.getRDFSNamedClass(":PAL-CONSTRAINT");
        RDFIndividual constraint = constraintClass.createRDFIndividual("MyIndividual");
        RDFProperty palNameProperty = this.owlModel.getRDFProperty(":PAL-NAME");
        constraint.setPropertyValue(palNameProperty, "MyName");
        RDFProperty palStatementProperty = this.owlModel.getRDFProperty(":PAL-STATEMENT");
        constraint.setPropertyValue(palStatementProperty, "MyStatement");
        OntModel newModel = this.runJenaCreator();
        OntClass constraintOntClass = newModel.getOntClass(constraintClass.getURI());
        CreateProtegeFramesTestCase.assertNotNull((Object)constraintOntClass);
        String palNamePropertyURI = palNameProperty.getURI();
        OntProperty palNameOntProperty = newModel.getOntProperty(palNamePropertyURI);
        CreateProtegeFramesTestCase.assertNotNull((Object)palNameOntProperty);
        OntProperty palStatementOntProperty = newModel.getOntProperty(palStatementProperty.getURI());
        CreateProtegeFramesTestCase.assertNotNull((Object)palStatementOntProperty);
        Individual constraintIndividual = newModel.getIndividual(constraint.getURI());
        CreateProtegeFramesTestCase.assertNotNull((Object)constraintIndividual);
        CreateProtegeFramesTestCase.assertSize(1, (Iterator)constraintIndividual.listPropertyValues((Property)palNameOntProperty));
        CreateProtegeFramesTestCase.assertSize(1, (Iterator)constraintIndividual.listPropertyValues((Property)palStatementOntProperty));
    }

    public void testCreateLinkedPALConstraint() {
        this.owlModel.ensureProtegeMetaOntologyImported();
        RDFSNamedClass constraintClass = this.owlModel.getRDFSNamedClass(":PAL-CONSTRAINT");
        RDFIndividual constraint = constraintClass.createRDFIndividual("MyIndividual");
        RDFSNamedClass rdfsClass = this.owlModel.createRDFSNamedClass("MyClass");
        RDFProperty constraintsProperty = this.owlModel.getRDFProperty(":SLOT-CONSTRAINTS");
        rdfsClass.setPropertyValue(constraintsProperty, constraint);
        OntModel newModel = this.runJenaCreator();
        OntProperty constraintsOntProperty = newModel.getOntProperty(constraintsProperty.getURI());
        CreateProtegeFramesTestCase.assertNotNull((Object)constraintsOntProperty);
        Individual constraintIndividual = newModel.getIndividual(constraint.getURI());
        OntClass ontClass = newModel.getOntClass(rdfsClass.getURI());
        CreateProtegeFramesTestCase.assertSize(1, (Iterator)ontClass.listPropertyValues((Property)constraintsOntProperty));
        CreateProtegeFramesTestCase.assertEquals((Object)constraintIndividual, (Object)ontClass.getPropertyValue((Property)constraintsOntProperty));
    }
}

