/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator.tests;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.stanford.smi.protegex.owl.jena.creator.tests.AbstractJenaCreatorTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import java.util.Iterator;

public class CreateXMLSchemaDatatypeLiteralsTestCase
extends AbstractJenaCreatorTestCase {
    public void testAnyURI() {
        XSDDatatype anyURI = XSDDatatype.XSDanyURI;
        RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByURI(anyURI.getURI());
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", datatype);
        slot.setDomainDefined(false);
        String uri = "http://aldi.de";
        slot.setPropertyValue(slot, this.owlModel.createRDFSLiteral("http://aldi.de", datatype));
        OntModel newModel = this.runJenaCreator();
        DatatypeProperty datatypeProperty = newModel.getDatatypeProperty(slot.getURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)anyURI.getURI(), (String)datatypeProperty.getRange().getURI());
        RDFNode node = datatypeProperty.getPropertyValue((Property)datatypeProperty);
        CreateXMLSchemaDatatypeLiteralsTestCase.assertTrue((boolean)node.canAs(Literal.class));
        Literal literal = (Literal)node.as(Literal.class);
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((Object)anyURI, (Object)literal.getDatatype());
    }

    public void testBase64Binary() {
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        property.setRange(this.owlModel.getXSDbase64Binary());
        byte[] values = new byte[]{1, 2, 3};
        RDFSLiteral literal = this.owlModel.createRDFSLiteral(values);
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((Object)this.owlModel.getXSDbase64Binary(), (Object)literal.getDatatype());
        property.setPropertyValue(property, literal);
        OntModel newModel = this.runJenaCreator();
        OntProperty ontProperty = newModel.getOntProperty(property.getURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)this.owlModel.getXSDbase64Binary().getURI(), (String)ontProperty.getRange().getURI());
        Literal newLiteral = (Literal)ontProperty.getPropertyValue((Property)ontProperty);
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)this.owlModel.getXSDbase64Binary().getURI(), (String)newLiteral.getDatatypeURI());
    }

    public void testXMLLiteralWithRangeDefinition() throws Exception {
        OWLDatatypeProperty datatypeProperty = this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getRDFXMLLiteralType());
        datatypeProperty.setDomainDefined(false);
        String value = "<P>test</P>";
        datatypeProperty.addPropertyValue(datatypeProperty, this.owlModel.createRDFSLiteral(value, this.owlModel.getRDFXMLLiteralType()));
        OntModel newModel = this.runJenaCreator();
        DatatypeProperty ontProperty = newModel.getDatatypeProperty(datatypeProperty.getURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)XMLLiteralType.theXMLLiteralType.getURI(), (String)ontProperty.getRange().getURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertSize(1, (Iterator)ontProperty.listProperties((Property)ontProperty));
        RDFNode node = ontProperty.getPropertyValue((Property)ontProperty);
        Literal literal = (Literal)node.as(Literal.class);
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)XMLLiteralType.theXMLLiteralType.getURI(), (String)literal.getDatatypeURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)value, (String)literal.getString());
    }

    public void testXMLLiteralWithoutRangeDefinition() throws Exception {
        OWLDatatypeProperty datatypeProperty = this.owlModel.createOWLDatatypeProperty("property");
        datatypeProperty.setDomainDefined(false);
        String value = "<P>test</P>";
        RDFSLiteral literal = this.owlModel.createRDFSLiteral(value, this.owlModel.getRDFXMLLiteralType());
        datatypeProperty.addPropertyValue(datatypeProperty, literal);
        OntModel newModel = this.runJenaCreator();
        DatatypeProperty ontProperty = newModel.getDatatypeProperty(datatypeProperty.getURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertSize(1, (Iterator)ontProperty.listProperties((Property)ontProperty));
        RDFNode node = ontProperty.getPropertyValue((Property)ontProperty);
        Literal ontLiteral = (Literal)node.as(Literal.class);
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)XMLLiteralType.theXMLLiteralType.getURI(), (String)ontLiteral.getDatatypeURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)value, (String)literal.getString());
    }
}

