/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Arrays;

public class CreateLogicalClassesTestCase
extends AbstractProtege2JenaTestCase {
    public void testCreateComplementClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(this.owlModel.createOWLComplementClass(a));
        OntModel ontModel = this.createOntModel();
        ComplementClass complementClass = (ComplementClass)ontModel.listComplementClasses().next();
        CreateLogicalClassesTestCase.assertNotNull((Object)complementClass);
        CreateLogicalClassesTestCase.assertEquals((Object)ontModel.getOntClass(a.getURI()), (Object)complementClass.getOperand());
    }

    public void testCreateIntersectionClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(this.owlModel.createOWLIntersectionClass(Arrays.asList(a, b)));
        OntModel ontModel = this.createOntModel();
        IntersectionClass intersectionClass = (IntersectionClass)ontModel.listIntersectionClasses().next();
        CreateLogicalClassesTestCase.assertNotNull((Object)intersectionClass);
        ExtendedIterator it = intersectionClass.listOperands();
        CreateLogicalClassesTestCase.assertEquals((Object)ontModel.getOntClass(a.getURI()), it.next());
        CreateLogicalClassesTestCase.assertEquals((Object)ontModel.getOntClass(b.getURI()), it.next());
        CreateLogicalClassesTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testCreateUnionClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(this.owlModel.createOWLUnionClass(Arrays.asList(a, b)));
        OntModel ontModel = this.createOntModel();
        UnionClass unionClass = (UnionClass)ontModel.listUnionClasses().next();
        CreateLogicalClassesTestCase.assertNotNull((Object)unionClass);
        ExtendedIterator it = unionClass.listOperands();
        CreateLogicalClassesTestCase.assertEquals((Object)ontModel.getOntClass(a.getURI()), it.next());
        CreateLogicalClassesTestCase.assertEquals((Object)ontModel.getOntClass(b.getURI()), it.next());
        CreateLogicalClassesTestCase.assertFalse((boolean)it.hasNext());
    }
}

