/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import java.util.Iterator;

public class CreateOntologiesTestCase
extends AbstractProtege2JenaTestCase {
    public void testDefaultOntology() {
        OntModel newModel = this.createOntModel();
        CreateOntologiesTestCase.assertSize(1, (Iterator)newModel.listOntologies());
        Ontology ontology = (Ontology)newModel.listOntologies().next();
        CreateOntologiesTestCase.assertEquals((String)newModel.getNsPrefixURI(""), (String)(String.valueOf(ontology.getURI()) + "#"));
    }

    public void testOntologyProperty() {
        String priorVersion = "http://old.de#";
        this.owlModel.getDefaultOWLOntology().addPriorVersion(priorVersion);
        OntModel newModel = this.createOntModel();
        CreateOntologiesTestCase.assertSize(1, (Iterator)newModel.listOntologies());
        Ontology ontology = (Ontology)newModel.listOntologies().next();
        Literal value = (Literal)ontology.getPropertyValue(OWL.priorVersion);
        CreateOntologiesTestCase.assertEquals((String)priorVersion, (String)value.getString());
    }

    public void testOntologyWithNiceNamespace() {
        this.owlModel.createOWLNamedClass("Cls");
        String namespace = "http://aldi.de/ont";
        this.owlModel.getNamespaceManager().setDefaultNamespace(String.valueOf(namespace) + "#");
        OntModel newModel = this.createOntModel();
        CreateOntologiesTestCase.assertSize(1, (Iterator)newModel.listOntologies());
        Ontology ontology = (Ontology)newModel.listOntologies().next();
        CreateOntologiesTestCase.assertEquals((String)namespace, (String)ontology.getURI());
    }

    public void testOntologyWithUglyNamespace() throws Exception {
        this.owlModel.getDefaultOWLOntology().addImports("http://www.owl-ontologies.com/travel.owl");
        this.owlModel.createOWLNamedClass("Cls");
        String namespace = "http://aldi.de/ont/";
        this.owlModel.getNamespaceManager().setDefaultNamespace(namespace);
        this.owlModel = CreateOntologiesTestCase.reload(this.owlModel);
        OntModel newModel = this.createOntModel();
        CreateOntologiesTestCase.assertSize(2, (Iterator)newModel.listOntologies());
        Ontology ontology = newModel.getOntology(namespace);
        CreateOntologiesTestCase.assertEquals((String)namespace, (String)ontology.getURI());
        CreateOntologiesTestCase.assertSize(1, (Iterator)ontology.listImports());
    }
}

