/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventDispatchFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalClassificationFrameStore
extends FrameStoreAdapter {
    private OWLModel owlModel;
    private Map slotsMap = new HashMap();

    public LocalClassificationFrameStore(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.slotsMap.put(owlModel.getRDFProperty("protege:classificationStatus"), new HashMap());
        this.slotsMap.put(owlModel.getRDFProperty("protege:inferredType"), new HashMap());
        this.slotsMap.put(owlModel.getRDFProperty("protege:inferredSuperclassOf"), new HashMap());
        this.slotsMap.put(owlModel.getRDFProperty("protege:inferredSubclassOf"), new HashMap());
    }

    public void deleteCls(Cls cls) {
        for (Slot slot : this.slotsMap.keySet()) {
            Map instancesMap = (Map)this.slotsMap.get(slot);
            instancesMap.remove(cls);
            for (Frame frame : new ArrayList(instancesMap.keySet())) {
                Collection values = (Collection)instancesMap.get(frame);
                if (!values.contains(cls)) continue;
                ArrayList newValues = new ArrayList(values);
                newValues.remove(cls);
                frame.setDirectOwnSlotValues(slot, newValues);
            }
        }
        super.deleteCls(cls);
    }

    private void dispatchEvent(Frame frame, Slot slot) {
        EventDispatchFrameStore e = this.getEventDispatchFrameStore();
        ArrayList ls = new ArrayList(e.getListeners(FrameListener.class, (Object)frame));
        for (FrameListener listener : ls) {
            listener.ownSlotValueChanged(new FrameEvent(frame, 110, (Object)slot));
        }
    }

    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        Map instancesMap = (Map)this.slotsMap.get(slot);
        if (instancesMap != null) {
            List values = (List)instancesMap.get(frame);
            if (values == null) {
                return Collections.EMPTY_LIST;
            }
            return values;
        }
        return super.getDirectOwnSlotValues(frame, slot);
    }

    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        Map instancesMap = (Map)this.slotsMap.get(slot);
        if (instancesMap != null) {
            return this.getDirectOwnSlotValues(frame, slot).size();
        }
        return super.getDirectOwnSlotValuesCount(frame, slot);
    }

    private EventDispatchFrameStore getEventDispatchFrameStore() {
        for (FrameStore frameStore : this.owlModel.getFrameStores()) {
            if (!(frameStore instanceof EventDispatchFrameStore)) continue;
            return (EventDispatchFrameStore)frameStore;
        }
        return null;
    }

    public Set getFramesWithDirectOwnSlotValue(Slot slot, Object value) {
        Map instancesMap = (Map)this.slotsMap.get(slot);
        if (instancesMap != null) {
            HashSet result = new HashSet();
            for (Object key : instancesMap.keySet()) {
                Collection values = (Collection)instancesMap.get(key);
                if (values == null || !values.contains(value)) continue;
                result.add(key);
            }
            return result;
        }
        return super.getFramesWithDirectOwnSlotValue(slot, value);
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        Map instancesMap = (Map)this.slotsMap.get(slot);
        if (instancesMap != null) {
            if (values.isEmpty()) {
                instancesMap.remove(frame);
            } else {
                instancesMap.put(frame, new ArrayList(values));
            }
        } else {
            super.setDirectOwnSlotValues(frame, slot, values);
        }
    }
}

