/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.util.Collection;
import java.util.Collections;

public class DefaultOWLComplementClass
extends AbstractOWLLogicalClass
implements OWLComplementClass {
    public static final char OPERATOR = '\u00ac';

    public DefaultOWLComplementClass(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultOWLComplementClass() {
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitOWLComplementClass(this);
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof OWLComplementClass) {
            return this.getComplement().equalsStructurally(((OWLComplementClass)object).getComplement());
        }
        return false;
    }

    public RDFSClass getComplement() {
        return (RDFSClass)this.getPropertyValue(this.getOperandsProperty());
    }

    public String getIconName() {
        return "OWLComplementClass";
    }

    public Collection getOperands() {
        RDFSClass complement = this.getComplement();
        if (complement == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singleton(complement);
    }

    public RDFProperty getOperandsProperty() {
        return this.getOWLModel().getRDFProperty("owl:complementOf");
    }

    public char getOperatorSymbol() {
        return '\u00ac';
    }

    public String getNestedBrowserText() {
        return this.getBrowserText();
    }

    public void setComplement(RDFSClass complement) {
        this.setOwnSlotValue(this.getOperandsProperty(), complement);
    }

    public void setOperands(Collection clses) {
        if (clses != null && clses.size() > 1) {
            throw new IllegalArgumentException("Only one complement class allowed.");
        }
        this.setPropertyValues(this.getOperandsProperty(), clses);
    }
}

