/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultRDFList
extends DefaultRDFIndividual
implements RDFList {
    public DefaultRDFList(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultRDFList() {
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitRDFList(this);
    }

    public void append(Object value) {
        boolean done = false;
        RDFList current = this;
        while (!done) {
            if (current.getFirst() == null) {
                current.setFirst(value);
                current.setRest(this.getOWLModel().getRDFNil());
                done = true;
                continue;
            }
            if (current.getRest() == null || this.getOWLModel().getRDFNil().equals(current.getRest())) {
                RDFSNamedClass listClass = (RDFSNamedClass)this.getDirectType();
                RDFList newRest = (RDFList)listClass.createAnonymousInstance();
                newRest.setFirst(value);
                newRest.setRest(this.getOWLModel().getRDFNil());
                current.setRest(newRest);
                done = true;
                continue;
            }
            current = current.getRest();
        }
    }

    public boolean contains(Object value) {
        return this.getValues().contains(value);
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof RDFList) {
            RDFList list = (RDFList)object;
            if (this.getValues().size() == list.getValues().size()) {
                Iterator it = this.getValues().iterator();
                Iterator listIt = list.getValues().iterator();
                while (listIt.hasNext()) {
                    OWLModel model = this.getOWLModel();
                    RDFObject curListObj = model.asRDFObject(listIt.next());
                    RDFObject curThisObj = model.asRDFObject(it.next());
                    if (!(curListObj != null && curThisObj != null ? !curListObj.equalsStructurally(curThisObj) : curListObj != curThisObj)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getBrowserText() {
        String str = String.valueOf(this.getDirectType().getBrowserText()) + " (";
        Iterator it = this.getValues().iterator();
        while (it.hasNext()) {
            Object value = it.next();
            str = value instanceof Instance ? String.valueOf(str) + ((Instance)value).getBrowserText() : String.valueOf(str) + value;
            if (!it.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return String.valueOf(str) + ")";
    }

    public Object getFirst() {
        RDFProperty firstProperty = this.getOWLModel().getRDFFirstProperty();
        return this.getPropertyValue(firstProperty);
    }

    public RDFSLiteral getFirstLiteral() {
        RDFProperty firstProperty = this.getOWLModel().getRDFFirstProperty();
        return this.getPropertyValueLiteral(firstProperty);
    }

    public List getValueLiterals() {
        List values = this.getValues();
        return ((AbstractOWLModel)this.getOWLModel()).getValueLiterals(values);
    }

    public RDFList getRest() {
        RDFProperty restProperty = this.getOWLModel().getRDFRestProperty();
        return (RDFList)this.getPropertyValue(restProperty);
    }

    public RDFList getStart() {
        Collection refs = this.getOWLModel().getReferences(this, 1000);
        for (Reference reference : refs) {
            if (!(reference.getFrame() instanceof RDFList) || !reference.getSlot().equals(this.getOWLModel().getRDFRestProperty())) continue;
            return ((RDFList)reference.getFrame()).getStart();
        }
        return this;
    }

    public List getValues() {
        ArrayList<Object> result = new ArrayList<Object>();
        RDFList l = this;
        while (l != null && l.getFirst() != null) {
            result.add(l.getFirst());
            l = l.getRest();
        }
        return result;
    }

    public boolean isClosed() {
        RDFList rest = this.getRest();
        if (rest == null) {
            return false;
        }
        if (rest.equals(this.getOWLModel().getRDFNil())) {
            return true;
        }
        return rest.isClosed();
    }

    public static void removeListValue(RDFResource resource, RDFProperty property, Object value) {
        RDFList list = (RDFList)resource.getPropertyValue(property);
        List values = list.getValues();
        int index = values.indexOf(value);
        DefaultRDFList.removeListValue(resource, property, list, index);
    }

    public static void removeListValue(RDFResource resource, RDFProperty property, RDFList li, int index) {
        if (index == 0) {
            RDFList rest = li.getRest();
            if (li.getOWLModel().getRDFNil().equals(rest)) {
                rest = null;
            }
            li.setRest(null);
            resource.setPropertyValue(property, rest);
            li.delete();
        } else {
            RDFList pred = null;
            while (index > 0) {
                --index;
                pred = li;
                li = li.getRest();
            }
            RDFList rest = li.getRest();
            li.setRest(null);
            pred.setRest(rest);
            li.delete();
        }
    }

    public void setFirst(Object value) {
        Slot slot = this.getKnowledgeBase().getSlot("rdf:first");
        this.setOwnSlotValue(slot, value);
    }

    public void setRest(RDFList rest) {
        Slot slot = this.getKnowledgeBase().getSlot("rdf:rest");
        this.setOwnSlotValue(slot, rest);
    }

    public int size() {
        return this.getValues().size();
    }
}

