/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.XSPNames;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

public class DefaultRDFSDatatype
extends DefaultRDFIndividual
implements RDFSDatatype {
    public DefaultRDFSDatatype(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultRDFSDatatype() {
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitRDFDatatype(this);
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof RDFSDatatype) {
            RDFSDatatype datatype = (RDFSDatatype)object;
            return datatype.getURI() == this.getURI() && datatype.getMaxExclusive().equalsStructurally(this.getMaxExclusive()) && datatype.getMinExclusive().equalsStructurally(this.getMinExclusive()) && datatype.getMaxInclusive().equalsStructurally(this.getMaxInclusive()) && datatype.getMinInclusive().equalsStructurally(this.getMinInclusive());
        }
        return false;
    }

    public RDFSDatatype getBaseDatatype() {
        RDFProperty property = XSPNames.getRDFProperty(this.getOWLModel(), 0);
        if (property != null) {
            return (RDFSDatatype)this.getPropertyValue(property);
        }
        return null;
    }

    public String getBrowserText() {
        RDFSDatatype baseDatatype;
        if (this.isAnonymous() && (baseDatatype = this.getBaseDatatype()) != null) {
            String str = baseDatatype.getBrowserText();
            String openingBracket = "[";
            String closingBracket = "]";
            RDFSLiteral min = this.getMinInclusive();
            RDFSLiteral max = this.getMaxInclusive();
            if (min == null && (min = this.getMinExclusive()) != null) {
                openingBracket = "(";
                if (max == null) {
                    closingBracket = ")";
                }
            }
            if (max == null && (max = this.getMaxExclusive()) != null) {
                closingBracket = ")";
            }
            if (max != null || min != null) {
                str = String.valueOf(str) + openingBracket;
                str = min != null ? String.valueOf(str) + min.toString() : String.valueOf(str) + "..";
                str = String.valueOf(str) + ",";
                str = max != null ? String.valueOf(str) + max.toString() : String.valueOf(str) + "..";
                return String.valueOf(str) + closingBracket;
            }
            return "variant of " + baseDatatype.getBrowserText();
        }
        String bt = super.getBrowserText();
        if (bt.startsWith("xsd:")) {
            return bt.substring("xsd:".length());
        }
        return bt;
    }

    public Object getDefaultValue() {
        if (this.equals(this.getOWLModel().getXSDboolean())) {
            return Boolean.FALSE;
        }
        if (this.equals(this.getOWLModel().getXSDint())) {
            return new Integer(0);
        }
        if (this.equals(this.getOWLModel().getXSDfloat())) {
            return new Float(0.0f);
        }
        if (this.equals(this.getOWLModel().getXSDstring())) {
            return "";
        }
        String literal = "";
        if (this.isNumericDatatype()) {
            literal = "0";
        }
        return this.getOWLModel().createRDFSLiteral(literal, this);
    }

    private short getFacetKind(String facetName) {
        if (facetName.equals("xsd:maxExclusive")) {
            return 64;
        }
        if (facetName.equals("xsd:maxInclusive")) {
            return 32;
        }
        if (facetName.equals("xsd:minExclusive")) {
            return 128;
        }
        if (facetName.equals("xsd:minInclusive")) {
            return 256;
        }
        return -1;
    }

    public Icon getIcon() {
        return this.isEditable() ? OWLIcons.getImageIcon("RDFSDatatype") : OWLIcons.getReadOnlyIndividualIcon(OWLIcons.getImageIcon("RDFSDatatype"));
    }

    private int getIntPropertyValue(String propertyName) {
        Object value;
        RDFProperty property = this.getOWLModel().getRDFProperty(propertyName);
        if (property != null && (value = this.getPropertyValue(property)) instanceof Integer) {
            return (Integer)value;
        }
        return -1;
    }

    public int getLength() {
        return this.getIntPropertyValue(XSPNames.getName(this.getOWLModel(), 2));
    }

    public RDFSLiteral getMaxExclusive() {
        return this.getPropertyValueLiteral(XSPNames.getName(this.getOWLModel(), 5));
    }

    public RDFSLiteral getMaxInclusive() {
        return this.getPropertyValueLiteral(XSPNames.getName(this.getOWLModel(), 6));
    }

    public int getMaxLength() {
        return this.getIntPropertyValue(XSPNames.getName(this.getOWLModel(), 8));
    }

    public RDFSLiteral getMinExclusive() {
        return this.getPropertyValueLiteral(XSPNames.getName(this.getOWLModel(), 3));
    }

    public RDFSLiteral getMinInclusive() {
        return this.getPropertyValueLiteral(XSPNames.getName(this.getOWLModel(), 4));
    }

    public int getMinLength() {
        return this.getIntPropertyValue(XSPNames.getName(this.getOWLModel(), 7));
    }

    public String getPattern() {
        Object value;
        RDFProperty property = XSPNames.getRDFProperty(this.getOWLModel(), 9);
        if (property != null && (value = this.getPropertyValue(property)) != null) {
            return value.toString();
        }
        return null;
    }

    private RDFSLiteral getPropertyValueLiteral(String propertyName) {
        RDFProperty property = this.getOWLModel().getRDFProperty(propertyName);
        if (property != null) {
            return this.getPropertyValueLiteral(property);
        }
        return null;
    }

    public boolean isNumericDatatype() {
        String uri = this.getURI();
        RDFSDatatype base = this.getBaseDatatype();
        if (base != null) {
            uri = base.getURI();
        }
        return XMLSchemaDatatypes.isNumericDatatype(uri);
    }

    public boolean isValidValue(RDFSLiteral object) {
        RDFSDatatype d = this;
        RDFSDatatype baseDatatype = this.getBaseDatatype();
        if (baseDatatype != null) {
            d = baseDatatype;
        }
        if (!object.getDatatype().equals(d)) {
            return false;
        }
        if (this.getOWLModel().getXSDstring().equals(d)) {
            return this.isValidValueString(object);
        }
        return this.isValidValueNumeric(object);
    }

    private boolean isValidValueNumeric(RDFSLiteral object) {
        RDFSLiteral minInclusive = this.getMinInclusive();
        if (minInclusive != null && object.compareTo(minInclusive) < 0) {
            return false;
        }
        RDFSLiteral minExclusive = this.getMinExclusive();
        if (minExclusive != null && object.compareTo(minExclusive) <= 0) {
            return false;
        }
        RDFSLiteral maxInclusive = this.getMaxInclusive();
        if (maxInclusive != null && object.compareTo(maxInclusive) > 0) {
            return false;
        }
        RDFSLiteral maxExclusive = this.getMaxExclusive();
        return maxExclusive == null || object.compareTo(maxExclusive) < 0;
    }

    private boolean isValidValueString(RDFSLiteral object) {
        Pattern p;
        Matcher matcher;
        String s = object.toString();
        int l = s.length();
        int length = this.getLength();
        if (length >= 0 && length != l) {
            return false;
        }
        int minLength = this.getMinLength();
        if (minLength >= 0 && l < minLength) {
            return false;
        }
        int maxLength = this.getMaxLength();
        if (maxLength >= 0 && l > maxLength) {
            return false;
        }
        String pattern = this.getPattern();
        return pattern == null || (matcher = (p = Pattern.compile(pattern)).matcher(s)).matches();
    }

    public static Map parse(OWLModel owlModel, String expression) {
        HashMap<RDFProperty, RDFObject> map = new HashMap<RDFProperty, RDFObject>();
        if (owlModel.isProtegeMetaOntologyImported()) {
            String baseTypeName;
            RDFSDatatype datatype;
            int index = 3;
            while (index < expression.length() && expression.charAt(index) != '(' && expression.charAt(index) != '[') {
                ++index;
            }
            if (index < expression.length() && (datatype = owlModel.getRDFSDatatypeByName(baseTypeName = expression.substring(0, index).trim())) != null) {
                RDFProperty subDatatypeOfProperty = owlModel.getRDFProperty("xsp:base");
                map.put(subDatatypeOfProperty, datatype);
                RDFProperty minProperty = null;
                minProperty = expression.charAt(index) == '(' ? XSPNames.getRDFProperty(owlModel, 3) : XSPNames.getRDFProperty(owlModel, 4);
                String rest = expression.substring(index + 1).trim();
                int minEnd = 0;
                while (minEnd < rest.length() && (Character.isDigit(rest.charAt(minEnd)) || rest.charAt(minEnd) == '.')) {
                    ++minEnd;
                }
                String min = rest.substring(0, minEnd);
                if (min.length() > 0 && Character.isDigit(min.charAt(0))) {
                    RDFSLiteral minLiteral = owlModel.createRDFSLiteral(min, datatype);
                    map.put(minProperty, minLiteral);
                }
                int maxStart = minEnd;
                while (maxStart < rest.length() && !Character.isDigit(rest.charAt(maxStart))) {
                    ++maxStart;
                }
                if (maxStart < rest.length()) {
                    String max;
                    rest = rest.substring(maxStart);
                    int maxEnd = 0;
                    while (maxEnd < rest.length() && (Character.isDigit(rest.charAt(maxEnd)) || rest.charAt(maxEnd) == '.')) {
                        ++maxEnd;
                    }
                    RDFProperty maxProperty = XSPNames.getRDFProperty(owlModel, 6);
                    if (rest.endsWith(")")) {
                        maxProperty = XSPNames.getRDFProperty(owlModel, 5);
                    }
                    if ((max = rest.substring(0, maxEnd)).length() > 0 && Character.isDigit(max.charAt(0))) {
                        RDFSLiteral maxLiteral = owlModel.createRDFSLiteral(max, datatype);
                        map.put(maxProperty, maxLiteral);
                    }
                }
                if (map.size() == 1) {
                    return new HashMap();
                }
            }
        }
        return map;
    }
}

