/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultRDFListTestCase
extends AbstractJenaTestCase {
    public void testRDFListsAreAnonymous() {
        Collection values = Arrays.asList("A", "B");
        RDFList list = this.owlModel.createRDFList(values.iterator());
        DefaultRDFListTestCase.assertTrue((boolean)list.isAnonymous());
        DefaultRDFListTestCase.assertTrue((boolean)list.getRest().isAnonymous());
    }

    public void testRDFNilIsNotAnonymous() {
        DefaultRDFListTestCase.assertFalse((boolean)this.owlModel.getRDFNil().isAnonymous());
    }

    public void testRDFListAppendOrdering() {
        List<String> values = Arrays.asList("A", "B", "C", "D");
        RDFList list = this.owlModel.createRDFList();
        Iterator<String> i = values.iterator();
        while (i.hasNext()) {
            list.append(i.next());
        }
        RDFList sublist = list;
        int i2 = 0;
        while (i2 < values.size()) {
            DefaultRDFListTestCase.assertTrue((boolean)sublist.getFirst().equals(values.get(i2)));
            sublist = sublist.getRest();
            ++i2;
        }
    }
}

