/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DomainTestCase
extends AbstractJenaTestCase {
    public void testSubSlotDomainDefined() {
        OWLObjectProperty a = this.owlModel.createOWLObjectProperty("a");
        a.setDomainDefined(false);
        DomainTestCase.assertFalse((boolean)a.isDomainDefined());
        DomainTestCase.assertFalse((boolean)a.isDomainDefined(true));
        DomainTestCase.assertSize(1, a.getUnionDomain());
        OWLObjectProperty b = (OWLObjectProperty)this.owlModel.createSubproperty("b", a);
        OWLObjectProperty c = (OWLObjectProperty)this.owlModel.createSubproperty("c", b);
        DomainTestCase.assertFalse((boolean)b.isDomainDefined());
        DomainTestCase.assertFalse((boolean)b.isDomainDefined(true));
        DomainTestCase.assertFalse((boolean)c.isDomainDefined());
        DomainTestCase.assertFalse((boolean)c.isDomainDefined(true));
        b.setDomainDefined(true);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        b.addUnionDomainClass(cls);
        DomainTestCase.assertTrue((boolean)b.isDomainDefined());
        DomainTestCase.assertTrue((boolean)b.isDomainDefined(true));
        DomainTestCase.assertFalse((boolean)c.isDomainDefined());
        DomainTestCase.assertTrue((boolean)c.isDomainDefined(true));
        DomainTestCase.assertContains((Object)this.owlThing, a.getUnionDomain());
        DomainTestCase.assertContains((Object)cls, b.getUnionDomain());
    }

    public void testSetDomainDefined() {
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("Test");
        DomainTestCase.assertFalse((boolean)slot.isDomainDefined());
        slot.setDomainDefined(false);
        DomainTestCase.assertFalse((boolean)slot.isDomainDefined());
        DomainTestCase.assertEquals((Object)this.owlModel.getRootClses(), (Object)slot.getUnionDomain());
        slot.setDomainDefined(true);
        DomainTestCase.assertTrue((boolean)slot.isDomainDefined());
        DomainTestCase.assertTrue((boolean)slot.getUnionDomain().isEmpty());
    }

    public void testForgetOldDomain() {
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("Test");
        slot.setDomainDefined(true);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        slot.addUnionDomainClass(cls);
        DomainTestCase.assertSize(1, slot.getUnionDomain());
        DomainTestCase.assertEquals((Object)cls, slot.getUnionDomain().iterator().next());
        slot.setDomainDefined(false);
        DomainTestCase.assertEquals((Object)this.owlModel.getRootClses(), (Object)slot.getUnionDomain());
    }

    public void testSlotWithoutDomainIsTemplateSlotEverywhere() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        int baseCount = cls.getUnionDomainProperties(true).size();
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("Test");
        slot.setDomainDefined(false);
        DomainTestCase.assertSize(0, cls.getUnionDomainProperties());
        DomainTestCase.assertSize(baseCount + 1, cls.getUnionDomainProperties(true));
        DomainTestCase.assertContains((Object)slot, cls.getUnionDomainProperties(true).iterator());
        slot.setDomainDefined(true);
        DomainTestCase.assertSize(baseCount, cls.getUnionDomainProperties(true));
    }

    public void testDomainDefinedOfSubproperty() {
        OWLObjectProperty superproperty = this.owlModel.createOWLObjectProperty("super");
        DomainTestCase.assertFalse((boolean)superproperty.isDomainDefined());
        OWLObjectProperty subproperty = this.owlModel.createOWLObjectProperty("sub");
        DomainTestCase.assertFalse((boolean)subproperty.isDomainDefined());
        subproperty.addSuperproperty(superproperty);
        DomainTestCase.assertFalse((boolean)subproperty.isDomainDefined());
        subproperty.setDomainDefined(true);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        subproperty.addUnionDomainClass(cls);
        DomainTestCase.assertFalse((boolean)superproperty.isDomainDefined());
        DomainTestCase.assertTrue((boolean)subproperty.isDomainDefined());
        DomainTestCase.assertTrue((boolean)subproperty.isDomainDefined(true));
    }

    public void testDomainDefinedOfSubproperty2() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFProperty superproperty = this.owlModel.createRDFProperty("super");
        RDFProperty subproperty = this.owlModel.createRDFProperty("sub");
        subproperty.addSuperproperty(superproperty);
        DomainTestCase.assertFalse((boolean)superproperty.isDomainDefined());
        superproperty.setDomain(cls);
        DomainTestCase.assertTrue((boolean)superproperty.isDomainDefined());
        DomainTestCase.assertFalse((boolean)subproperty.isDomainDefined());
        DomainTestCase.assertTrue((boolean)subproperty.isDomainDefined(true));
    }
}

