/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.ArrayList;

public class EqualsStructurallyTestCase
extends AbstractJenaTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.owlModel.createOWLNamedClass("A");
        this.owlModel.createOWLNamedClass("B");
        this.owlModel.createOWLNamedClass("C");
        this.owlModel.createOWLObjectProperty("p");
        this.owlModel.createOWLDatatypeProperty("r");
        this.owlModel.createOWLDatatypeProperty("s");
        this.owlModel.getOWLThingClass().createOWLIndividual("i");
        this.owlModel.getOWLThingClass().createOWLIndividual("j");
    }

    public void testOWLNamedClass() {
        EqualsStructurallyTestCase.assertTrue((boolean)this.owlModel.getOWLNamedClass("A").equalsStructurally(this.owlModel.getOWLNamedClass("A")));
        EqualsStructurallyTestCase.assertFalse((boolean)this.owlModel.getOWLNamedClass("A").equalsStructurally(this.owlModel.getOWLNamedClass("B")));
    }

    public void testOWLObjectProperty() {
        EqualsStructurallyTestCase.assertTrue((boolean)this.owlModel.getOWLObjectProperty("p").equalsStructurally(this.owlModel.getOWLObjectProperty("p")));
        EqualsStructurallyTestCase.assertFalse((boolean)this.owlModel.getOWLObjectProperty("p").equalsStructurally(this.owlModel.getOWLObjectProperty("q")));
    }

    public void testOWLSomeValuesFrom() {
        OWLSomeValuesFrom resA = this.owlModel.createOWLSomeValuesFrom((RDFProperty)this.getP(), this.getA());
        OWLSomeValuesFrom resB = this.owlModel.createOWLSomeValuesFrom((RDFProperty)this.getP(), this.getA());
        OWLSomeValuesFrom resC = this.owlModel.createOWLSomeValuesFrom((RDFProperty)this.getP(), this.getB());
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    public void testOWLAllValuesFrom() {
        OWLAllValuesFrom resA = this.owlModel.createOWLAllValuesFrom((RDFProperty)this.getP(), this.getA());
        OWLAllValuesFrom resB = this.owlModel.createOWLAllValuesFrom((RDFProperty)this.getP(), this.getA());
        OWLAllValuesFrom resC = this.owlModel.createOWLAllValuesFrom((RDFProperty)this.getP(), this.getB());
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    public void testAbstractCardinality() {
        OWLMinCardinality resA = this.owlModel.createOWLMinCardinality(this.getP(), 1);
        OWLMinCardinality resB = this.owlModel.createOWLMinCardinality(this.getP(), 1);
        OWLMinCardinality resC = this.owlModel.createOWLMinCardinality(this.getP(), 2);
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    public void testOWLAbstractQCardinality() {
        OWLMinCardinality resA = this.owlModel.createOWLMinCardinality(this.getP(), 1);
        resA.setValuesFrom(this.getA());
        OWLMinCardinality resB = this.owlModel.createOWLMinCardinality(this.getP(), 1);
        resB.setValuesFrom(this.getA());
        OWLMinCardinality resC = this.owlModel.createOWLMinCardinality(this.getP(), 1);
        resC.setValuesFrom(this.getB());
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    public void testObjectOWLHasValue() {
        OWLHasValue resA = this.owlModel.createOWLHasValue(this.getP(), this.getI());
        OWLHasValue resB = this.owlModel.createOWLHasValue(this.getP(), this.getI());
        OWLHasValue resC = this.owlModel.createOWLHasValue(this.getP(), this.getJ());
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    public void testDatatypeOWLHasValue() {
        OWLHasValue resA = this.owlModel.createOWLHasValue(this.getR(), this.owlModel.createRDFSLiteral("3", this.owlModel.getXSDint()));
        OWLHasValue resB = this.owlModel.createOWLHasValue(this.getR(), this.owlModel.createRDFSLiteral("3", this.owlModel.getXSDint()));
        OWLHasValue resC = this.owlModel.createOWLHasValue(this.getR(), this.owlModel.createRDFSLiteral("4", this.owlModel.getXSDint()));
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    public void testAbstractLogicalNArayClass() {
        OWLIntersectionClass resA = this.owlModel.createOWLIntersectionClass();
        resA.addOperand(this.getA());
        resA.addOperand(this.getB());
        OWLIntersectionClass resB = this.owlModel.createOWLIntersectionClass();
        resB.addOperand(this.getB());
        resB.addOperand(this.getA());
        OWLIntersectionClass resC = this.owlModel.createOWLIntersectionClass();
        resC.addOperand(this.getA());
        resC.addOperand(this.getB());
        resC.addOperand(this.getC());
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    public void testOWLEnumeratedClass() {
        OWLEnumeratedClass resA = this.owlModel.createOWLEnumeratedClass();
        resA.addOneOf(this.getI());
        resA.addOneOf(this.getJ());
        OWLEnumeratedClass resB = this.owlModel.createOWLEnumeratedClass();
        resB.addOneOf(this.getJ());
        resB.addOneOf(this.getI());
        OWLEnumeratedClass resC = this.owlModel.createOWLEnumeratedClass();
        resC.addOneOf(this.getI());
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    public void testRDFList() {
        ArrayList<OWLNamedClass> valuesA = new ArrayList<OWLNamedClass>();
        valuesA.add(this.getA());
        valuesA.add(this.getB());
        valuesA.add(this.getC());
        ArrayList<OWLNamedClass> valuesB = new ArrayList<OWLNamedClass>();
        valuesB.add(this.getC());
        valuesB.add(this.getB());
        valuesB.add(this.getA());
        RDFList resA = this.owlModel.createRDFList(valuesA.iterator());
        RDFList resB = this.owlModel.createRDFList(valuesA.iterator());
        RDFList resC = this.owlModel.createRDFList(valuesB.iterator());
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    public void testOWLComplementClass() {
        OWLComplementClass resA = this.owlModel.createOWLComplementClass(this.getA());
        OWLComplementClass resB = this.owlModel.createOWLComplementClass(this.getA());
        OWLComplementClass resC = this.owlModel.createOWLComplementClass(this.getB());
        EqualsStructurallyTestCase.assertTrue((boolean)resA.equalsStructurally(resB));
        EqualsStructurallyTestCase.assertFalse((boolean)resA.equalsStructurally(resC));
    }

    private OWLObjectProperty getP() {
        return this.owlModel.getOWLObjectProperty("p");
    }

    private OWLDatatypeProperty getR() {
        return this.owlModel.getOWLDatatypeProperty("r");
    }

    private OWLNamedClass getA() {
        return this.owlModel.getOWLNamedClass("A");
    }

    private OWLNamedClass getB() {
        return this.owlModel.getOWLNamedClass("B");
    }

    private OWLNamedClass getC() {
        return this.owlModel.getOWLNamedClass("C");
    }

    private OWLIndividual getI() {
        return this.owlModel.getOWLIndividual("i");
    }

    private OWLIndividual getJ() {
        return this.owlModel.getOWLIndividual("j");
    }
}

