/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class DuplicateSuperclassesPostProcessor {
    DuplicateSuperclassesPostProcessor(OWLModel owlModel) {
        owlModel.getOWLFrameStore().setSuperclassSynchronizationBlocked(true);
        Collection clses = owlModel.getUserDefinedOWLNamedClasses();
        for (OWLNamedClass cls : clses) {
            this.removeDuplicateSuperclasses(cls);
        }
        owlModel.getOWLFrameStore().setSuperclassSynchronizationBlocked(false);
    }

    private void removeDuplicateSuperclasses(RDFSNamedClass cls) {
        ArrayList superclasses = new ArrayList(cls.getPureSuperclasses());
        HashSet<String> bs = new HashSet<String>();
        boolean hasDuplicates = false;
        for (Cls superclass : superclasses) {
            if (!(superclass instanceof OWLAnonymousClass)) continue;
            String bt = superclass.getBrowserText();
            if (bs.contains(bt)) {
                System.err.println("[DuplicateSuperclassesPostProcessor]  Class " + cls.getBrowserText() + " has duplicate superclass " + bt);
                hasDuplicates = true;
                break;
            }
            bs.add(bt);
        }
        if (hasDuplicates) {
            int i = 0;
            while (i < superclasses.size() - 1) {
                if (superclasses.get(i) instanceof OWLAnonymousClass) {
                    OWLAnonymousClass anon = (OWLAnonymousClass)superclasses.get(i);
                    String browserTextI = anon.getBrowserText();
                    int j = superclasses.size() - 1;
                    while (j > i) {
                        OWLAnonymousClass classJ;
                        String browserTextJ;
                        if (superclasses.get(j).getClass() == anon.getClass() && (browserTextJ = (classJ = (OWLAnonymousClass)superclasses.get(j)).getBrowserText()).equals(browserTextI)) {
                            cls.removeDirectSuperclass(classJ);
                            superclasses.remove(j);
                        }
                        --j;
                    }
                }
                ++i;
            }
        }
    }
}

