/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;

public class ForcedURLRetrievalRepository
implements Repository {
    private URL url;
    private URI uri;
    private URI actualOntologyName;

    public ForcedURLRetrievalRepository(URL url) {
        this.url = url;
        this.uri = null;
        this.refresh();
    }

    public boolean contains(URI ontologyName) {
        if (this.uri != null) {
            return ontologyName.equals(this.uri);
        }
        return false;
    }

    public void refresh() {
        try {
            InputStream is = ProtegeOWLParser.getInputStream(this.url);
            OntologyNameExtractor extractor = new OntologyNameExtractor(is, this.url);
            if (extractor.isRDFRootElementPresent()) {
                this.actualOntologyName = extractor.getOntologyName();
                try {
                    this.uri = new URI(this.url.toString());
                }
                catch (URISyntaxException e) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", e);
                }
            } else {
                this.uri = null;
            }
        }
        catch (IOException e) {
            this.uri = null;
        }
    }

    public Collection getOntologies() {
        return Collections.singleton(this.uri);
    }

    public InputStream getInputStream(URI ontologyName) throws IOException {
        if (this.uri != null) {
            return ProtegeOWLParser.getInputStream(this.url);
        }
        return null;
    }

    public boolean isWritable(URI ontologyName) {
        return false;
    }

    public OutputStream getOutputStream(URI ontologyName) throws IOException {
        return null;
    }

    public boolean isSystem() {
        return false;
    }

    public String getRepositoryDescription() {
        return "Forced HTTP retrieval";
    }

    public String getOntologyLocationDescription(URI ontologyName) {
        return String.valueOf(this.url.toString()) + " [actual ontology at this location: " + this.actualOntologyName + "]";
    }

    public String getRepositoryDescriptor() {
        return this.url.toString();
    }
}

