/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.storage;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KnowledgeBaseCopier {
    private KnowledgeBase source;
    private KnowledgeBase target;
    private Set doneSlots = new HashSet();
    private Hashtable frameMap = new Hashtable();
    private Map todoSlots = new HashMap();

    public KnowledgeBaseCopier(KnowledgeBase source, KnowledgeBase target) {
        this.source = source;
        this.target = target;
        this.doneSlots.add(":DIRECT-DOMAIN");
        this.doneSlots.add(":DIRECT-SUBCLASSES");
        this.doneSlots.add(":DIRECT-SUBSLOTS");
        this.doneSlots.add(":DIRECT-SUPERCLASSES");
        this.doneSlots.add(":DIRECT-SUPERSLOTS");
        this.doneSlots.add(":DIRECT-INSTANCES");
        this.doneSlots.add(":DIRECT-TEMPLATE-SLOTS");
        this.doneSlots.add(":DIRECT-TYPE");
        this.doneSlots.add(":SLOT-MAXIMUM-CARDINALITY");
        this.doneSlots.add(":SLOT-MINIMUM-CARDINALITY");
        this.doneSlots.add(":NAME");
        this.doneSlots.add(":SLOT-VALUE-TYPE");
    }

    public void run() {
        this.log("Creating Classes...");
        this.createClses();
        this.log("Creating Facets...");
        this.createFacets();
        this.createSlots();
        this.createInstances();
        this.createFacetOverrides();
        this.setOwnSlotValues();
        for (Slot oldSlot : this.todoSlots.keySet()) {
            Slot newSlot = (Slot)this.todoSlots.get(oldSlot);
            this.setValueType(oldSlot, newSlot);
        }
    }

    protected void addExtraDirectTypes(Instance oldInstance, Instance newInstance) {
        Collection directTypes = oldInstance.getDirectTypes();
        Iterator it = directTypes.iterator();
        it.next();
        while (it.hasNext()) {
            Cls oldType = (Cls)it.next();
            Cls newType = this.getNewCls(oldType);
            if (newInstance.hasDirectType(newType)) continue;
            this.log("+ Adding direct type " + newType.getBrowserText() + " to " + newInstance.getBrowserText());
            newInstance.addDirectType(newType);
        }
    }

    protected Collection cloneValues(Collection oldValues) {
        ArrayList<Object> newValues = new ArrayList<Object>();
        for (Object oldValue : oldValues) {
            if (oldValue instanceof Instance) {
                Instance newInstance = this.getNewInstance((Instance)oldValue);
                if (newInstance == null) continue;
                newValues.add(newInstance);
                continue;
            }
            newValues.add(oldValue);
        }
        return newValues;
    }

    protected Cls createCls(String clsName, Cls metaCls) {
        this.log("+ Creating Class " + clsName + " of type " + metaCls);
        return this.target.createCls(clsName, this.target.getRootClses(), metaCls);
    }

    protected void createClses() {
        for (Cls oldCls : this.source.getClses()) {
            this.getNewCls(oldCls);
        }
    }

    private void createFacetOverrides() {
        for (Cls cls : this.source.getClses()) {
            if (!cls.isEditable() && (!cls.isIncluded() || cls.isSystem())) continue;
            this.createFacetOverrides(cls);
        }
    }

    protected void createFacetOverrides(Cls oldCls) {
        for (Slot slot : oldCls.getTemplateSlots()) {
            if (!oldCls.hasDirectlyOverriddenTemplateSlot(slot)) continue;
            this.createFacetOverrides(oldCls, slot);
        }
    }

    private void createFacetOverride(Cls oldCls, Slot oldSlot, Facet oldFacet) {
        Cls newCls = this.getNewCls(oldCls);
        Slot newSlot = this.getNewSlot(oldSlot);
        this.log("* Making facet override of " + oldSlot.getBrowserText() + "." + oldFacet.getBrowserText() + " at Cls " + oldCls.getBrowserText() + ", new: " + newCls.getBrowserText());
        if (oldFacet.getName().equals(":VALUE-TYPE")) {
            ValueType valueType = oldCls.getTemplateSlotValueType(oldSlot);
            newCls.setTemplateSlotValueType(newSlot, valueType);
            if (valueType == ValueType.INSTANCE) {
                Collection oldClses = oldCls.getTemplateSlotAllowedClses(oldSlot);
                Collection newClses = this.cloneValues(oldClses);
                newCls.setTemplateSlotAllowedClses(newSlot, newClses);
            } else if (valueType == ValueType.CLS) {
                Collection oldClses = oldCls.getTemplateSlotAllowedParents(oldSlot);
                Collection newClses = this.cloneValues(oldClses);
                newCls.setTemplateSlotAllowedParents(newSlot, newClses);
            } else if (valueType == ValueType.SYMBOL) {
                Collection oldValues = oldCls.getTemplateSlotAllowedValues(oldSlot);
                Collection newValues = this.cloneValues(oldValues);
                newCls.setTemplateSlotAllowedValues(newSlot, newValues);
            }
        } else {
            Collection oldValues = oldCls.getTemplateFacetValues(oldSlot, oldFacet);
            Collection newValues = this.cloneValues(oldValues);
            Facet newFacet = this.getNewFacet(oldFacet);
            newCls.setTemplateFacetValues(newSlot, newFacet, newValues);
        }
    }

    private void createFacetOverrides(Cls oldCls, Slot oldSlot) {
        for (Facet oldFacet : this.source.getFacets()) {
            if (!oldCls.hasDirectlyOverriddenTemplateFacet(oldSlot, oldFacet)) continue;
            this.createFacetOverride(oldCls, oldSlot, oldFacet);
        }
    }

    private void createFacets() {
        for (Facet oldFacet : this.source.getFacets()) {
            this.getNewFacet(oldFacet);
        }
    }

    protected Instance createInstance(String name, Cls newType) {
        return this.target.createInstance(name, newType);
    }

    private void createInstances() {
        for (Instance oldInstance : this.source.getInstances()) {
            if (oldInstance.getDirectType() == null || oldInstance.getDirectType().isSystem()) continue;
            this.getNewInstance(oldInstance);
        }
    }

    protected Slot createSlot(String slotName, ValueType valueType) {
        return this.target.createSlot(slotName);
    }

    private void createSlots() {
        for (Slot oldSlot : this.source.getSlots()) {
            this.getNewSlot(oldSlot);
        }
    }

    protected Cls getNewCls(Cls oldCls) {
        boolean instanceOfItself = false;
        Cls newCls = (Cls)this.frameMap.get(oldCls);
        newCls = newCls == null ? this.target.getCls(oldCls.getName()) : this.target.getCls(newCls.getName());
        if (newCls == null) {
            Cls newType = this.target.getCls("owl:Class");
            if (oldCls.equals(oldCls.getDirectType())) {
                System.err.println("Warning: Class " + oldCls + " is an instance of itself.");
                instanceOfItself = true;
            } else {
                newType = this.getNewCls(oldCls.getDirectType());
            }
            if (newType == null) {
                System.err.println("ERROR: No type for " + oldCls);
                newType = oldCls.getKnowledgeBase().getCls("owl:Class");
                oldCls.setDirectType(newType);
            }
            newCls = this.createCls(oldCls.getName(), newType);
            this.registerFrame((Frame)oldCls, (Frame)newCls);
            this.addExtraDirectTypes((Instance)oldCls, (Instance)newCls);
            if (instanceOfItself) {
                newCls.addDirectType(newCls);
            }
            for (Cls oldSuperCls : oldCls.getDirectSuperclasses()) {
                Cls newSuperCls = this.getNewCls(oldSuperCls);
                if (newCls.hasDirectSuperclass(newSuperCls)) continue;
                newCls.addDirectSuperclass(newSuperCls);
                this.log("  + Adding " + newSuperCls.getName() + " to superclasses of " + newCls.getName());
            }
            if (!oldCls.hasDirectSuperclass(this.source.getRootCls())) {
                newCls.removeDirectSuperclass(this.target.getRootCls());
            }
            for (Slot oldSlot : oldCls.getDirectTemplateSlots()) {
                Slot newSlot = this.getNewSlot(oldSlot);
                this.log("+ Added template slot " + newSlot.getBrowserText() + " to " + newCls.getBrowserText());
                newCls.addDirectTemplateSlot(newSlot);
            }
            this.setInitialOwnSlotValues((Instance)oldCls);
        }
        return newCls;
    }

    private Facet getNewFacet(Facet oldFacet) {
        Facet newFacet = (Facet)this.frameMap.get(oldFacet);
        if (newFacet == null) {
            newFacet = this.target.getFacet(oldFacet.getName());
        }
        if (newFacet == null) {
            newFacet = this.target.createFacet(oldFacet.getName());
            this.registerFrame((Frame)oldFacet, (Frame)newFacet);
            this.addExtraDirectTypes((Instance)oldFacet, (Instance)newFacet);
            this.setInitialOwnSlotValues((Instance)oldFacet);
        }
        return newFacet;
    }

    protected Instance getNewInstance(Instance oldInstance) {
        if (oldInstance instanceof Cls) {
            return this.getNewCls((Cls)oldInstance);
        }
        if (oldInstance instanceof Slot) {
            return this.getNewSlot((Slot)oldInstance);
        }
        if (oldInstance instanceof Facet) {
            return this.getNewFacet((Facet)oldInstance);
        }
        Instance newInstance = (Instance)this.frameMap.get(oldInstance);
        String name = oldInstance.getName();
        if (newInstance == null) {
            newInstance = this.target.getInstance(name);
        }
        if (newInstance == null) {
            Cls oldType = oldInstance.getDirectType();
            if (oldType == null) {
                System.err.println("Warning: Instance " + oldInstance.getName() + " has no direct type [Ignored]");
                return null;
            }
            Cls newType = this.getNewCls(oldType);
            newInstance = this.createInstance(name, newType);
            this.registerFrame((Frame)oldInstance, (Frame)newInstance);
            this.addExtraDirectTypes(oldInstance, newInstance);
            this.setInitialOwnSlotValues(oldInstance);
        }
        return newInstance;
    }

    protected Slot getNewSlot(Slot oldSlot) {
        Slot newSlot = (Slot)this.frameMap.get(oldSlot);
        if (newSlot == null) {
            String slotName = oldSlot.getName();
            newSlot = this.target.getSlot(slotName);
        }
        if (newSlot == null) {
            newSlot = this.createSlot(oldSlot.getName(), oldSlot.getValueType());
            this.registerFrame((Frame)oldSlot, (Frame)newSlot);
            this.addExtraDirectTypes((Instance)oldSlot, (Instance)newSlot);
            this.todoSlots.put(oldSlot, newSlot);
            this.setDirectType((Instance)oldSlot, (Instance)newSlot);
            newSlot.setMinimumCardinality(oldSlot.getMinimumCardinality());
            newSlot.setMaximumCardinality(oldSlot.getMaximumCardinality());
            for (Slot oldSuperSlot : oldSlot.getDirectSuperslots()) {
                Slot newSuperSlot = this.getNewSlot(oldSuperSlot);
                if (newSlot.getDirectSuperslots().contains(newSuperSlot)) continue;
                newSlot.addDirectSuperslot(newSuperSlot);
            }
            this.setInitialOwnSlotValues((Instance)oldSlot);
        }
        return newSlot;
    }

    protected void log(String str) {
    }

    private void registerFrame(Frame oldFrame, Frame newFrame) {
        String newName;
        String oldName = oldFrame.getName();
        if (!oldName.equals(newName = newFrame.getName())) {
            this.frameMap.put(oldFrame, newFrame);
        }
    }

    protected void setDirectType(Instance oldFrame, Instance newFrame) {
        Cls oldType = oldFrame.getDirectType();
        Cls newType = this.getNewCls(oldType);
        if (!newType.equals(newFrame.getDirectType())) {
            newFrame.setDirectType(newType);
        }
    }

    protected void setInitialOwnSlotValues(Instance instance) {
    }

    private void setOwnSlotValues() {
        for (Instance oldInstance : this.source.getInstances()) {
            if (oldInstance.isSystem() || !oldInstance.isEditable() && !oldInstance.isIncluded()) continue;
            this.setOwnSlotValues(oldInstance);
        }
    }

    private void setOwnSlotValues(Instance oldInstance) {
        Instance newFrame = this.getNewInstance(oldInstance);
        if (newFrame != null) {
            this.log("+ Setting own slot values of " + oldInstance.getBrowserText() + " (new: " + newFrame.getBrowserText() + ")");
            for (Slot oldSlot : oldInstance.getOwnSlots()) {
                if (this.doneSlots.contains(oldSlot.getName())) continue;
                this.setOwnSlotValues((Frame)newFrame, oldInstance, oldSlot);
            }
        }
    }

    protected void setOwnSlotValues(Frame newFrame, Instance oldInstance, Slot oldSlot) {
        Slot newSlot = this.getNewSlot(oldSlot);
        Collection values = oldInstance.getOwnSlotValues(oldSlot);
        if (values.size() > 0) {
            this.log(" - " + oldSlot + " (" + values.size() + " values)");
            Collection clones = this.cloneValues(values);
            if (!clones.equals(newFrame.getOwnSlotValues(newSlot))) {
                newFrame.setOwnSlotValues(newSlot, clones);
            }
        }
    }

    protected void setValueType(Slot oldSlot, Slot newSlot) {
        newSlot.setValueType(oldSlot.getValueType());
        if (oldSlot.getValueType() == ValueType.INSTANCE) {
            Collection newAllowedClses = this.cloneValues(oldSlot.getAllowedClses());
            newSlot.setAllowedClses(newAllowedClses);
        } else if (oldSlot.getValueType() == ValueType.CLS) {
            Collection newAllowedParents = this.cloneValues(oldSlot.getAllowedParents());
            newSlot.setAllowedParents(newAllowedParents);
        } else if (oldSlot.getValueType() == ValueType.SYMBOL) {
            Collection newAllowedValues = oldSlot.getAllowedValues();
            newSlot.setAllowedValues(newAllowedValues);
        }
    }
}

