/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class ClassTreeNode
extends LazyTreeNode {
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSubclassAdded(ClsEvent event) {
            if (event.getSubclass().isVisible()) {
                ClassTreeNode.this.childAdded(event.getSubclass());
            }
        }

        public void directSubclassRemoved(ClsEvent event) {
            if (event.getSubclass().isVisible()) {
                ClassTreeNode.this.childRemoved(event.getSubclass());
            }
        }

        public void directSubclassMoved(ClsEvent event) {
            Cls subclass = event.getSubclass();
            int index = new ArrayList(ClassTreeNode.this.getChildObjects()).indexOf(subclass);
            if (index != -1) {
                ClassTreeNode.this.childRemoved(subclass);
                ClassTreeNode.this.childAdded(subclass, index);
            }
        }

        public void directInstanceAdded(ClsEvent event) {
            ClassTreeNode.this.notifyNodeChanged();
        }

        public void directInstanceRemoved(ClsEvent event) {
            ClassTreeNode.this.notifyNodeChanged();
        }

        public void templateFacetValueChanged(ClsEvent event) {
            ClassTreeNode.this.notifyNodeChanged();
        }

        public void directSuperclassAdded(ClsEvent event) {
            ClassTreeNode.this.notifyNodeChanged();
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent event) {
            ClassTreeNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent event) {
            if (event.getSlot().getName().equals(":DIRECT-TYPE")) {
                Cls cls = ClassTreeNode.this.getCls().getKnowledgeBase().getCls(ClassTreeNode.this.getCls().getName());
                ClassTreeNode.this.reload(cls);
            } else {
                ClassTreeNode.this.notifyNodeChanged();
            }
        }

        public void visibilityChanged(FrameEvent event) {
            ClassTreeNode.this.notifyNodeChanged();
        }
    };

    public ClassTreeNode(LazyTreeNode parentNode, Cls parentCls) {
        super(parentNode, (Object)parentCls);
        parentCls.addClsListener(this._clsListener);
        parentCls.addFrameListener(this._frameListener);
    }

    protected LazyTreeNode createNode(Object o) {
        return new ClassTreeNode(this, (Cls)o);
    }

    protected void dispose() {
        super.dispose();
        this.getCls().removeClsListener(this._clsListener);
        this.getCls().removeFrameListener(this._frameListener);
    }

    protected int getChildObjectCount() {
        if (this.showHidden()) {
            return this.getCls().getDirectSubclassCount();
        }
        return this.getChildObjects().size();
    }

    protected Collection getChildObjects() {
        if (this.showHidden()) {
            return this.getCls().getDirectSubclasses();
        }
        Cls cls = this.getCls();
        ArrayList result = new ArrayList(cls.getVisibleDirectSubclasses());
        if (cls instanceof OWLNamedClass) {
            for (RDFSClass equi : ((OWLNamedClass)cls).getEquivalentClasses()) {
                if (!(equi instanceof OWLNamedClass) || equi.getSuperclassCount() <= 1) continue;
                result.remove(equi);
            }
        }
        return result;
    }

    protected Cls getCls() {
        return (Cls)this.getUserObject();
    }

    protected Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }

    private boolean showHidden() {
        return this.getCls().getProject().getDisplayHiddenClasses();
    }

    public String toString() {
        return "ParentChildNode(" + this.getCls() + ")";
    }
}

