/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;

public class ToggleSuperclassExplorerAction
extends AbstractAction {
    private Component component;
    private ExplorerTreePanel explorerTreePanel;
    private Selectable selectable;
    private boolean useInferredSuperclasses;

    public ToggleSuperclassExplorerAction(Selectable selectable, boolean useInferredSuperclasses) {
        super("Show/Hide superclass explorer", OWLIcons.getImageIcon("SuperclassExplorer"));
        this.component = (Component)selectable;
        this.selectable = selectable;
        this.useInferredSuperclasses = useInferredSuperclasses;
        selectable.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                if (ToggleSuperclassExplorerAction.this.explorerTreePanel != null) {
                    RDFSClass root = ToggleSuperclassExplorerAction.this.getSelectedClass();
                    ToggleSuperclassExplorerAction.this.explorerTreePanel.setRoot(root);
                    ToggleSuperclassExplorerAction.this.explorerTreePanel.expandToFillSpace();
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        Component c = this.component;
        while (c != null && !(c instanceof HierarchyPanel)) {
            c = c.getParent();
        }
        if (c != null) {
            HierarchyPanel panel = (HierarchyPanel)c;
            if (panel.getNestedHierarchy() != null) {
                panel.setNestedHierarchy(null);
                this.explorerTreePanel = null;
            } else {
                RDFSClass root = this.getSelectedClass();
                String prefix = this.useInferredSuperclasses ? "Inferred" : "Asserted";
                this.explorerTreePanel = new ExplorerTreePanel(root, new ExplorerFilter(){

                    public boolean getUseInferredSuperclasses() {
                        return ToggleSuperclassExplorerAction.this.useInferredSuperclasses;
                    }

                    public boolean isValidChild(RDFSClass parentClass, RDFSClass childClass) {
                        return childClass instanceof RDFSNamedClass;
                    }
                }, String.valueOf(prefix) + " Superclasses", false);
                panel.setNestedHierarchy(this.explorerTreePanel);
                this.explorerTreePanel.expandToFillSpace();
            }
        }
    }

    private RDFSClass getSelectedClass() {
        RDFSClass selectedClass = null;
        Collection sel = this.selectable.getSelection();
        if (sel != null && sel.size() > 0) {
            selectedClass = (RDFSClass)CollectionUtilities.getFirstItem((Collection)sel);
        }
        return selectedClass;
    }
}

