/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableModel;
import java.util.ArrayList;
import java.util.Collection;

public class PropertiesDefinitionTableModel
extends AbstractOWLTableModel
implements ClassDescriptionTableModel {
    public PropertiesDefinitionTableModel() {
        super(0);
    }

    public boolean addRow(RDFSClass aClass, int selectedRow) {
        RDFSClass oldDefinition = this.getEditedCls().getDefinition();
        if (oldDefinition instanceof OWLIntersectionClass) {
            OWLIntersectionClass intersectionCls = (OWLIntersectionClass)oldDefinition;
            for (Cls operand : intersectionCls.getOperands()) {
                if (!operand.getBrowserText().equals(aClass.getBrowserText())) continue;
                return false;
            }
            OWLIntersectionClass newDefinition = (OWLIntersectionClass)intersectionCls.createClone();
            newDefinition.addOperand(aClass);
            oldDefinition.delete();
            this.getEditedCls().addEquivalentClass(newDefinition);
            if (aClass instanceof RDFSNamedClass) {
                this.getEditedCls().addSuperclass(aClass);
            }
        } else {
            if (oldDefinition.getBrowserText().equals(aClass.getBrowserText())) {
                return false;
            }
            OWLIntersectionClass intersectionCls = aClass.getOWLModel().createOWLIntersectionClass();
            intersectionCls.addOperand(oldDefinition);
            intersectionCls.addOperand(aClass);
            this.getEditedCls().setDefinition(intersectionCls);
        }
        return true;
    }

    protected void addRows() {
        for (RDFSClass aClass : this.getDefinitionOperands()) {
            this.insertRow(aClass);
        }
    }

    public void deleteRow(int index) {
        RDFSClass oldCls = this.getClass(index);
        if (oldCls instanceof OWLAnonymousClass) {
            RDFSClass definition = this.getEditedCls().getDefinition();
            if (definition instanceof OWLIntersectionClass) {
                OWLIntersectionClass oldIntersectionCls = (OWLIntersectionClass)definition;
                ArrayList operands = new ArrayList(oldIntersectionCls.getOperands());
                operands.remove(oldCls);
                if (operands.size() > 1) {
                    OWLModel owlModel = (OWLModel)oldCls.getKnowledgeBase();
                    OWLIntersectionClass newIntersectionCls = owlModel.createOWLIntersectionClass();
                    for (RDFSClass operand : operands) {
                        newIntersectionCls.addOperand(operand.createClone());
                    }
                    definition.delete();
                    this.getEditedCls().addEquivalentClass(newIntersectionCls);
                } else {
                    RDFSClass remainingOperand = (RDFSClass)operands.iterator().next();
                    RDFSClass clone = remainingOperand.createClone();
                    definition.delete();
                    this.getEditedCls().addEquivalentClass(clone);
                }
            } else {
                definition.delete();
            }
        } else {
            super.deleteRow(index);
        }
    }

    private Collection getDefinitionOperands() {
        RDFSClass definition;
        ArrayList<RDFSClass> result = new ArrayList<RDFSClass>();
        if (this.getEditedCls() != null && (definition = this.getEditedCls().getDefinition()) != null) {
            if (definition instanceof OWLIntersectionClass) {
                result.addAll(((OWLIntersectionClass)definition).getOperands());
            } else {
                result.add(definition);
            }
        }
        return result;
    }

    protected int getInsertRowIndex(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            return 0;
        }
        return this.getRowCount();
    }

    public RDFProperty getPredicate(int row) {
        return null;
    }

    public boolean isDeleteEnabledFor(RDFSClass cls) {
        return cls instanceof OWLAnonymousClass;
    }

    public boolean isRemoveEnabledFor(Cls cls) {
        return cls instanceof RDFSNamedClass && this.getRowCount() > 1 && this.getEditedCls().getNamedSuperclasses().size() > 1;
    }

    protected boolean isSuitable(Cls cls) {
        return cls instanceof RDFSClass && !this.getEditedCls().equals(cls) && this.getDefinitionOperands().contains(cls) && !(cls instanceof OWLRestriction) && (cls instanceof OWLAnonymousClass || cls.isVisible());
    }

    protected void setValueAt(int rowIndex, OWLModel owlModel, String parsableText) throws Exception {
        if (rowIndex >= this.getRowCount()) {
            return;
        }
        OWLNamedClass cls = this.getEditedCls();
        OWLClassParser parser = owlModel.getOWLClassDisplay().getParser();
        RDFSClass newClass = parser.parseClass(owlModel, parsableText);
        RDFSClass oldClass = this.getClass(rowIndex);
        String newBrowserCls = newClass.getBrowserText();
        if (oldClass == null) {
            if (!this.addRow(newClass, 0)) {
                this.displaySemanticError("The class " + newBrowserCls + " is already a superclass of " + cls.getBrowserText() + ".");
                if (newClass instanceof OWLAnonymousClass) {
                    newClass.delete();
                }
            }
        } else if (oldClass.getBrowserText().equals(newBrowserCls)) {
            if (newClass instanceof OWLAnonymousClass) {
                newClass.delete();
            }
        } else {
            RDFSClass definition = cls.getDefinition();
            if (definition instanceof OWLIntersectionClass) {
                OWLIntersectionClass oldIntersectionCls = (OWLIntersectionClass)definition;
                OWLIntersectionClass newIntersectionCls = owlModel.createOWLIntersectionClass();
                for (RDFSClass operand : oldIntersectionCls.getOperands()) {
                    if (operand.equals(oldClass)) {
                        newIntersectionCls.addOperand(newClass);
                        continue;
                    }
                    newIntersectionCls.addOperand(operand.createClone());
                }
                if (oldClass instanceof RDFSNamedClass) {
                    cls.removeSuperclass(oldClass);
                }
                oldIntersectionCls.delete();
                cls.addEquivalentClass(newIntersectionCls);
                if (newClass instanceof RDFSNamedClass) {
                    cls.addSuperclass(newClass);
                }
                if (cls.getSuperclassCount() == 1) {
                    cls.addSuperclass(owlModel.getOWLThingClass());
                }
            } else {
                cls.addEquivalentClass(newClass);
                if (oldClass instanceof OWLAnonymousClass) {
                    oldClass.delete();
                } else {
                    cls.removeSuperclass(oldClass);
                    if (cls.getSuperclassCount() == 1 && newClass instanceof OWLAnonymousClass) {
                        cls.addSuperclass(owlModel.getOWLThingClass());
                    }
                }
            }
        }
    }
}

