/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc.manchester;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.classparser.manchester.ManchesterOWLParserUtil;
import edu.stanford.smi.protegex.owl.ui.clsdesc.manchester.SuggestionPopup;
import edu.stanford.smi.protegex.owl.ui.code.OWLResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextFormatter;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorHandler;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SyntaxConverter;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceIgnoreCaseComparator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public class ManchesterOWLTextPane
extends JTextPane
implements KeyListener {
    private JComboBox comboBox;
    private SymbolErrorDisplay errorDisplay;
    private ResourceNameMatcher resourceNameMatcher;
    private OWLModel model;
    private KeyEvent previousKeyPressed;
    public static final int SCALABLE_FRAME_COUNT = 1000;
    private SyntaxConverter syntaxConverter;
    private boolean inSaveTestMode = false;
    private SymbolEditorHandler editorHandler;
    private DocumentListener docListener;
    private Map styleMap;
    private Style defaultStyle;
    private static final Color RESTRICTION_KEYWORD_COLOR = Color.MAGENTA.darker();
    private static final Color LOGICAL_OPERAND_KEYWORD_COLOR = Color.CYAN.darker();
    private static Font font = new JList().getFont();
    private CaretListener caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            ManchesterOWLTextPane.this.performMatching();
        }
    };
    private FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            ManchesterOWLTextPane.this.cleanupPrevious();
        }
    };
    private Highlighter.HighlightPainter matchedHighlightPainter;
    private Highlighter.HighlightPainter unmatchedHighlightPainter;
    private Object h0;
    private Object h1;

    public ManchesterOWLTextPane(OWLModel kb, SymbolErrorDisplay errorDisplay, ResourceNameMatcher resourceNameMatcher, SyntaxConverter syntaxConverter) {
        this.model = kb;
        this.errorDisplay = errorDisplay;
        this.resourceNameMatcher = resourceNameMatcher;
        this.syntaxConverter = syntaxConverter;
        this.resourceNameMatcher = new OWLResourceNameMatcher();
        this.setFont(font);
        this.setBackground(Color.white);
        this.removeAll();
        this.addKeyListener(this);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                if (ManchesterOWLTextPane.this.previousKeyPressed != null) {
                    int keyCode = ManchesterOWLTextPane.this.previousKeyPressed.getKeyCode();
                    if (!ManchesterOWLTextPane.isIdChar(ManchesterOWLTextPane.this.previousKeyPressed.getKeyChar()) && keyCode != 8 && keyCode != 127) {
                        ManchesterOWLTextPane.this.closeComboBox();
                    }
                }
            }
        });
        this.initColorMap();
        this.docListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ManchesterOWLTextPane.this.performHighlighting();
            }

            public void removeUpdate(DocumentEvent e) {
                ManchesterOWLTextPane.this.performHighlighting();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.getDocument().addDocumentListener(this.docListener);
        this.setFocusable(true);
        this.setupBrackertMatcher();
        Window owner = (Window)Application.getMainWindow();
        if (owner != null) {
            SuggestionPopup suggestionPopup = new SuggestionPopup(owner, this.model);
            suggestionPopup.setCurrentEditorPane(this);
        }
    }

    public int getPreferredHeight(int width) {
        View v = this.getUI().getRootView(this);
        v.setSize(width, 2.1474836E9f);
        return (int)v.getPreferredSpan(1);
    }

    private void initColorMap() {
        StyledDocument doc = (StyledDocument)this.getDocument();
        Style restrictionKWStyle = doc.addStyle("rs", null);
        StyleConstants.setForeground(restrictionKWStyle, RESTRICTION_KEYWORD_COLOR);
        StyleConstants.setBold(restrictionKWStyle, true);
        Style logicalKWStyle = doc.addStyle("lk", null);
        StyleConstants.setForeground(logicalKWStyle, LOGICAL_OPERAND_KEYWORD_COLOR);
        StyleConstants.setBold(logicalKWStyle, true);
        this.styleMap = new HashMap();
        this.styleMap.put(ManchesterOWLParserUtil.getAllKeyword(), restrictionKWStyle);
        this.styleMap.put(ManchesterOWLParserUtil.getSomeKeyword(), restrictionKWStyle);
        this.styleMap.put(ManchesterOWLParserUtil.getHasKeyword(), restrictionKWStyle);
        this.styleMap.put(ManchesterOWLParserUtil.getMinKeyword(), restrictionKWStyle);
        this.styleMap.put(ManchesterOWLParserUtil.getMaxKeyword(), restrictionKWStyle);
        this.styleMap.put(ManchesterOWLParserUtil.getExactKeyword(), restrictionKWStyle);
        this.styleMap.put(ManchesterOWLParserUtil.getAndKeyword(), logicalKWStyle);
        this.styleMap.put(ManchesterOWLParserUtil.getOrKeyword(), logicalKWStyle);
        this.styleMap.put(ManchesterOWLParserUtil.getNotKeyword(), logicalKWStyle);
        this.defaultStyle = doc.addStyle("def", null);
    }

    public void setSymbolEditorHandler(SymbolEditorHandler editorHandler) {
        this.editorHandler = editorHandler;
    }

    private void performHighlighting() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                String text = ManchesterOWLTextPane.this.getText();
                StringTokenizer tokenizer = new StringTokenizer(text, " ()[]{}", true);
                int start = 0;
                StyledDocument doc = (StyledDocument)ManchesterOWLTextPane.this.getDocument();
                while (tokenizer.hasMoreTokens()) {
                    String curToken = tokenizer.nextToken();
                    Style style = (Style)ManchesterOWLTextPane.this.styleMap.get(curToken);
                    if (style != null) {
                        doc.setCharacterAttributes(start, curToken.length(), style, true);
                    } else {
                        doc.setCharacterAttributes(start, curToken.length(), ManchesterOWLTextPane.this.defaultStyle, true);
                    }
                    start += curToken.length();
                }
            }
        });
        t.start();
    }

    private void acceptSelectedResource() {
        String text = this.getText();
        int pos = this.getCaretPosition();
        int i = pos - 1;
        while (i >= 0 && ManchesterOWLTextPane.isIdChar(text.charAt(i))) {
            --i;
        }
        String prefix = text.substring(i + 1, pos);
        RDFResource resource = (RDFResource)this.comboBox.getSelectedItem();
        this.extendPartialName(prefix, this.resourceNameMatcher.getInsertString(resource));
        this.updateErrorDisplay();
        this.closeComboBox();
    }

    protected void checkUniCodeExpression(String text) throws Throwable {
        this.model.getOWLClassDisplay().getParser().checkClass(this.model, text);
    }

    protected boolean isInSaveTestMode() {
        return this.inSaveTestMode;
    }

    private void closeComboBox() {
        this.removeAll();
    }

    private void extendPartialName(String prefix, String fullName) {
        try {
            this.getDocument().remove(this.getCaretPosition() - prefix.length(), prefix.length());
            this.getDocument().insertString(this.getCaretPosition(), fullName, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void extendPartialName(boolean autoInsert) {
        String text = this.getText();
        int pos = this.getCaretPosition();
        int i = pos - 1;
        while (i >= 0 && ManchesterOWLTextPane.isIdChar(text.charAt(i))) {
            --i;
        }
        String prefix = text.substring(i + 1, pos);
        String leftString = text.substring(0, i + 1);
        List resources = this.resourceNameMatcher.getMatchingResources(prefix, leftString, this.model);
        if (autoInsert && resources.size() == 1) {
            RDFResource resource = (RDFResource)resources.get(0);
            this.extendPartialName(prefix, this.resourceNameMatcher.getInsertString(resource));
            this.closeComboBox();
        } else if (resources.size() > 1) {
            this.showComboBox(resources, i + 1);
        }
    }

    protected OWLModel getmodel() {
        return this.model;
    }

    private int getXOfPosition(int pos) {
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        return metrics.stringWidth(this.getText().substring(0, pos));
    }

    private void handleDown() {
        int index;
        if (this.comboBox != null && this.comboBox.isVisible() && (index = this.comboBox.getSelectedIndex()) < this.comboBox.getItemCount() - 1) {
            this.comboBox.setSelectedIndex(index + 1);
        }
    }

    protected void handleEnter() {
        if (this.isComboBoxVisible()) {
            this.acceptSelectedResource();
        } else {
            this.inSaveTestMode = true;
            try {
                String uniCodeText = this.getText();
                this.checkUniCodeExpression(uniCodeText);
                if (this.editorHandler != null) {
                    this.editorHandler.stopEditing();
                }
            }
            catch (Throwable ex) {
                this.errorDisplay.displayError(ex);
                this.requestFocus();
            }
            this.inSaveTestMode = false;
        }
    }

    private void handleEscape() {
        if (this.isComboBoxVisible()) {
            this.closeComboBox();
        } else if (this.editorHandler != null) {
            this.editorHandler.cancelEditing();
        }
    }

    private void handleUp() {
        int index;
        if (this.isComboBoxVisible() && (index = this.comboBox.getSelectedIndex()) > 0) {
            this.comboBox.setSelectedIndex(index - 1);
        }
    }

    public void insertText(String text) {
        this.insertText(text, text.length());
    }

    public void insertText(String text, int caretOffset) {
        String selText = this.getSelectedText();
        if (selText != null && selText.length() > 0) {
            int start = this.getSelectionStart();
            try {
                this.getDocument().remove(start, this.getSelectionEnd() - start);
                this.getDocument().insertString(start, text, null);
                this.setCaretPosition(start + caretOffset);
            }
            catch (BadLocationException ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        } else {
            try {
                int pos = this.getCaretPosition();
                this.getDocument().insertString(pos, text, null);
                this.setCaretPosition(pos + caretOffset);
            }
            catch (BadLocationException ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        }
        this.updateErrorDisplay();
        this.requestFocus();
    }

    private boolean isComboBoxVisible() {
        return this.comboBox != null && this.comboBox.isVisible() && this.comboBox.isShowing();
    }

    public static boolean isIdChar(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == ':' || ch == '-';
    }

    public void keyPressed(KeyEvent e) {
        this.updateErrorDisplay();
        this.previousKeyPressed = e;
        int code = e.getKeyCode();
        if (e.getKeyCode() == 9 || e.getKeyChar() == ' ' && (e.getModifiers() & 2) != 0) {
            this.extendPartialName(true);
            e.consume();
        } else {
            switch (code) {
                case 40: {
                    if (this.comboBox == null || !this.comboBox.isVisible()) break;
                    this.handleDown();
                    e.consume();
                    break;
                }
                case 38: {
                    if (this.comboBox == null || !this.comboBox.isVisible()) break;
                    this.handleUp();
                    e.consume();
                    break;
                }
                case 27: {
                    this.handleEscape();
                    e.consume();
                    break;
                }
                case 10: {
                    this.handleEnter();
                    e.consume();
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        this.perhapsConvertSyntax(e);
        this.updateErrorDisplay();
        int code = e.getKeyCode();
        if (code != 40 && code != 38) {
            this.refreshComboBox();
        }
    }

    public void keyTyped(KeyEvent e) {
        this.perhapsConvertSyntax(e);
    }

    private void perhapsConvertSyntax(KeyEvent e) {
        if (this.syntaxConverter != null) {
            char ch = e.getKeyChar();
            int code = e.getKeyCode();
            if (!ManchesterOWLTextPane.isIdChar(ch) && code != 8 && code != 127) {
                this.syntaxConverter.convertSyntax(this);
            }
        }
    }

    private void refreshComboBox() {
        if (this.isComboBoxVisible()) {
            String leftString;
            String text = this.getText();
            int pos = this.getCaretPosition();
            int i = pos - 1;
            while (i >= 0 && ManchesterOWLTextPane.isIdChar(text.charAt(i))) {
                --i;
            }
            String prefix = text.substring(i + 1, pos);
            List frames = this.resourceNameMatcher.getMatchingResources(prefix, leftString = text.substring(0, i + 1), this.model);
            if (frames.size() == 0) {
                this.closeComboBox();
            } else {
                this.showComboBox(frames, i + 1);
            }
        }
    }

    void replaceText(String text) {
        this.setText(text);
        this.updateErrorDisplay();
        this.requestFocus();
    }

    private void showComboBox(List frames, int startIndex) {
        this.closeComboBox();
        Frame[] fs = frames.toArray(new Frame[0]);
        Arrays.sort(fs, new ResourceIgnoreCaseComparator());
        this.comboBox = new JComboBox<Frame>(fs);
        this.comboBox.setBackground(Color.white);
        this.comboBox.setRenderer(new FrameRenderer());
        this.comboBox.setSize(this.comboBox.getPreferredSize().width + 20, 0);
        int x = this.getXOfPosition(startIndex) - 16;
        this.comboBox.setLocation(x, this.getHeight());
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((long)e.getModifiers() & 0x10L) != 0L) {
                    ManchesterOWLTextPane.this.acceptSelectedResource();
                }
            }
        });
        this.add(this.comboBox);
        this.comboBox.showPopup();
    }

    private void updateErrorDisplay() {
        String uniCodeText = this.getText();
        try {
            this.checkUniCodeExpression(uniCodeText);
            this.errorDisplay.displayError((Throwable)null);
            this.setBackground(Color.white);
        }
        catch (Throwable ex) {
            this.errorDisplay.setErrorFlag(true);
            this.setBackground(new Color(240, 240, 240));
        }
    }

    protected void updateSyntax() {
        OWLTextFormatter.updateSyntax(this, this.model);
    }

    private void setupBrackertMatcher() {
        this.addListeners();
        this.unmatchedHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 190, 190));
        this.matchedHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(170, 170, 255));
    }

    private void addListeners() {
        this.addCaretListener(this.caretListener);
        this.addFocusListener(this.focusListener);
    }

    private void performMatching() {
        if (this.getCaret().isVisible()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ManchesterOWLTextPane.this.cleanupPrevious();
                    if (ManchesterOWLTextPane.this.isCaretBeforeOpeningBracket()) {
                        ManchesterOWLTextPane.this.doBeforeOpeningMatch();
                    }
                    if (ManchesterOWLTextPane.this.isCaretAfterClosingBracket()) {
                        ManchesterOWLTextPane.this.doAfterClosingMatch();
                    }
                }
            };
            Thread t = new Thread(runnable);
            t.start();
        }
    }

    private boolean isCaretBeforeOpeningBracket() {
        int caretPos = this.getCaretPosition();
        if (caretPos < this.getDocument().getLength() - 1) {
            return this.getText().charAt(caretPos) == '(';
        }
        return false;
    }

    private boolean isCaretAfterClosingBracket() {
        int caretPos = this.getCaretPosition();
        if (caretPos > 1) {
            return this.getText().charAt(caretPos - 1) == ')';
        }
        return false;
    }

    private void doBeforeOpeningMatch() {
        try {
            int pos = this.matchForward();
            int caretPos = this.getCaretPosition();
            if (pos == -1) {
                this.h0 = this.getHighlighter().addHighlight(caretPos, caretPos + 1, this.unmatchedHighlightPainter);
                this.h1 = null;
            } else {
                this.h0 = this.getHighlighter().addHighlight(caretPos, caretPos + 1, this.matchedHighlightPainter);
                this.h1 = this.getHighlighter().addHighlight(pos, pos + 1, this.matchedHighlightPainter);
            }
        }
        catch (BadLocationException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void doAfterClosingMatch() {
        try {
            int pos = this.matchReverse();
            int caretPos = this.getCaretPosition();
            if (pos == -1) {
                this.h0 = this.getHighlighter().addHighlight(caretPos - 1, caretPos, this.unmatchedHighlightPainter);
                this.h1 = null;
            } else {
                this.h0 = this.getHighlighter().addHighlight(caretPos - 1, caretPos, this.matchedHighlightPainter);
                this.h1 = this.getHighlighter().addHighlight(pos, pos + 1, this.matchedHighlightPainter);
            }
        }
        catch (BadLocationException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private int matchForward() {
        int pos = -1;
        int docLen = this.getDocument().getLength();
        int bracketCounter = 0;
        int fromPos = this.getCaretPosition() + 1;
        char[] chars = new char[docLen];
        this.getText().getChars(0, docLen, chars, 0);
        int i = fromPos;
        while (i < docLen) {
            if (chars[i] == '(') {
                ++bracketCounter;
            }
            if (chars[i] == ')' && bracketCounter == 0) {
                pos = i;
                break;
            }
            if (chars[i] == ')') {
                --bracketCounter;
            }
            ++i;
        }
        return pos;
    }

    private int matchReverse() {
        int fromPos = this.getCaretPosition() - 1;
        int pos = -1;
        try {
            char[] chars = new char[fromPos + 1];
            this.getDocument().getText(0, fromPos).getChars(0, fromPos, chars, 0);
            int bracketCounter = 0;
            int i = fromPos;
            while (i > -1) {
                if (chars[i] == ')') {
                    ++bracketCounter;
                }
                if (chars[i] == '(' && bracketCounter == 0) {
                    pos = i;
                    break;
                }
                if (chars[i] == '(') {
                    --bracketCounter;
                }
                --i;
            }
        }
        catch (BadLocationException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            return pos;
        }
        return pos;
    }

    private void cleanupPrevious() {
        if (this.h0 != null) {
            this.getHighlighter().removeHighlight(this.h0);
        }
        if (this.h1 != null) {
            this.getHighlighter().removeHighlight(this.h1);
        }
    }
}

