/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractRDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsproperties.NewRestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.OldRestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTreeRenderer;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextField;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorHandler;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionEditorPanel;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionKindRenderer;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class PropertyRestrictionsTree
extends SelectableTree
implements Disposable {
    private OWLNamedClass cls;
    private ClassListener classListener = new ClassAdapter(){

        public void subclassAdded(RDFSClass cls, RDFSClass subclass) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void subclassRemoved(RDFSClass cls, RDFSClass subclass) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void addedToUnionDomainOf(RDFSClass cls, RDFProperty property) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void removedFromUnionDomainOf(RDFSClass cls, RDFProperty property) {
            PropertyRestrictionsTree.this.refillLater();
        }
    };
    private AllowableAction createRestrictionAction = new AllowableAction("Create restriction...", OWLIcons.getCreateIcon("OWLRestriction"), (Selectable)this){

        public void actionPerformed(ActionEvent e) {
            if (!PropertyRestrictionsTree.this.isMixedClass() && (PropertyRestrictionsTree.this.cls.isEditable() || PropertyRestrictionsTree.this.cls.getDefinition() == null)) {
                PropertyRestrictionsTree.this.createRestrictionFromDialog(null);
            }
        }

        public void onSelectionChange() {
            PropertyRestrictionsTree.this.updateCreateRestrictionActionAllowed();
        }
    };
    private Action deleteRestrictionAction = new AllowableAction("Delete restriction", OWLIcons.getDeleteIcon("OWLRestriction"), (Selectable)this){

        public void actionPerformed(ActionEvent e) {
            Instance sel = PropertyRestrictionsTree.this.getSelectedInstance();
            OWLModel owlModel = (OWLModel)sel.getKnowledgeBase();
            try {
                try {
                    owlModel.beginTransaction("Delete restriction " + sel.getBrowserText());
                    sel.delete();
                }
                catch (Exception ex) {
                    OWLUI.handleError(owlModel, ex);
                }
            }
            finally {
                owlModel.endTransaction();
            }
        }

        public void onSelectionChange() {
            Instance sel = PropertyRestrictionsTree.this.getSelectedInstance();
            if (sel instanceof OWLRestriction && sel.isEditable() && PropertyRestrictionsTree.this.cls.equals(PropertyRestrictionsTree.this.getHostCls((OWLRestriction)sel))) {
                this.setAllowed(!PropertyRestrictionsTree.this.isMixedClass() && (PropertyRestrictionsTree.this.cls.isEditable() || PropertyRestrictionsTree.this.cls.getDefinition() == null));
                return;
            }
            this.setAllowed(false);
        }
    };
    private DefaultTreeModel model;
    private RestrictionTreeNode newNode;
    private OWLModel owlModel;
    private OWLTextField owlTextField;
    private DefaultMutableTreeNode rootNode;
    private OWLSymbolPanel symbolPanel;
    private boolean refilling = false;

    public PropertyRestrictionsTree(OWLModel owlModel) {
        this(owlModel, null);
    }

    public PropertyRestrictionsTree(OWLModel owlModel, OWLNamedClass cls) {
        super(null);
        this.cls = cls;
        this.owlModel = owlModel;
        ComponentFactory.configureTree((JTree)((Object)this), (Action)new AbstractAction("View property/Edit restriction"){

            public void actionPerformed(ActionEvent e) {
                PropertyRestrictionsTree.this.viewSelectedProperty();
            }
        });
        this.setLargeModel(true);
        this.rootNode = new DefaultMutableTreeNode("Root");
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.model = new DefaultTreeModel(this.rootNode);
        this.setModel(this.model);
        final int oldDelay = ToolTipManager.sharedInstance().getDismissDelay();
        this.setToolTipText("");
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Instance instance;
                if (e.getClickCount() == 2 && (instance = PropertyRestrictionsTree.this.getSelectedInstance()) instanceof OWLRestriction && PropertyRestrictionsTree.this.isEditable()) {
                    PropertyRestrictionsTree.this.startEditing(e);
                }
            }

            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(oldDelay);
            }
        });
        this.addChildNodes();
        this.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                PropertyRestrictionsTree.this.updateEditable();
            }
        });
        MyTreeCellEditor cellEditor = new MyTreeCellEditor();
        this.setCellEditor(cellEditor);
        cellEditor.addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent e) {
                PropertyRestrictionsTree.this.hideSymbolPanel();
                if (PropertyRestrictionsTree.this.newNode != null) {
                    PropertyRestrictionsTree.this.refill();
                    PropertyRestrictionsTree.this.newNode = null;
                }
            }

            public void editingStopped(ChangeEvent e) {
                PropertyRestrictionsTree.this.hideSymbolPanel();
                PropertyRestrictionsTree.this.newNode = null;
            }
        });
        this.symbolPanel = new OWLSymbolPanel(owlModel, true, true);
        this.owlTextField = new OWLTextField(owlModel, this.symbolPanel){

            protected void checkExpression(String text) throws Throwable {
                RestrictionTreeNode node = (RestrictionTreeNode)PropertyRestrictionsTree.this.getSelectedTreeNode();
                node.checkExpression(text);
            }

            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                JViewport parent = (JViewport)PropertyRestrictionsTree.this.getParent();
                int width = Math.max(150, parent.getWidth() - 60);
                return new Dimension(width, dim.height);
            }

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            protected void stopEditing() {
                PropertyRestrictionsTree.this.stopEditing();
            }
        };
    }

    public String getToolTipText(MouseEvent event) {
        TreePath path;
        int row = this.getRowForLocation(event.getX(), event.getY());
        if (row >= 0 && (path = this.getPathForRow(row)) != null) {
            Object last = path.getLastPathComponent();
            RDFResource res = null;
            if (last instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                res = (RDFResource)node.getUserObject();
            }
            if (res != null) {
                ToolTipManager.sharedInstance().setDismissDelay(1000000);
                return OWLUI.getOWLToolTipText(res);
            }
        }
        return null;
    }

    private void addChildNodes() {
        if (this.cls != null && !this.cls.equals(this.cls.getOWLModel().getOWLThingClass())) {
            Collection domainProperties = this.cls.getUnionDomainProperties(true);
            ArrayList<OWLNamedClass> list = new ArrayList<OWLNamedClass>();
            list.add(this.cls);
            HashSet<RDFSNamedClass> reachedClses = new HashSet<RDFSNamedClass>();
            boolean inherited = false;
            HashSet doneProperties = new HashSet();
            while (!list.isEmpty()) {
                RDFSNamedClass c = (RDFSNamedClass)list.get(0);
                reachedClses.add(c);
                list.remove(0);
                this.addNodesForDirectUnionDomainProperty(c, domainProperties, doneProperties, inherited);
                List superClses = this.getNextSuperclasses(c, reachedClses);
                list.addAll(superClses);
                inherited = true;
            }
            Set associatedProperties = this.cls.getAssociatedProperties();
            associatedProperties.removeAll(doneProperties);
            for (RDFProperty rdfProperty : associatedProperties) {
                if (!rdfProperty.isVisible()) continue;
                PropertyTreeNode node = new PropertyTreeNode(this, this.cls, rdfProperty, inherited);
                this.rootNode.add(node);
                this.addNodesForSubproperties(rdfProperty, doneProperties, domainProperties);
            }
            this.sortPropertyTreeNodes();
            this.updateCreateRestrictionActionAllowed();
        }
        this.expandPath(new TreePath(this.rootNode));
    }

    void addCreateRestrictionActions(JPopupMenu menu) {
        if (!this.isMixedClass()) {
            OWLModel owlModel = this.cls.getOWLModel();
            Cls[] metaClses = ProfilesManager.getSupportedRestrictionMetaClses(owlModel);
            int i = 0;
            while (i < metaClses.length) {
                Cls metaCls = metaClses[i];
                String restrictionName = RestrictionKindRenderer.getClsName(metaCls);
                String iconName = RestrictionKindRenderer.getClsIconName(metaCls);
                Icon icon = OWLIcons.getCreateIcon(iconName);
                menu.add(new CreateRestrictionAction(metaCls, restrictionName, icon));
                ++i;
            }
        }
    }

    private void addNavigationMenuItems(JPopupMenu menu, Set set) {
        if (!set.isEmpty()) {
            Object[] instances = set.toArray(new RDFResource[0]);
            Arrays.sort(instances);
            int i = 0;
            while (i < instances.length) {
                Object resource = instances[i];
                menu.add(new AbstractAction("Navigate to " + resource.getBrowserText(), ProtegeUI.getIcon((RDFResource)resource), (RDFResource)resource){
                    private final /* synthetic */ RDFResource val$resource;
                    {
                        this.val$resource = rDFResource;
                        super($anonymous0, $anonymous1);
                    }

                    public void actionPerformed(ActionEvent e) {
                        PropertyRestrictionsTree.this.navigateTo(this.val$resource);
                    }
                });
                ++i;
            }
        }
    }

    private void addNodesForDirectUnionDomainProperty(RDFSNamedClass c, Collection allowedProperties, Set doneProperties, boolean inherited) {
        ArrayList<RDFProperty> properties = new ArrayList<RDFProperty>();
        for (RDFProperty property : c.getUnionDomainProperties()) {
            if (doneProperties.contains(property) || property.isAnnotationProperty() || !allowedProperties.contains(property)) continue;
            properties.add(property);
        }
        for (RDFProperty rdfProperty : properties) {
            PropertyTreeNode node = new PropertyTreeNode(this, this.cls, rdfProperty, inherited);
            this.rootNode.add(node);
            doneProperties.add(rdfProperty);
        }
        for (RDFProperty rdfProperty : properties) {
            this.addNodesForSubproperties(rdfProperty, doneProperties, allowedProperties);
        }
    }

    private void addNodesForSubproperties(RDFProperty rdfProperty, Set doneProperties, Collection allowedProperties) {
        for (RDFProperty subProperty : rdfProperty.getSubproperties(true)) {
            if (doneProperties.contains(subProperty) || !allowedProperties.contains(subProperty)) continue;
            PropertyTreeNode node = new PropertyTreeNode(this, this.cls, subProperty, true);
            this.rootNode.add(node);
            doneProperties.add(subProperty);
        }
    }

    private void addRestrictionToDefinition(OWLRestriction newRestriction) {
        OWLModel owlModel = this.cls.getOWLModel();
        AbstractRDFSClass definition = (AbstractRDFSClass)this.cls.getDefinition();
        if (definition instanceof OWLIntersectionClass) {
            OWLIntersectionClass intersectionClass = (OWLIntersectionClass)((Object)definition);
            String browserText = newRestriction.getBrowserText();
            if (intersectionClass.hasOperandWithBrowserText(browserText)) {
                this.displaySemanticError("The class " + browserText + " is already in the list.");
                return;
            }
            intersectionClass.addOperand(newRestriction);
        } else {
            OWLIntersectionClass intersectionClass = owlModel.createOWLIntersectionClass();
            intersectionClass.addOperand(definition.createClone());
            intersectionClass.addOperand(newRestriction);
            if (definition instanceof OWLAnonymousClass) {
                definition.delete();
            }
            definition.delete();
            this.cls.addEquivalentClass(intersectionClass);
        }
    }

    private void createRestrictionInline(Cls metaCls) {
        Instance sel = this.getSelectedInstance();
        if (sel != null) {
            RDFProperty property = sel instanceof RDFProperty ? (RDFProperty)sel : ((OWLRestriction)sel).getOnProperty();
            PropertyTreeNode propertyTreeNode = this.getPropertyTreeNode(property);
            this.expandPath(new TreePath(new Object[]{this.rootNode, propertyTreeNode}));
            this.newNode = new NewRestrictionTreeNode(metaCls, this);
            int index = -1;
            while (index + 1 < propertyTreeNode.getChildCount() && !propertyTreeNode.getRestrictionTreeNode(index + 1).isInherited()) {
                ++index;
            }
            propertyTreeNode.insert(this.newNode, ++index);
            this.model.nodesWereInserted(propertyTreeNode, new int[]{index});
            TreePath path = new TreePath(new Object[]{this.rootNode, propertyTreeNode, this.newNode});
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
            this.updateUI();
            this.startEditingAtPath(path);
            this.owlTextField.setCaretPosition(0);
        }
    }

    private void createRestrictionFromDialog(Cls restrictionMetaCls) {
        Instance sel = this.getSelectedInstance();
        RDFProperty property = null;
        if (sel != null) {
            RDFProperty rDFProperty = property = sel instanceof RDFProperty ? (RDFProperty)sel : ((OWLRestriction)sel).getOnProperty();
        }
        if (restrictionMetaCls == null) {
            restrictionMetaCls = property != null ? property.getOWLModel().getCls("owl:SomeValuesFromRestriction") : this.cls.getOWLModel().getRDFSNamedClass("owl:SomeValuesFromRestriction");
        }
        this.createRestrictionFromDialog((Cls)restrictionMetaCls, property);
    }

    private void createRestrictionFromDialog(Cls restrictionMetaCls, RDFProperty property) {
        block7: {
            OWLRestriction newRestriction;
            OWLModel owlModel;
            block8: {
                owlModel = this.cls.getOWLModel();
                owlModel.beginTransaction("Create restriction at " + this.cls.getBrowserText());
                newRestriction = RestrictionEditorPanel.showCreateDialog((Component)((Object)this), this.cls, restrictionMetaCls, property);
                if (newRestriction == null) break block7;
                String browserText = newRestriction.getBrowserText();
                Slot directSuperclassesSlot = this.cls.getOWLModel().getSlot(":DIRECT-SUPERCLASSES");
                if (!((AbstractRDFSClass)((Object)this.cls)).hasPropertyValueWithBrowserText(directSuperclassesSlot, browserText)) break block8;
                this.displaySemanticError("The restriction " + browserText + " is already in the list.");
                newRestriction.delete();
                owlModel.endTransaction();
                return;
            }
            try {
                try {
                    RDFSClass definition = this.cls.getDefinition();
                    if (definition == null) {
                        this.cls.addSuperclass(newRestriction);
                        break block7;
                    }
                    this.addRestrictionToDefinition(newRestriction);
                }
                catch (Exception ex) {
                    OWLUI.handleError(owlModel, ex);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                owlModel.endTransaction();
            }
        }
    }

    public void displaySemanticError(String message) {
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, message);
    }

    public void dispose() {
        this.removeListeners();
        this.disposeNodes();
    }

    private void disposeNodes() {
        PropertyTreeNode[] nodes = this.getPropertyTreeNodes();
        int i = 0;
        while (i < nodes.length) {
            PropertyTreeNode node = nodes[i];
            node.dispose();
            ++i;
        }
        this.rootNode.removeAllChildren();
    }

    private void expandPropertyNodes(Set openProperties) {
        PropertyTreeNode[] newNodes = this.getPropertyTreeNodes();
        int i = 0;
        while (i < newNodes.length) {
            PropertyTreeNode node = newNodes[i];
            if (openProperties.contains(node.getRDFProperty())) {
                this.expandPath(new TreePath(new Object[]{this.rootNode, node}));
            }
            ++i;
        }
    }

    public Action getCreateRestrictionAction() {
        return this.createRestrictionAction;
    }

    public Action getDeleteRestrictionAction() {
        return this.deleteRestrictionAction;
    }

    private Set getExpandedProperties() {
        HashSet<RDFProperty> expandedProperties = new HashSet<RDFProperty>();
        PropertyTreeNode[] oldNodes = this.getPropertyTreeNodes();
        int i = 0;
        while (i < oldNodes.length) {
            PropertyTreeNode node = oldNodes[i];
            TreePath path = new TreePath(new Object[]{this.rootNode, node});
            if (this.isExpanded(path)) {
                expandedProperties.add(node.getRDFProperty());
            }
            ++i;
        }
        return expandedProperties;
    }

    private OWLNamedClass getHostCls(OWLRestriction restriction) {
        return restriction.getOwner();
    }

    private List getNextSuperclasses(RDFSNamedClass c, Set reachedClses) {
        OWLNamedClass owlThing = c.getOWLModel().getOWLThingClass();
        ArrayList<Cls> superClses = new ArrayList<Cls>();
        for (Cls superCls : c.getSuperclasses(false)) {
            if (!(superCls instanceof RDFSNamedClass) || reachedClses.contains(superCls) || owlThing.equals(superCls)) continue;
            superClses.add(superCls);
        }
        Collections.sort(superClses, new FrameComparator());
        return superClses;
    }

    private JLayeredPane getParentLayeredPane() {
        Container c = this.getParent();
        while (c != null && !(c instanceof JLayeredPane)) {
            c = c.getParent();
        }
        return (JLayeredPane)c;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        RDFResource resource = (RDFResource)this.getSelectedInstance();
        if (resource instanceof RDFProperty) {
            this.addCreateRestrictionActions(menu);
        } else if (resource instanceof OWLRestriction) {
            OWLQuantifierRestriction qr;
            if (resource instanceof OWLQuantifierRestriction && (qr = (OWLQuantifierRestriction)resource).getFiller() instanceof RDFSClass) {
                RDFSClass cls = (RDFSClass)qr.getFiller();
                HashSet set = new HashSet();
                cls.getNestedNamedClasses(set);
                this.addNavigationMenuItems(menu, set);
            }
            RestrictionTreeNode treeNode = (RestrictionTreeNode)this.getSelectedTreeNode();
            final RDFSClass definingClass = treeNode.getInheritedFromClass();
            if (treeNode.isInherited()) {
                menu.add(new AbstractAction("Navigate to defining class (" + definingClass.getBrowserText() + ")", ProtegeUI.getIcon(definingClass)){

                    public void actionPerformed(ActionEvent e) {
                        PropertyRestrictionsTree.this.navigateTo(definingClass);
                    }
                });
            }
            menu.add(this.deleteRestrictionAction);
        }
        ResourceActionManager.addResourceActions(menu, (Component)((Object)this), resource);
        if (menu.getSubElements().length > 0) {
            return menu;
        }
        return null;
    }

    private PropertyTreeNode getPropertyTreeNode(RDFProperty property) {
        PropertyTreeNode[] nodes = this.getPropertyTreeNodes();
        int i = 0;
        while (i < nodes.length) {
            PropertyTreeNode node = nodes[i];
            if (property.equals(node.getRDFProperty())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public PropertyTreeNode[] getPropertyTreeNodes() {
        int count = this.rootNode.getChildCount();
        PropertyTreeNode[] results = new PropertyTreeNode[count];
        int i = 0;
        while (i < count) {
            results[i] = (PropertyTreeNode)this.rootNode.getChildAt(i);
            ++i;
        }
        return results;
    }

    public Instance getSelectedInstance() {
        if (this.getSelectionCount() == 1) {
            DefaultMutableTreeNode treeNode = this.getSelectedTreeNode();
            return (Instance)treeNode.getUserObject();
        }
        return null;
    }

    public Collection getSelectedInstances() {
        ArrayList<Object> sels = new ArrayList<Object>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                if (path.getPathCount() > 0) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    sels.add(node.getUserObject());
                }
                ++i;
            }
        }
        return sels;
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        TreePath path = this.getSelectionPath();
        if (path != null && path.getPathCount() > 0) {
            return (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    public Collection getSelection() {
        return this.getSelectedInstances();
    }

    public void hideSymbolPanel() {
        Container parent;
        if (this.symbolPanel != null && (parent = this.symbolPanel.getParent()) != null) {
            parent.remove(this.symbolPanel);
            Container top = this.getTopLevelAncestor();
            if (top == null) {
                Container c = parent;
                while (c.getParent() != null) {
                    c = c.getParent();
                    c.repaint();
                }
            } else if (top instanceof JFrame) {
                ((JFrame)top).getContentPane().repaint();
            } else if (top instanceof JWindow) {
                ((JWindow)top).getContentPane().repaint();
            } else if (top instanceof JDialog) {
                ((JDialog)top).getContentPane().repaint();
            } else {
                top.repaint();
            }
        }
    }

    public void init(boolean displayRestrictions, boolean hideGlobalCharacteristics) {
        this.setCellRenderer((TreeCellRenderer)((Object)new PropertyRestrictionsTreeRenderer(displayRestrictions, hideGlobalCharacteristics)));
    }

    public boolean isEditable() {
        return super.isEditable() && !this.isMixedClass();
    }

    public boolean isMixedClass() {
        RDFSClass definition = this.cls.getDefinition();
        return definition != null;
    }

    protected void navigateTo(RDFResource instance) {
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
        if (tab != null && instance instanceof RDFSNamedClass) {
            tab.setSelectedCls((RDFSNamedClass)instance);
        } else {
            ResultsPanelManager.showHostResource(instance);
        }
    }

    public void openNodesIfPossible() {
        if (this.getParent() instanceof JViewport) {
            JViewport viewPort = (JViewport)this.getParent();
            int rowHeight = this.getRowHeight();
            int i = this.rootNode.getChildCount() - 1;
            PropertyTreeNode recentNode = null;
            while (i >= 0 && this.getRowCount() * rowHeight < viewPort.getExtentSize().height) {
                PropertyTreeNode node = (PropertyTreeNode)this.rootNode.getChildAt(i);
                if (node.getChildCount() > 0) {
                    TreePath path = new TreePath(new Object[]{this.rootNode, node});
                    this.expandPath(path);
                    recentNode = node;
                }
                --i;
            }
            if (recentNode != null && this.getRowCount() * rowHeight > viewPort.getExtentSize().height) {
                TreePath path = new TreePath(new Object[]{this.rootNode, recentNode});
                this.collapsePath(path);
            }
        }
    }

    void refill() {
        Set expandedProperties = this.getExpandedProperties();
        this.disposeNodes();
        this.addChildNodes();
        this.model.nodeStructureChanged(this.rootNode);
        this.expandPropertyNodes(expandedProperties);
    }

    void refillLater() {
        if (!this.refilling) {
            this.refilling = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PropertyRestrictionsTree.this.refill();
                    PropertyRestrictionsTree.this.refilling = false;
                }
            });
        }
    }

    private void removeListeners() {
        if (this.cls != null) {
            this.cls.removeClassListener(this.classListener);
        }
    }

    public void setCls(OWLNamedClass cls) {
        if (cls != this.cls) {
            this.removeListeners();
            this.disposeNodes();
            this.cls = cls;
            this.addChildNodes();
            this.model.nodeStructureChanged(this.rootNode);
            if (cls != null) {
                cls.addClassListener(this.classListener);
            }
        }
    }

    public void setSelectedRestriction(OWLRestriction restriction) {
        OldRestrictionTreeNode n;
        RDFProperty property = restriction.getOnProperty();
        PropertyTreeNode propertyTreeNode = this.getPropertyTreeNode(property);
        if (propertyTreeNode != null && (n = propertyTreeNode.getRestrictionTreeNode(restriction.getBrowserText())) != null) {
            TreePath path = new TreePath(new Object[]{this.rootNode, propertyTreeNode, n});
            this.expandPath(path);
            this.setSelectionPath(path);
        }
    }

    private void showSymbolPanel(RDFProperty property, Cls restrictionMetaCls, boolean errorFlag) {
        int y;
        JLayeredPane desktop = this.getParentLayeredPane();
        Rectangle r = this.getRowBounds(this.getSelectionRows()[0]);
        Point tableLocation = this.getLocationOnScreen();
        Point desktopLocation = desktop.getLocationOnScreen();
        r.translate(tableLocation.x - desktopLocation.x, tableLocation.y - desktopLocation.y);
        Dimension pref = this.symbolPanel.getPreferredSize();
        int x = this.getX() + r.x;
        if (pref.width > r.width) {
            x = Math.max(0, this.getX() + r.x - (pref.width - r.width));
        }
        if ((y = r.y + r.height + 4) + this.symbolPanel.getHeight() >= desktop.getHeight()) {
            y = r.y - this.symbolPanel.getHeight();
        }
        this.symbolPanel.setLocation(x, y);
        this.symbolPanel.displayError((Throwable)null);
        this.symbolPanel.setErrorFlag(errorFlag);
        this.symbolPanel.enableActions(property, restrictionMetaCls);
        desktop.setLayer(this.symbolPanel, JLayeredPane.POPUP_LAYER);
        desktop.add(this.symbolPanel);
    }

    private void sortPropertyTreeNodes() {
        int count = this.rootNode.getChildCount();
        Object[] nodes = new PropertyTreeNode[count];
        int i = 0;
        while (i < count) {
            nodes[i] = (PropertyTreeNode)this.rootNode.getChildAt(i);
            ++i;
        }
        Arrays.sort(nodes);
        this.rootNode.removeAllChildren();
        i = 0;
        while (i < nodes.length) {
            Object node = nodes[i];
            this.rootNode.add((MutableTreeNode)node);
            ++i;
        }
    }

    private void startEditing(MouseEvent e) {
        this.startEditingAtPath(this.getSelectionPath());
        int mouseX = e.getX() - this.getRowBounds((int)this.getSelectionRows()[0]).x;
        mouseX -= this.owlTextField.getX();
        String str = this.owlTextField.getText();
        FontMetrics fm = this.owlTextField.getFontMetrics(this.owlTextField.getFont());
        int index = 1;
        while (index < str.length()) {
            if (fm.stringWidth(str.substring(0, index)) >= mouseX) {
                this.owlTextField.setCaretPosition(index - 1);
                break;
            }
            ++index;
        }
    }

    public void startEditingAtPath(TreePath path) {
        RestrictionTreeNode node = (RestrictionTreeNode)this.getSelectedTreeNode();
        Cls metaCls = node.getRestrictionMetaCls();
        super.startEditingAtPath(path);
        String metaClsName = metaCls.getName();
        OWLModel owlModel = (OWLModel)metaCls.getKnowledgeBase();
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Qualified_Cardinality_Restrictions) || "owl:AllValuesFromRestriction".equals(metaClsName) || "owl:SomeValuesFromRestriction".equals(metaClsName) || "owl:HasValueRestriction".equals(metaClsName)) {
            this.showSymbolPanel(node.getParentNode().getRDFProperty(), metaCls, false);
        }
    }

    private void updateCreateRestrictionActionAllowed() {
        boolean allowed = !this.isMixedClass() && (this.cls.isEditable() || this.cls.getDefinition() == null);
        this.createRestrictionAction.setAllowed(allowed);
    }

    private void updateEditable() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        boolean editable = false;
        if (selNode instanceof RestrictionTreeNode) {
            RestrictionTreeNode rtn = (RestrictionTreeNode)selNode;
            editable = !rtn.isInherited();
        }
        this.setEditable(editable);
    }

    private void viewSelectedProperty() {
        Instance instance = this.getSelectedInstance();
        if (instance instanceof RDFProperty) {
            ProtegeUI.show((RDFProperty)instance);
        }
    }

    private class CreateRestrictionAction
    extends AbstractAction {
        private Cls metaCls;

        CreateRestrictionAction(Cls metaCls, String restrictionName, Icon icon) {
            super("Create " + restrictionName + " restriction", icon);
            this.metaCls = metaCls;
        }

        public void actionPerformed(ActionEvent e) {
            PropertyRestrictionsTree.this.createRestrictionInline(this.metaCls);
        }
    }

    private class MyTreeCellEditor
    extends DefaultTreeCellEditor {
        MyTreeCellEditor() {
            super((JTree)((Object)PropertyRestrictionsTree.this), new DefaultTreeCellRenderer());
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            OWLTextField c = PropertyRestrictionsTree.this.owlTextField;
            PropertyRestrictionsTree.this.owlTextField.setSymbolEditorHandler(new SymbolEditorHandler(){

                public void stopEditing() {
                    MyTreeCellEditor.this.stopCellEditing();
                }

                public void cancelEditing() {
                    MyTreeCellEditor.this.cancelCellEditing();
                }
            });
            PropertyRestrictionsTree.this.symbolPanel.setSymbolEditor(PropertyRestrictionsTree.this.owlTextField);
            RestrictionTreeNode restrictionTreeNode = (RestrictionTreeNode)value;
            PropertyRestrictionsTree.this.owlTextField.setText(restrictionTreeNode.getFillerText());
            JPanel result = new JPanel(new BorderLayout(1, 0));
            result.setOpaque(false);
            result.add("Center", c);
            Icon icon = restrictionTreeNode.getIcon();
            result.add("West", new JLabel(icon));
            Dimension pref = result.getPreferredSize();
            result.setSize(new Dimension(pref.width + 100, pref.height));
            return result;
        }

        public Object getCellEditorValue() {
            return PropertyRestrictionsTree.this.owlTextField.getText();
        }
    }
}

