/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.OWLRemoveAction;
import edu.stanford.smi.protegex.owl.ui.clsproperties.AddPropertyAction;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTree;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PropertyRestrictionsTreeWidget
extends AbstractPropertyWidget {
    private ResourceSelectionAction addPropertyAction = new AddPropertyAction(this);
    private Action createDatatypePropertyAction = new AbstractAction("Create datatype property", OWLIcons.getCreatePropertyIcon("OWLDatatypeProperty")){

        public void actionPerformed(ActionEvent e) {
            PropertyRestrictionsTreeWidget.this.createProperty(PropertyRestrictionsTreeWidget.this.getOWLModel().getOWLDatatypePropertyClass());
        }
    };
    private Action createObjectPropertyAction = new AbstractAction("Create object property", OWLIcons.getCreatePropertyIcon("OWLObjectProperty")){

        public void actionPerformed(ActionEvent e) {
            PropertyRestrictionsTreeWidget.this.createProperty(PropertyRestrictionsTreeWidget.this.getOWLModel().getOWLObjectPropertyClass());
        }
    };
    private Action createRDFPropertyAction = new AbstractAction("Create RDF property", OWLIcons.getCreatePropertyIcon("RDFProperty")){

        public void actionPerformed(ActionEvent e) {
            PropertyRestrictionsTreeWidget.this.createProperty(PropertyRestrictionsTreeWidget.this.getOWLModel().getRDFPropertyClass());
        }
    };
    private static final String HIDE_GLOBAL_CHARACTERISTICS = "HideGlobalCharacteristics";
    private static final String DISPLAY_RESTRICTIONS = "DisplayRestrictions";
    private AllowableAction removeAction;
    public static final String LABEL = "Label";
    private PropertyRestrictionsTree tree;

    private void createProperty(RDFSNamedClass propertyMetaclass) {
        RDFProperty property;
        RDFSClass cls = (RDFSClass)this.getEditedResource();
        if (propertyMetaclass.isAbstract()) {
            Collection allowedClses = ((RDFSNamedClass)cls.getProtegeType()).getUnionRangeClasses(this.getRDFProperty());
            propertyMetaclass = ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this), this.getOWLModel(), allowedClses);
        }
        if (propertyMetaclass != null && (property = this.createProperty(propertyMetaclass, cls)) != null) {
            this.viewProperty(property);
        }
    }

    private RDFProperty createProperty(RDFSNamedClass propertyMetaclass, RDFSClass cls) {
        try {
            this.beginTransaction("Create new " + propertyMetaclass.getBrowserText());
            String baseName = propertyMetaclass.getName();
            int index = baseName.lastIndexOf(":");
            if (index >= 0) {
                baseName = baseName.substring(index + 1);
            }
            String name = ((AbstractOWLModel)this.getKnowledgeBase()).createNewResourceName(baseName);
            RDFProperty property = (RDFProperty)propertyMetaclass.createInstance(name);
            property.setDomainDefined(true);
            property.addUnionDomainClass(cls);
            RDFProperty rDFProperty = property;
            return rDFProperty;
        }
        catch (Exception ex) {
            OWLUI.handleError(this.getOWLModel(), ex);
            return null;
        }
        finally {
            this.endTransaction();
        }
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        return new MyWidgetConfigurationPanel();
    }

    private boolean getHideGlobalCharacteristics() {
        Boolean b = this.getPropertyList().getBoolean(HIDE_GLOBAL_CHARACTERISTICS);
        return b == null ? false : b;
    }

    public boolean getDisplayRestrictions() {
        Boolean b = this.getPropertyList().getBoolean(DISPLAY_RESTRICTIONS);
        return b == null ? false : b;
    }

    public String getLabel() {
        return this.getDisplayRestrictions() ? "Properties and Restrictions" : "Properties";
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Collection getSelection() {
        return this.tree.getSelection();
    }

    public void initialize() {
        final OWLModel owlModel = (OWLModel)this.getKnowledgeBase();
        this.tree = new PropertyRestrictionsTree(owlModel, null);
        this.removeAction = new OWLRemoveAction("Remove this class from the domain of the selected property", OWLIcons.getRemoveIcon("RDFProperty"), (Selectable)this.tree){

            public void onRemove(Collection objects) {
                for (Object o : objects) {
                    if (!(o instanceof RDFProperty)) continue;
                    this.onRemove(o);
                }
            }

            public void onRemove(Object o) {
                RDFProperty property = (RDFProperty)o;
                RDFSClass cls = (RDFSClass)PropertyRestrictionsTreeWidget.this.getEditedResource();
                try {
                    try {
                        owlModel.beginTransaction("Remove " + cls.getBrowserText() + " from the domain of " + property.getBrowserText());
                        property.removeUnionDomainClass(cls);
                        if (property instanceof RDFProperty) {
                            property.synchronizeDomainAndRangeOfInverse();
                        }
                    }
                    catch (Exception ex) {
                        OWLUI.handleError(owlModel, ex);
                    }
                }
                finally {
                    owlModel.endTransaction();
                }
            }

            public void onSelectionChange() {
                Collection sels = this.getSelection();
                boolean en = false;
                for (Object o : sels) {
                    if (!(o instanceof RDFProperty)) continue;
                    RDFProperty property = (RDFProperty)o;
                    RDFSClass cls = (RDFSClass)PropertyRestrictionsTreeWidget.this.getEditedResource();
                    if (property.isEditable() && property.getUnionDomain().contains(cls)) {
                        en = true;
                        continue;
                    }
                    en = false;
                    break;
                }
                this.setAllowed(en);
            }
        };
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.tree));
        OWLLabeledComponent lc = new OWLLabeledComponent(this.getLabel(), scrollPane, true, true);
        lc.setHeaderIcon(OWLIcons.getPropertiesIcon());
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.CreateRDFProperty)) {
            lc.addHeaderButton(this.createRDFPropertyAction);
        }
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Create_DatatypeProperty)) {
            lc.addHeaderButton(this.createDatatypePropertyAction);
        }
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Create_ObjectProperty)) {
            lc.addHeaderButton(this.createObjectPropertyAction);
        }
        lc.addHeaderButton(this.addPropertyAction);
        lc.addHeaderButton((Action)this.removeAction);
        lc.addHeaderSeparator();
        lc.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PropertyRestrictionsTreeWidget.this.setHideGlobalCharacteristics(!PropertyRestrictionsTreeWidget.this.getHideGlobalCharacteristics());
                }
            }
        });
        JButton createRestrictionButton = lc.addHeaderButton(this.tree.getCreateRestrictionAction());
        createRestrictionButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (PropertyRestrictionsTreeWidget.this.tree.getSelectedInstance() != null && SwingUtilities.isRightMouseButton(e) && PropertyRestrictionsTreeWidget.this.isEnabled()) {
                    JPopupMenu menu = new JPopupMenu();
                    PropertyRestrictionsTreeWidget.this.tree.addCreateRestrictionActions(menu);
                    Component button = (Component)e.getSource();
                    menu.show(button, e.getX(), button.getHeight());
                }
            }
        });
        lc.addHeaderButton(this.tree.getDeleteRestrictionAction());
        this.tree.init(this.getDisplayRestrictions(), this.getHideGlobalCharacteristics());
        this.add((Component)((Object)lc));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals(":DIRECT-TEMPLATE-SLOTS");
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.tree.isEditing()) {
            this.tree.cancelEditing();
        }
    }

    private void setHideGlobalCharacteristics(boolean value) {
        if (value != this.getHideGlobalCharacteristics()) {
            if (value) {
                this.getPropertyList().setBoolean(HIDE_GLOBAL_CHARACTERISTICS, true);
            } else {
                this.getPropertyList().remove(HIDE_GLOBAL_CHARACTERISTICS);
            }
            this.updateTreeDisplayRestrictions();
        }
    }

    public void setDisplayRestrictions(boolean value) {
        if (value != this.getDisplayRestrictions()) {
            if (value) {
                this.getPropertyList().setBoolean(DISPLAY_RESTRICTIONS, true);
            } else {
                this.getPropertyList().remove(DISPLAY_RESTRICTIONS);
            }
            this.updateTreeDisplayRestrictions();
        }
    }

    public void setInstance(Instance newInstance) {
        super.setInstance(newInstance);
        if (newInstance instanceof OWLNamedClass) {
            this.tree.setCls((OWLNamedClass)newInstance);
            this.tree.openNodesIfPossible();
            boolean thing = newInstance.equals(this.getOWLModel().getOWLThingClass());
            this.createDatatypePropertyAction.setEnabled(!thing);
            this.createObjectPropertyAction.setEnabled(!thing);
            this.createRDFPropertyAction.setEnabled(!thing);
            this.addPropertyAction.setEnabled(!thing);
            this.tree.getCreateRestrictionAction().setEnabled(!thing);
        } else {
            this.tree.setCls(null);
        }
    }

    private void updateTreeDisplayRestrictions() {
        this.tree.init(this.getDisplayRestrictions(), this.getHideGlobalCharacteristics());
    }

    protected void viewProperty(RDFProperty property) {
        property.getProject().show((Instance)property);
    }

    private class MyWidgetConfigurationPanel
    extends WidgetConfigurationPanel {
        private JCheckBox displayRestrictionsCheckBox;
        private JTextField labelTextField;

        MyWidgetConfigurationPanel() {
            super((SlotWidget)PropertyRestrictionsTreeWidget.this);
        }

        public void addGeneralTab(SlotWidget widget) {
            this.labelTextField = new JTextField(PropertyRestrictionsTreeWidget.this.getLabel());
            this.displayRestrictionsCheckBox = new JCheckBox("Display restrictions behind property name");
            this.displayRestrictionsCheckBox.setSelected(PropertyRestrictionsTreeWidget.this.getDisplayRestrictions());
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(this.displayRestrictionsCheckBox);
            panel.add((Component)new LabeledComponent(PropertyRestrictionsTreeWidget.LABEL, (Component)this.labelTextField));
            this.addTab("General", panel);
        }

        public void saveContents() {
            PropertyRestrictionsTreeWidget.this.getPropertyList().setString(PropertyRestrictionsTreeWidget.LABEL, this.labelTextField.getText());
            boolean selected = this.displayRestrictionsCheckBox.isSelected();
            PropertyRestrictionsTreeWidget.this.setDisplayRestrictions(selected);
            PropertyRestrictionsTreeWidget.this.updateTreeDisplayRestrictions();
        }
    }
}

