/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTable;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableCellHolder;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class AnnotationsValueEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JTextArea textArea;
    private AnnotationsTableCellHolder multiLineHolder;
    private JTextField textField;
    private AnnotationsTableCellHolder singleLineHolder;
    private JTextComponent textComponent;
    private JTable table;
    private Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    public static final int EDITING_MARGIN = 30;

    public AnnotationsValueEditor(OWLModel owlModel, JTable t) {
        this.table = t;
        this.textArea = new JTextArea();
        OWLUI.addCopyPastePopup(this.textArea);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        if (!e.isControlDown()) break;
                        AnnotationsValueEditor.this.stopCellEditing();
                        e.consume();
                        break;
                    }
                    case 27: {
                        AnnotationsValueEditor.this.cancelCellEditing();
                    }
                }
            }
        });
        this.textArea.setFocusable(true);
        JScrollPane sp = new JScrollPane(this.textArea);
        sp.setBorder(this.focusBorder);
        sp.setHorizontalScrollBarPolicy(31);
        this.multiLineHolder = new AnnotationsTableCellHolder(sp, "Center");
        this.textField = new JTextField();
        this.singleLineHolder = new AnnotationsTableCellHolder(this.textField, "Center");
    }

    public Object getCellEditorValue() {
        return this.textComponent.getText().trim();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        RDFProperty property = (RDFProperty)table.getValueAt(row, 0);
        if (AnnotationsTable.isMultiLineProperty(property)) {
            this.textArea.setText(value != null ? value.toString() : "");
            int rowHeight = this.getRowHeight(table, row);
            if (table.getRowHeight(row) != rowHeight) {
                table.setRowHeight(row, rowHeight);
            }
            this.textComponent = this.textArea;
            this.focusTextField();
            return this.multiLineHolder;
        }
        this.textField.setText(value != null ? value.toString() : "");
        this.textComponent = this.textField;
        this.focusTextField();
        return this.singleLineHolder;
    }

    private void focusTextField() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnnotationsValueEditor.this.textComponent.requestFocus();
            }
        });
    }

    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() == 2;
        }
        return super.isCellEditable(e);
    }

    private int getRowHeight(JTable table, int row) {
        int maxHeight;
        Object val = table.getValueAt(row, 1);
        if (val == null) {
            val = "";
        }
        int preferredHeight = 0;
        View v = this.textArea.getUI().getRootView(this.textArea);
        v.setSize(table.getColumnModel().getColumn(1).getWidth(), 2.1474836E9f);
        preferredHeight = (int)v.getPreferredSpan(1) + 30;
        JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, table);
        if (sp != null && preferredHeight > (maxHeight = sp.getViewport().getViewRect().height)) {
            preferredHeight = maxHeight;
        }
        return preferredHeight;
    }
}

