/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.conditions.AddClosureAxiomAction;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTable;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import java.awt.Component;

public class AddClosureAxiomTestCase
extends AbstractJenaTestCase {
    public void testAddClosureAxiomToPrimitiveClass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        ConditionsTableModel tableModel = new ConditionsTableModel(this.owlModel);
        ConditionsTable table = new ConditionsTable(this.owlModel, tableModel);
        tableModel.setCls(personCls);
        OWLNamedClass fatherCls = this.owlModel.createOWLNamedClass("Father");
        OWLNamedClass motherCls = this.owlModel.createOWLNamedClass("Mother");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasParent");
        OWLSomeValuesFrom fatherRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, fatherCls);
        OWLSomeValuesFrom motherRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, motherCls);
        personCls.addSuperclass(fatherRestriction);
        personCls.addSuperclass(motherRestriction);
        AddClosureAxiomAction action = new AddClosureAxiomAction();
        AddClosureAxiomTestCase.assertFalse((boolean)action.isSuitable((Component)((Object)table), personCls));
        AddClosureAxiomTestCase.assertFalse((boolean)action.isSuitable((Component)((Object)table), fatherCls));
        AddClosureAxiomTestCase.assertTrue((boolean)action.isSuitable((Component)((Object)table), fatherRestriction));
        AddClosureAxiomTestCase.assertTrue((boolean)action.isSuitable((Component)((Object)table), motherRestriction));
        action.initialize((Component)((Object)table), fatherRestriction);
        action.actionPerformed(null);
        AddClosureAxiomTestCase.assertEquals((int)4, (int)personCls.getSuperclassCount());
        OWLAllValuesFrom allRestriction = (OWLAllValuesFrom)this.owlModel.getCls("owl:AllValuesFromRestriction").getDirectInstances().iterator().next();
        AddClosureAxiomTestCase.assertContains((Object)allRestriction, personCls.getPureSuperclasses());
        AddClosureAxiomTestCase.assertEquals((Object)property, (Object)allRestriction.getOnProperty());
        OWLUnionClass filler = (OWLUnionClass)allRestriction.getFiller();
        AddClosureAxiomTestCase.assertContains((Object)fatherCls, filler.getOperands());
        AddClosureAxiomTestCase.assertContains((Object)motherCls, filler.getOperands());
        AddClosureAxiomTestCase.assertSize(2, filler.getOperands());
    }

    public void testAddClosureAxiomToSimpleDefinedClass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        ConditionsTableModel tableModel = new ConditionsTableModel(this.owlModel);
        ConditionsTable table = new ConditionsTable(this.owlModel, tableModel);
        tableModel.setCls(personCls);
        OWLNamedClass fatherCls = this.owlModel.createOWLNamedClass("Father");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasParent");
        OWLSomeValuesFrom fatherRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, fatherCls);
        personCls.setDefinition(fatherRestriction);
        AddClosureAxiomAction action = new AddClosureAxiomAction();
        AddClosureAxiomTestCase.assertFalse((boolean)action.isSuitable((Component)((Object)table), personCls));
        AddClosureAxiomTestCase.assertFalse((boolean)action.isSuitable((Component)((Object)table), fatherCls));
        AddClosureAxiomTestCase.assertTrue((boolean)action.isSuitable((Component)((Object)table), fatherRestriction));
        action.initialize((Component)((Object)table), fatherRestriction);
        action.actionPerformed(null);
        AddClosureAxiomTestCase.assertEquals((int)2, (int)personCls.getSuperclassCount());
        OWLIntersectionClass newIntersectionCls = (OWLIntersectionClass)personCls.getDefinition();
        AddClosureAxiomTestCase.assertEquals((String)"(hasParent some Father) and (hasParent only Father)", (String)newIntersectionCls.getBrowserText());
    }

    public void testAddClosureAxiomToComplexDefinedClass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        ConditionsTableModel tableModel = new ConditionsTableModel(this.owlModel);
        ConditionsTable table = new ConditionsTable(this.owlModel, tableModel);
        tableModel.setCls(personCls);
        OWLNamedClass fatherCls = this.owlModel.createOWLNamedClass("Father");
        OWLNamedClass motherCls = this.owlModel.createOWLNamedClass("Mother");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasParent");
        OWLSomeValuesFrom fatherRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, fatherCls);
        OWLSomeValuesFrom motherRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, motherCls);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(fatherRestriction);
        intersectionCls.addOperand(motherRestriction);
        personCls.setDefinition(intersectionCls);
        AddClosureAxiomAction action = new AddClosureAxiomAction();
        AddClosureAxiomTestCase.assertFalse((boolean)action.isSuitable((Component)((Object)table), personCls));
        AddClosureAxiomTestCase.assertFalse((boolean)action.isSuitable((Component)((Object)table), fatherCls));
        AddClosureAxiomTestCase.assertTrue((boolean)action.isSuitable((Component)((Object)table), fatherRestriction));
        AddClosureAxiomTestCase.assertTrue((boolean)action.isSuitable((Component)((Object)table), motherRestriction));
        action.initialize((Component)((Object)table), fatherRestriction);
        action.actionPerformed(null);
        AddClosureAxiomTestCase.assertEquals((int)2, (int)personCls.getSuperclassCount());
        OWLIntersectionClass newIntersectionCls = (OWLIntersectionClass)personCls.getDefinition();
        AddClosureAxiomTestCase.assertEquals((String)"(hasParent some Father) and (hasParent some Mother) and (hasParent only (Father or Mother))", (String)newIntersectionCls.getBrowserText());
    }
}

