/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions.tests;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.tests.AbstractConditionsTableTestCase;
import java.util.Collection;

public class AddRowTestCase
extends AbstractConditionsTableTestCase {
    public void testAddAtSuperclassSeparator() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        AddRowTestCase.assertTrue((boolean)tableModel.isSeparator(1));
        tableModel.addRow(animalCls, 1);
        AddRowTestCase.assertEquals((int)2, (int)personCls.getSuperclassCount());
        AddRowTestCase.assertEquals((int)0, (int)personCls.getEquivalentClasses().size());
        AddRowTestCase.assertTrue((boolean)personCls.isSubclassOf(animalCls));
        AddRowTestCase.assertTrue((boolean)personCls.isSubclassOf(this.owlThing));
        AddRowTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testAddAtSuperclass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        AddRowTestCase.assertEquals((Object)this.owlThing, (Object)tableModel.getClass(2));
        tableModel.addRow(animalCls, 2);
        AddRowTestCase.assertEquals((int)2, (int)personCls.getSuperclassCount());
        AddRowTestCase.assertEquals((int)0, (int)personCls.getEquivalentClasses().size());
        AddRowTestCase.assertTrue((boolean)personCls.isSubclassOf(animalCls));
        AddRowTestCase.assertTrue((boolean)personCls.isSubclassOf(this.owlThing));
        AddRowTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testAddSingleEquivalentClassAtSeparator() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        AddRowTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        tableModel.addRow(menschCls, 0);
        AddRowTestCase.assertEquals((int)2, (int)personCls.getSuperclassCount());
        AddRowTestCase.assertEquals((int)1, (int)personCls.getPureSuperclasses().size());
        AddRowTestCase.assertEquals((int)1, (int)personCls.getEquivalentClasses().size());
        AddRowTestCase.assertTrue((boolean)personCls.hasEquivalentClass(menschCls));
        AddRowTestCase.assertTrue((boolean)personCls.isSubclassOf(this.owlThing));
        AddRowTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testAddNamedEquivalentClassAtSeparator() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        personCls.addEquivalentClass(menschCls);
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        AddRowTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        int oldClsCount = this.owlModel.getClsCount();
        personCls.addEquivalentClass(otherCls);
        AddRowTestCase.assertEquals((int)oldClsCount, (int)this.owlModel.getClsCount());
        AddRowTestCase.assertEquals((int)3, (int)personCls.getSuperclassCount());
        AddRowTestCase.assertEquals((int)1, (int)personCls.getPureSuperclasses().size());
        AddRowTestCase.assertEquals((int)2, (int)personCls.getEquivalentClasses().size());
        AddRowTestCase.assertTrue((boolean)personCls.hasEquivalentClass(menschCls));
        AddRowTestCase.assertTrue((boolean)personCls.hasEquivalentClass(otherCls));
        AddRowTestCase.assertTrue((boolean)personCls.isSubclassOf(this.owlThing));
        AddRowTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testAddNamedEquivalentClassAtDefinition() {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass menschClass = this.owlModel.createOWLNamedClass("Mensch");
        personClass.addEquivalentClass(menschClass);
        ConditionsTableModel tableModel = this.getTableModel(personClass);
        tableModel.dumpItems();
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", menschClass, NECESSARY, this.owlThing});
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        AddRowTestCase.assertEquals((Object)menschClass, (Object)tableModel.getClass(1));
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.addRow(otherCls, 1);
        AddRowTestCase.assertEquals((int)(oldClsCount + 1), (int)this.owlModel.getClsCount());
        AddRowTestCase.assertSize(4, personClass.getSuperclasses(false));
        AddRowTestCase.assertSize(1, personClass.getPureSuperclasses());
        AddRowTestCase.assertTrue((boolean)personClass.getPureSuperclasses().contains(this.owlThing));
        AddRowTestCase.assertSize(1, personClass.getEquivalentClasses());
        AddRowTestCase.assertFalse((boolean)personClass.hasEquivalentClass(menschClass));
        OWLIntersectionClass definition = (OWLIntersectionClass)personClass.getEquivalentClasses().iterator().next();
        AddRowTestCase.assertTrue((boolean)definition.getOperands().contains(menschClass));
        AddRowTestCase.assertTrue((boolean)definition.getOperands().contains(otherCls));
        AddRowTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testAddAnonEquivalentClassAtDefinition() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        tableModel.addRow(menschCls, 0);
        tableModel.addRow(otherCls, 1);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", menschCls, otherCls, NECESSARY, this.owlThing});
        OWLObjectProperty childrenProperty = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(childrenProperty, 1);
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.addRow(restriction, 1);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", menschCls, otherCls, OWLMinCardinality.class, NECESSARY, this.owlThing});
        AddRowTestCase.assertEquals((int)oldClsCount, (int)this.owlModel.getClsCount());
        AddRowTestCase.assertSize(4, personCls.getSuperclasses(false));
        AddRowTestCase.assertSize(1, personCls.getPureSuperclasses());
        AddRowTestCase.assertTrue((boolean)personCls.isSubclassOf(this.owlThing));
        AddRowTestCase.assertSize(1, personCls.getEquivalentClasses());
        OWLIntersectionClass definition = (OWLIntersectionClass)personCls.getEquivalentClasses().iterator().next();
        Collection operands = definition.getOperands();
        AddRowTestCase.assertEquals((int)3, (int)operands.size());
        AddRowTestCase.assertTrue((boolean)operands.contains(menschCls));
        AddRowTestCase.assertTrue((boolean)operands.contains(otherCls));
        AddRowTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testAddAnonEquivalentClassAtSecondDefinition() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        tableModel.addRow(menschCls, 0);
        tableModel.addEmptyDefinitionBlock();
        tableModel.addRow(otherCls, 0);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", menschCls, "SUFFICIENT", otherCls, NECESSARY, this.owlThing});
        OWLObjectProperty childrenProperty = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(childrenProperty, 1);
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.addRow(restriction, 3);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", menschCls, "SUFFICIENT", otherCls, OWLMinCardinality.class, NECESSARY, this.owlThing});
        AddRowTestCase.assertEquals((int)(oldClsCount + 1), (int)this.owlModel.getClsCount());
        AddRowTestCase.assertEquals((int)4, (int)personCls.getSuperclassCount());
        AddRowTestCase.assertEquals((int)1, (int)personCls.getPureSuperclasses().size());
        AddRowTestCase.assertTrue((boolean)personCls.isSubclassOf(this.owlThing));
        AddRowTestCase.assertEquals((int)2, (int)personCls.getEquivalentClasses().size());
        AddRowTestCase.assertTrue((boolean)personCls.hasEquivalentClass(menschCls));
        AddRowTestCase.assertFalse((boolean)personCls.hasEquivalentClass(otherCls));
        OWLNAryLogicalClass definition = null;
        for (RDFSClass equivalentClass : personCls.getEquivalentClasses()) {
            if (!(equivalentClass instanceof OWLIntersectionClass)) continue;
            definition = (OWLIntersectionClass)equivalentClass;
        }
        AddRowTestCase.assertEquals((int)2, (int)definition.getOperands().size());
        AddRowTestCase.assertTrue((boolean)definition.getOperands().contains(otherCls));
        AddRowTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testAddDuplicateNamedClass() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        personCls.addSuperclass(animalCls);
        personCls.removeSuperclass(this.owlThing);
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        tableModel.addRow(animalCls, 0);
        AddRowTestCase.assertEquals((int)1, (int)personCls.getSuperclassCount());
    }

    public void testAddDuplicateAnonClass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Parent");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        tableModel.addRow(this.owlModel.createOWLMinCardinality(property, 1), 0);
        tableModel.addEmptyDefinitionBlock();
        tableModel.addRow(this.owlModel.createOWLMinCardinality(property, 1), 0);
        AddRowTestCase.assertEquals((int)3, (int)personCls.getSuperclassCount());
        AddRowTestCase.assertEquals((int)6, (int)tableModel.getRowCount());
    }

    public void testAddDuplicateOperand() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Parent");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing});
        personCls.addEquivalentClass(animalCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", animalCls, NECESSARY, this.owlThing});
        AddRowTestCase.assertContains((Object)animalCls, personCls.getPropertyValues(this.owlModel.getOWLEquivalentClassProperty()));
        tableModel.addRow(this.owlModel.createOWLMinCardinality(property, 1), 1);
        AddRowTestCase.assertTrue((boolean)(personCls.getDefinition() instanceof OWLIntersectionClass));
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", animalCls, OWLMinCardinality.class, NECESSARY, this.owlThing});
        tableModel.addRow(this.owlModel.createOWLMinCardinality(property, 1), 1);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", animalCls, OWLMinCardinality.class, NECESSARY, this.owlThing});
        AddRowTestCase.assertSize(3, personCls.getSuperclasses(false));
        OWLIntersectionClass intersectionCls = (OWLIntersectionClass)personCls.getDefinition();
        AddRowTestCase.assertSize(2, intersectionCls.getOperands());
    }

    public void testAddInherited() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Person", animalCls);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        animalCls.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1));
        ConditionsTableModel tableModel = this.getTableModel(cls);
        int i = 0;
        AddRowTestCase.assertTrue((boolean)tableModel.isSeparator(i++));
        AddRowTestCase.assertTrue((boolean)tableModel.isSeparator(i++));
        AddRowTestCase.assertEquals((Object)animalCls, (Object)tableModel.getClass(i++));
        AddRowTestCase.assertTrue((boolean)tableModel.isSeparator(i++));
        AddRowTestCase.assertTrue((boolean)(tableModel.getClass(i++) instanceof OWLMinCardinality));
        AddRowTestCase.assertEquals((int)i, (int)tableModel.getRowCount());
        OWLMinCardinality newRestriction = this.owlModel.createOWLMinCardinality(property, 1);
        AddRowTestCase.assertTrue((boolean)tableModel.addRow(newRestriction, 2));
        AddRowTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
    }

    public void testDisallowEquivalentToThing() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        ConditionsTableModel tableModel = this.getTableModel(cls);
        AddRowTestCase.assertFalse((boolean)tableModel.addRowAllowMove(this.owlThing, 0));
        AddRowTestCase.assertEquals((int)0, (int)this.events.size());
    }

    public void testAddIntersectionCls() {
        OWLNamedClass testCls = this.owlModel.createOWLNamedClass("Parent");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(this.owlModel.createOWLObjectProperty("children"), 1);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(personCls);
        intersectionCls.addOperand(restriction);
        ConditionsTableModel tableModel = this.getTableModel(testCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing});
        tableModel.addRow(intersectionCls, 1);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing, intersectionCls});
    }
}

