/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.ClassNameTreeCellEditor;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.search.ClassTreeFinder;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class SelectClassPanel
extends SelectableContainer {
    private final ClassTree tree;
    private final OWLModel owlModel;
    private final Collection defaultRoots;
    private static final String SHOW_ALL = "Show all classes";
    private static final String SHOW_LIMITED = "Show sensible classes";

    public SelectClassPanel(OWLModel owlModel, Collection rootClses, boolean multiple, boolean editable) {
        this.owlModel = owlModel;
        this.defaultRoots = rootClses;
        this.tree = new ClassTree(null, (LazyTreeRoot)new ParentChildRoot(rootClses));
        this.setSelectable(this.tree);
        this.tree.setSelectionRow(0);
        this.tree.setLargeModel(true);
        this.tree.setAutoscrolls(true);
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer((TreeCellRenderer)ResourceRenderer.createInstance());
        if (multiple) {
            this.tree.getSelectionModel().setSelectionMode(2);
        } else {
            this.tree.getSelectionModel().setSelectionMode(1);
        }
        LabeledComponent lc = new LabeledComponent(null, new JScrollPane((Component)((Object)this.tree)));
        lc.setPreferredSize(new Dimension(400, 300));
        if (!rootClses.contains(owlModel.getOWLThingClass())) {
            lc.addHeaderToggleButton((Action)new AbstractAction(SHOW_ALL, OWLIcons.getImageIcon("Top")){
                boolean showingAll;
                {
                    this.showingAll = false;
                }

                public void actionPerformed(ActionEvent e) {
                    ParentChildRoot newRoot = null;
                    JToggleButton b = (JToggleButton)e.getSource();
                    if (this.showingAll) {
                        newRoot = new ParentChildRoot(SelectClassPanel.this.defaultRoots);
                        b.setToolTipText(SelectClassPanel.SHOW_ALL);
                    } else {
                        OWLNamedClass owlThing = SelectClassPanel.this.owlModel.getOWLThingClass();
                        Collection clses = Collections.singleton(owlThing);
                        newRoot = new ParentChildRoot(clses);
                        b.setToolTipText(SelectClassPanel.SHOW_LIMITED);
                    }
                    SelectClassPanel.this.tree.setRoot((LazyTreeRoot)newRoot);
                    SelectClassPanel.this.tree.setSelectionRow(0);
                    this.showingAll = !this.showingAll;
                }
            });
            if (editable) {
                lc.addHeaderSeparator();
            }
        }
        if (editable) {
            this.tree.setCellEditor(new ClassNameTreeCellEditor());
            this.tree.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    SelectClassPanel.this.tree.stopEditing();
                }
            });
            lc.addHeaderButton((Action)((Object)new CreateSubclassAction(this.tree)));
            lc.addHeaderButton((Action)((Object)new CreateSiblingClassAction(this.tree)));
        }
        ClassTreeFinder finder = new ClassTreeFinder(owlModel, (JTree)((Object)this.tree));
        lc.add("South", (Component)((Object)finder));
        this.add((Component)lc);
    }

    public Selectable getSelectable() {
        return this.tree;
    }

    public Collection getSelection() {
        return this.tree.getSelection();
    }

    class CreateSubclassAction
    extends AllowableAction {
        public CreateSubclassAction(ClassTree selectableTree) {
            super("Create Subclass", OWLIcons.getCreateIcon("SubClass"), (Selectable)selectableTree);
            this.onSelectionChange();
        }

        public void actionPerformed(ActionEvent e) {
            OWLNamedClass superclass = (OWLNamedClass)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            OWLModel owlModel = superclass.getOWLModel();
            owlModel.beginTransaction("Create subclass of class " + superclass.getBrowserText());
            String name = owlModel.createNewResourceName("Class");
            RDFSClass superclassType = superclass.getRDFType();
            if (superclassType == null) {
                superclassType = superclass.getProtegeType();
            }
            RDFSNamedClass cls = owlModel.createRDFSNamedClass(name, Collections.singleton(superclass), superclassType);
            ClassTree tree = (ClassTree)this.getSelectable();
            OWLUI.selectResource(cls, tree);
            int row = tree.getSelectionRows()[0];
            tree.setEditable(true);
            tree.startEditingAtPath(tree.getPathForRow(row));
            owlModel.endTransaction();
        }

        public void onSelectionChange() {
            OWLNamedClass superclass = (OWLNamedClass)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            this.setAllowed(superclass instanceof RDFSNamedClass);
        }
    }

    class CreateSiblingClassAction
    extends AllowableAction {
        public CreateSiblingClassAction(ClassTree selectableTree) {
            super("Create Sibling Class", OWLIcons.getCreateIcon("SiblingClass"), (Selectable)selectableTree);
            this.onSelectionChange();
        }

        public void actionPerformed(ActionEvent e) {
            OWLNamedClass sibling = (OWLNamedClass)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            Collection parents = sibling.getNamedSuperclasses();
            if (!parents.isEmpty()) {
                RDFSNamedClass cls;
                OWLModel owlModel = sibling.getOWLModel();
                owlModel.beginTransaction("Create sibling of class " + sibling.getBrowserText());
                String name = owlModel.createNewResourceName("Class");
                RDFSClass siblingType = sibling.getRDFType();
                if (siblingType == null) {
                    siblingType = sibling.getProtegeType();
                }
                if ((cls = owlModel.createRDFSNamedClass(name, parents, siblingType)) instanceof OWLNamedClass) {
                    for (RDFSNamedClass s : parents) {
                        ((OWLNamedClass)cls).addInferredSuperclass(s);
                    }
                }
                ClassTree tree = (ClassTree)this.getSelectable();
                OWLUI.selectResource(cls, tree);
                int row = tree.getSelectionRows()[0];
                tree.setEditable(true);
                tree.startEditingAtPath(tree.getPathForRow(row));
                owlModel.endTransaction();
            }
        }

        public void onSelectionChange() {
            OWLNamedClass siblingclass = (OWLNamedClass)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            ClassTree tree = (ClassTree)this.getSelectable();
            LazyTreeRoot root = (LazyTreeRoot)tree.getModel().getRoot();
            Collection roots = (Collection)root.getUserObject();
            this.setAllowed(siblingclass instanceof RDFSNamedClass && !roots.contains(siblingclass));
        }
    }
}

