/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreeNode;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class EditableExistentialTreePanel
extends ExistentialTreePanel {
    private AllowableAction addClassAction = new AllowableAction("Add class", OWLIcons.getAddIcon("PrimitiveClass"), this){

        public void actionPerformed(ActionEvent e) {
            EditableExistentialTreePanel.this.addClass();
        }

        public void onSelectionChange() {
            OWLClass sel = EditableExistentialTreePanel.this.getSelectedOWLClass();
            this.setAllowed(sel != null && sel.isEditable());
        }
    };
    private AllowableAction createClsAction = new AllowableAction("Create class", OWLIcons.getCreateIcon("PrimitiveClass"), this){

        public void actionPerformed(ActionEvent e) {
            EditableExistentialTreePanel.this.createClass();
        }

        public void onSelectionChange() {
            OWLClass sel = EditableExistentialTreePanel.this.getSelectedOWLClass();
            this.setAllowed(sel != null && sel.isEditable());
        }
    };
    private AllowableAction deleteClsAction = new AllowableAction("Delete class", OWLIcons.getDeleteIcon("PrimitiveClass"), this){

        public void actionPerformed(ActionEvent e) {
            EditableExistentialTreePanel.this.deleteCls();
        }

        public void onSelectionChange() {
            OWLClass parent = EditableExistentialTreePanel.this.getSelectedParentClass();
            OWLClass sel = EditableExistentialTreePanel.this.getSelectedOWLClass();
            this.setAllowed(parent != null && parent.isEditable() && sel != null && sel.isEditable());
        }
    };
    private Action removeClsAction = new AllowableAction("Remove class", OWLIcons.getRemoveIcon("PrimitiveClass"), this){

        public void actionPerformed(ActionEvent e) {
            EditableExistentialTreePanel.this.removeCls();
        }

        public void onSelectionChange() {
            OWLClass sel = EditableExistentialTreePanel.this.getSelectedParentClass();
            this.setAllowed(sel != null);
        }
    };

    public EditableExistentialTreePanel(RDFSNamedClass root, Slot superclassesSlot, OWLObjectProperty transitiveSlot) {
        super(root, superclassesSlot, transitiveSlot);
        this.getLabeledComponent().addHeaderButton((Action)this.createClsAction);
        this.getLabeledComponent().addHeaderButton((Action)this.addClassAction);
        this.getLabeledComponent().addHeaderButton(this.removeClsAction);
        this.getLabeledComponent().addHeaderButton((Action)this.deleteClsAction);
        this.createClsAction.setAllowed(true);
        this.addClassAction.setAllowed(true);
    }

    private void addClass() {
        RDFSNamedClass cls;
        OWLModel owlModel = this.getOWLModel();
        OWLObjectProperty property = this.getExistentialProperty();
        Collection cs = property.getUnionRangeClasses();
        if (cs.size() == 0) {
            cs = Collections.singleton(owlModel.getOWLThingClass());
        }
        if ((cls = ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this), owlModel, cs, "Select a class to add")) instanceof OWLNamedClass) {
            OWLClass selCls = this.getSelectedOWLClass();
            try {
                try {
                    owlModel.beginTransaction("Add existential relationship " + this.getExistentialProperty().getBrowserText() + " between " + selCls.getBrowserText() + " and " + cls.getBrowserText());
                    selCls.addSuperclass(owlModel.createOWLSomeValuesFrom((RDFProperty)this.getExistentialProperty(), (OWLNamedClass)cls));
                }
                catch (Exception ex) {
                    OWLUI.handleError(owlModel, ex);
                }
            }
            finally {
                owlModel.endTransaction();
            }
            this.selectChildNode(cls);
        }
    }

    private void createClass() {
        OWLModel owlModel = this.getOWLModel();
        OWLClass selCls = this.getSelectedOWLClass();
        OWLNamedClass newCls = owlModel.createOWLNamedClass(null);
        newCls.removeSuperclass(owlModel.getOWLThingClass());
        for (RDFSClass superCls : selCls.getSuperclasses(false)) {
            if (!(superCls instanceof OWLNamedClass)) continue;
            newCls.addSuperclass(superCls);
        }
        selCls.addSuperclass(owlModel.createOWLSomeValuesFrom((RDFProperty)this.getExistentialProperty(), newCls));
        this.selectChildNode(newCls);
    }

    private void deleteCls() {
        OWLClass cls = this.getSelectedOWLClass();
        cls.delete();
    }

    private void removeCls() {
        OWLClass cls = this.getSelectedOWLClass();
        OWLClass parentCls = this.getSelectedParentClass();
        System.err.println("The remove mothod has temporarily been disabled.");
    }

    private void selectChildNode(RDFSClass cls) {
        JTree tree = this.getTree();
        ExistentialTreeNode node = this.getSelectedNode();
        if (node != null) {
            ExistentialTreeNode newNode = null;
            int i = 0;
            while (i < node.getChildObjectCount()) {
                newNode = (ExistentialTreeNode)((Object)node.getChildAt(i));
                if (cls.equals(newNode.getOWLClass())) break;
                ++i;
            }
            TreePath path = tree.getSelectionPath();
            TreePath newPath = path.pathByAddingChild((Object)newNode);
            tree.setSelectionPath(newPath);
        }
    }
}

