/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public class ExistentialAction
extends ResourceSelectionAction {
    private OWLNamedClass cls;
    private Component component;
    private HierarchyManager hierarchyManager;

    public ExistentialAction(Component component, HierarchyManager hierarchyManager, OWLNamedClass cls) {
        super("Explore existential relationships...", OWLIcons.getImageIcon("Transitivity"));
        this.cls = cls;
        this.component = component;
        this.hierarchyManager = hierarchyManager;
    }

    public void resourceSelected(RDFResource resource) {
        if (resource instanceof OWLObjectProperty) {
            OWLObjectProperty property = (OWLObjectProperty)resource;
            ExistentialTreePanel tp = new ExistentialTreePanel(this.cls, this.cls.getOWLModel().getSlot(":DIRECT-SUPERCLASSES"), property);
            this.hierarchyManager.addHierarchy(tp);
        }
    }

    public Collection getSelectableResources() {
        OWLModel owlModel = this.cls.getOWLModel();
        ArrayList properties = new ArrayList(owlModel.getVisibleUserDefinedOWLProperties());
        ArrayList<OWLProperty> list = new ArrayList<OWLProperty>();
        for (OWLProperty property : properties) {
            if (!(property instanceof OWLObjectProperty)) continue;
            list.add(property);
        }
        return list;
    }

    public RDFResource pickResource() {
        Collection list = this.getSelectableResources();
        return (OWLObjectProperty)ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(this.component, this.cls.getOWLModel(), list, "Select a property to explore");
    }

    public void setCls(OWLNamedClass cls) {
        this.cls = cls;
    }
}

