/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu;

import edu.stanford.smi.protege.action.ArchiveProject;
import edu.stanford.smi.protege.action.Copy;
import edu.stanford.smi.protege.action.CreateProject;
import edu.stanford.smi.protege.action.Cut;
import edu.stanford.smi.protege.action.OpenProject;
import edu.stanford.smi.protege.action.Paste;
import edu.stanford.smi.protege.action.RedoAction;
import edu.stanford.smi.protege.action.RevertProject;
import edu.stanford.smi.protege.action.SaveProject;
import edu.stanford.smi.protege.action.UndoAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.ProjectPluginAdapter;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.ProjectMenuBar;
import edu.stanford.smi.protege.ui.ProjectToolBar;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.javacode.JavaCodeGeneratorResourceAction;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.model.util.XSDVisibility;
import edu.stanford.smi.protegex.owl.resource.OWLText;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.actions.OWLModelAction;
import edu.stanford.smi.protegex.owl.ui.actions.OWLModelActionManager;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsGenerator;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsLoader;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.menu.OWLBackwardsCompatibilityProjectFixups;
import edu.stanford.smi.protegex.owl.ui.menu.OWLModelActionAction;
import edu.stanford.smi.protegex.owl.ui.menu.SyntaxHelpAction;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryManager;
import edu.stanford.smi.protegex.owl.ui.navigation.TabNavigationHistorySelectable;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassesPanel;
import edu.stanford.smi.protegex.owl.ui.tooltips.ClassDescriptionToolTipGenerator;
import edu.stanford.smi.protegex.owl.ui.tooltips.HomeOntologyToolTipGenerator;
import edu.stanford.smi.protegex.owl.ui.triplestore.TripleStoreSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class OWLMenuProjectPlugin
extends ProjectPluginAdapter {
    private static final String CHANGED_WIDGETS = "ChangedWidgets";
    private static JCheckBoxMenuItem proseBox;
    private OWLModelAction recentAction = null;
    private SyntaxHelpAction syntaxHelpAction = new SyntaxHelpAction();
    private TripleStoreSelectionAction tripleStoreSelectionAction;
    public static final String MENU_NAME;
    public static final String PROSE_PROPERTY = "OWL-Prose";

    static {
        MENU_NAME = AbstractOWLModelAction.OWL_MENU;
    }

    private void addToolBarButton(JToolBar toolBar, Action action) {
        ComponentFactory.addToolBarButton((JToolBar)toolBar, (Action)action);
    }

    private void addToolBarButton(JToolBar toolBar, Action action, Icon icon) {
        action.putValue("SmallIcon", icon);
        action.putValue("DisabledSmallIcon", null);
        this.addToolBarButton(toolBar, action);
    }

    private void adjustMenuAndToolBar(final OWLModel owlModel, final ProjectMenuBar menuBar, final ProjectToolBar toolBar) {
        JMenu owlMenu = new JMenu(AbstractOWLModelAction.OWL_MENU);
        owlMenu.setMnemonic(79);
        JMenu codeMenu = new JMenu(AbstractOWLModelAction.CODE_MENU);
        codeMenu.setMnemonic(67);
        JMenu toolsMenu = new JMenu(AbstractOWLModelAction.TOOLS_MENU);
        toolsMenu.setMnemonic(84);
        JMenu helpMenu = menuBar.getMenu(menuBar.getMenuCount() - 1);
        helpMenu.addSeparator();
        helpMenu.add(new AbstractAction("Protege-OWL Tutorial..."){

            public void actionPerformed(ActionEvent e) {
                SystemUtilities.showHTML((String)"http://www.co-ode.org/resources/tutorials/");
            }
        });
        helpMenu.add(this.syntaxHelpAction);
        proseBox = new JCheckBoxMenuItem("Display prose as tool tip of OWL expressions", true);
        helpMenu.add(proseBox);
        proseBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                owlModel.getOWLProject().getSettingsMap().setBoolean(OWLMenuProjectPlugin.PROSE_PROPERTY, proseBox.isSelected());
                if (proseBox.isSelected()) {
                    OWLUI.setOWLToolTipGenerator(new ClassDescriptionToolTipGenerator());
                } else {
                    OWLUI.setOWLToolTipGenerator(new HomeOntologyToolTipGenerator());
                }
            }
        });
        proseBox.setSelected(Boolean.TRUE.equals(owlModel.getOWLProject().getSettingsMap().getBoolean(PROSE_PROPERTY)));
        if (proseBox.isSelected()) {
            OWLUI.setOWLToolTipGenerator(new ClassDescriptionToolTipGenerator());
        } else {
            OWLUI.setOWLToolTipGenerator(new HomeOntologyToolTipGenerator());
        }
        menuBar.add((Component)owlMenu, 3);
        menuBar.add((Component)codeMenu, 4);
        menuBar.add((Component)toolsMenu, 5);
        this.disableProjectMenuItem(menuBar, ResourceKey.PROJECT_MANAGE_INCLUDED);
        this.disableProjectMenuItem(menuBar, ResourceKey.PROJECT_CHANGE_INCLUDED);
        this.disableProjectMenuItem(menuBar, ResourceKey.PROJECT_MERGE_INCLUDED);
        this.disableProjectMenuItem(menuBar, ResourceKey.PROJECT_SHOW_INCLUDED);
        this.disableProjectMenuItem(menuBar, ResourceKey.PROJECT_INCLUDE);
        this.disableHelpMenuItem(menuBar, ResourceKey.HELP_MENU_ONTOLOGIES_101);
        this.disableHelpMenuItem(menuBar, ResourceKey.HELP_MENU_PLUGINS);
        this.disableHelpMenuItem(menuBar, ResourceKey.HELP_MENU_ICONS);
        this.disableHelpMenuItem(menuBar, ResourceKey.HELP_MENU_FAQ);
        this.disableHelpMenuItem(menuBar, ResourceKey.HELP_MENU_GETTING_STARTED);
        this.disableHelpMenuItem(menuBar, ResourceKey.HELP_MENU_USERS_GUIDE);
        helpMenu.remove(0);
        this.disableMenuItem(menuBar, ResourceKey.MENUBAR_PROJECT, ResourceKey.PROJECT_METRICS, false);
        this.adjustToolBar((JToolBar)toolBar);
        this.recentAction = null;
        OWLModelActionManager.addOWLModelActionsToMenubar(owlModel, new OWLModelActionManager.Adder(){

            public void addOWLModelAction(OWLModelAction action) {
                OWLMenuProjectPlugin.this.addOWLModelActionToMenuBar(action, owlModel, menuBar);
            }
        });
        this.recentAction = null;
        OWLModelActionManager.addOWLModelActionsToToolbar(owlModel, new OWLModelActionManager.Adder(){

            public void addOWLModelAction(OWLModelAction action) {
                OWLMenuProjectPlugin.this.addOWLModelActionToToolBar(action, owlModel, toolBar);
            }
        });
        toolBar.addSeparator();
        TabNavigationHistorySelectable selectable = new TabNavigationHistorySelectable(owlModel);
        NavigationHistoryManager manager = new NavigationHistoryManager(selectable, owlModel);
        manager.add(owlModel.getOWLThingClass());
        toolBar.add((Action)manager.getBackAction());
        toolBar.add((Action)manager.getForwardAction());
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            JMenuItem item;
            JMenu menu = menuBar.getMenu(i);
            if (menu.getItemCount() > 0 && (item = menu.getItem(0)) == null) {
                menu.remove(0);
            }
            ++i;
        }
    }

    private void addOWLModelActionToMenuBar(OWLModelAction action, OWLModel owlModel, ProjectMenuBar menuBar) {
        Action a;
        StringTokenizer tokenizer = new StringTokenizer(action.getMenubarPath(), "/", false);
        if (tokenizer.hasMoreElements() && (a = this.createAction(action, owlModel)) != null) {
            String menuName = tokenizer.nextToken();
            JMenu menu = null;
            int i = 0;
            while (i < menuBar.getMenuCount()) {
                if (menuName.equals(menuBar.getMenu(i).getText())) {
                    menu = menuBar.getMenu(i);
                }
                ++i;
            }
            if (menu == null) {
                menu = new JMenu(menuName);
                menuBar.add((Component)menu, menuBar.getMenuCount() - 1);
            } else if (this.recentAction != null && !this.recentAction.getMenubarPath().equals(action.getMenubarPath())) {
                menu.addSeparator();
            }
            menu.add(a);
        }
        this.recentAction = action;
    }

    private void addOWLModelActionToToolBar(OWLModelAction action, OWLModel owlModel, ProjectToolBar toolBar) {
        Action a = this.createAction(action, owlModel);
        if (a != null) {
            if (this.recentAction != null && !this.recentAction.getToolbarPath().equals(action.getToolbarPath())) {
                toolBar.addSeparator();
            }
            this.addToolBarButton((JToolBar)toolBar, a);
        }
        this.recentAction = action;
    }

    private void adjustToolBar(JToolBar toolBar) {
        toolBar.removeAll();
        this.addToolBarButton(toolBar, (Action)new CreateProject(true), OWLIcons.getImageIcon("File"));
        this.addToolBarButton(toolBar, (Action)new OpenProject(true), OWLIcons.getOpenProjectIcon());
        this.addToolBarButton(toolBar, (Action)new SaveProject(true), OWLIcons.getSaveProjectIcon());
        toolBar.addSeparator();
        this.addToolBarButton(toolBar, (Action)new Cut(true), OWLIcons.getCutIcon());
        this.addToolBarButton(toolBar, (Action)new Copy(true), OWLIcons.getCopyIcon());
        this.addToolBarButton(toolBar, (Action)new Paste(true), OWLIcons.getPasteIcon());
        toolBar.addSeparator();
        this.addToolBarButton(toolBar, (Action)new ArchiveProject(true), OWLIcons.getArchiveProjectIcon());
        this.addToolBarButton(toolBar, (Action)new RevertProject(true), OWLIcons.getRevertProjectIcon());
        toolBar.addSeparator();
        this.addToolBarButton(toolBar, (Action)new UndoAction(true), OWLIcons.getUndoIcon());
        this.addToolBarButton(toolBar, (Action)new RedoAction(true), OWLIcons.getRedoIcon());
        toolBar.addSeparator();
    }

    public void afterCreate(Project p) {
        OWLModel owlModel;
        KnowledgeBase kb = p.getKnowledgeBase();
        if (kb instanceof OWLModel && (owlModel = (OWLModel)kb) instanceof OWLDatabaseModel) {
            ((OWLDatabaseModel)p.getKnowledgeBase()).initDefaultNamespaces();
        }
    }

    public void afterLoad(Project project) {
        KnowledgeBase kb = project.getKnowledgeBase();
        if (kb instanceof OWLModel) {
            OWLModel owlModel = (OWLModel)kb;
            owlModel.getNamespaceManager().update();
            OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(owlModel);
            project.setWidgetMapper((WidgetMapper)new OWLWidgetMapper(owlModel));
            Integer build = owlModel.getOWLProject().getSettingsMap().getInteger("owl_build");
            if (build == null) {
                this.fix(owlModel);
            } else if (build < OWLText.getLatestCompatibleBuild()) {
                this.fix(owlModel);
            }
            if (project.getSources().getString(AbsoluteFormsGenerator.SAVE_FORMS_KEY) != null) {
                try {
                    AbsoluteFormsLoader absoluteFormsLoader = new AbsoluteFormsLoader(owlModel);
                    absoluteFormsLoader.loadAll();
                }
                catch (Exception ex) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                }
            }
        }
    }

    public void afterSave(Project p) {
        if (p.getKnowledgeBase() instanceof OWLModel) {
            OWLModel owlModel = (OWLModel)p.getKnowledgeBase();
            OWLMenuProjectPlugin.restoreWidgetsAfterSave(owlModel);
        }
    }

    public void afterShow(ProjectView view, ProjectToolBar toolBar, ProjectMenuBar menuBar) {
        KnowledgeBase kb = view.getProject().getKnowledgeBase();
        if (kb instanceof OWLModel) {
            OWLModel owlModel = (OWLModel)kb;
            ProtegeUI.register(view);
            if (owlModel instanceof JenaOWLModel) {
                JenaOWLModel.inUI = true;
            }
            owlModel.getProject().setInstanceDisplayClass(ResourceDisplay.class);
            this.adjustMenuAndToolBar(owlModel, menuBar, toolBar);
            ResourceActionManager.addResourceActionClass(JavaCodeGeneratorResourceAction.class);
            int buildNumber = Integer.parseInt(Text.getBuildNumber());
            if (buildNumber < OWLText.getRequiresProtegeBuild()) {
                ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "Warning: This version of the OWL Plugin requires Protege 3.2 beta build " + OWLText.getRequiresProtegeBuild() + ",\nbut you currently have Protege " + Text.getVersion() + ", Build " + buildNumber + ". Please do a clean reinstall.");
            }
        }
    }

    public void beforeClose(Project p) {
        if (p.getKnowledgeBase() instanceof OWLModel) {
            ProjectView view = ProtegeUI.getProjectView(p);
            if (view != null) {
                ProtegeUI.unregister(view);
            }
            ChangedClassesPanel.dispose((OWLModel)p.getKnowledgeBase());
        }
    }

    public void beforeSave(Project p) {
        OWLModel owlModel;
        String value;
        if (p.getKnowledgeBase() instanceof OWLModel && (value = (owlModel = (OWLModel)p.getKnowledgeBase()).getOWLProject().getSettingsMap().getString(AbsoluteFormsGenerator.SAVE_FORMS_KEY)) != null) {
            AbsoluteFormsGenerator generator = new AbsoluteFormsGenerator(owlModel);
            try {
                generator.generateFiles(value);
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                System.err.println("Warning: Could not save .forms files");
            }
            if (AbsoluteFormsLoader.useNewFormMechanism_DontUseThisMethod()) {
                OWLMenuProjectPlugin.prepareWidgetsForSave(owlModel);
            }
        }
    }

    private Action createAction(OWLModelAction owlModelAction, OWLModel owlModel) {
        return new OWLModelActionAction(owlModelAction, owlModel);
    }

    private void disableHelpMenuItem(ProjectMenuBar menuBar, ResourceKey resourceKey) {
        this.disableMenuItem(menuBar, ResourceKey.MENUBAR_HELP, resourceKey, false);
    }

    private void disableProjectMenuItem(ProjectMenuBar menuBar, ResourceKey resourceKey) {
        this.disableMenuItem(menuBar, ResourceKey.MENUBAR_PROJECT, resourceKey, true);
    }

    private void disableMenuItem(ProjectMenuBar menuBar, ResourceKey menuKey, ResourceKey resourceKey, boolean removeTrailingSeparator) {
        String menuName = LocalizedText.getText((ResourceKey)menuKey);
        String itemName = LocalizedText.getText((ResourceKey)resourceKey);
        JMenu projectMenu = menuBar.getMenu(0);
        int i = 1;
        while (!projectMenu.getText().equals(menuName)) {
            projectMenu = menuBar.getMenu(i);
            ++i;
        }
        i = 0;
        while (i < projectMenu.getItemCount()) {
            JMenuItem item = projectMenu.getItem(i);
            if (item != null && itemName.equals(item.getText())) {
                projectMenu.remove(item);
                if (removeTrailingSeparator && projectMenu.getItem(i) == null) {
                    projectMenu.remove(i);
                }
            }
            ++i;
        }
    }

    private void fix(OWLModel owlModel) {
        if (!owlModel.getProject().isMultiUserClient()) {
            OWLBackwardsCompatibilityProjectFixups.fix(owlModel);
            XSDVisibility.updateVisibility(owlModel);
        }
    }

    public static boolean isProseActivated() {
        return proseBox != null && proseBox.isSelected();
    }

    private static boolean isUsedInRange(Cls cls, Set systemFrames) {
        OWLModel owlModel = (OWLModel)cls.getKnowledgeBase();
        if (owlModel instanceof JenaOWLModel) {
            Collection refs = owlModel.getReferences(cls, 1000);
            Slot rangeSlot = owlModel.getSlot(":SLOT-VALUE-TYPE");
            for (Reference reference : refs) {
                Frame frame = reference.getFrame();
                if (!reference.getSlot().equals(rangeSlot) || systemFrames.contains(frame) || frame.getName().startsWith("protege:")) continue;
                return true;
            }
        }
        return false;
    }

    public static void makeHiddenClsesWithSubclassesVisible(OWLModel owlModel) {
        if (owlModel.getOWLNamedClassClass().getSubclassCount() > 0 || owlModel.getRDFSNamedClassClass().getSubclassCount() > 2) {
            owlModel.getRDFSNamedClassClass().setVisible(true);
            owlModel.getOWLNamedClassClass().setVisible(true);
        }
        HashSet systemFrames = new HashSet(owlModel.getOWLSystemResources());
        if (owlModel.getOWLObjectPropertyClass().getSubclassCount() > 0 || owlModel.getOWLDatatypePropertyClass().getSubclassCount() > 0 || OWLMenuProjectPlugin.isUsedInRange(owlModel.getOWLObjectPropertyClass(), systemFrames) || OWLMenuProjectPlugin.isUsedInRange(owlModel.getOWLDatatypePropertyClass(), systemFrames) || OWLMenuProjectPlugin.isUsedInRange(owlModel.getRDFPropertyClass(), systemFrames)) {
            owlModel.getRDFPropertyClass().setVisible(true);
            owlModel.getOWLObjectPropertyClass().setVisible(true);
            owlModel.getOWLDatatypePropertyClass().setVisible(true);
        }
        OWLMenuProjectPlugin.makeVisibleIfSubclassesExist(owlModel.getRDFListClass(), systemFrames);
        OWLMenuProjectPlugin.makeVisibleIfSubclassesExist(owlModel.getOWLDataRangeClass(), systemFrames);
        OWLMenuProjectPlugin.makeVisibleIfSubclassesExist(owlModel.getRDFSNamedClass("rdfs:Literal"), systemFrames);
        OWLMenuProjectPlugin.makeVisibleIfSubclassesExist(owlModel.getOWLNothing(), systemFrames);
        OWLMenuProjectPlugin.makeVisibleIfSubclassesExist(owlModel.getRDFSNamedClass("rdf:Statement"), systemFrames);
    }

    private static void makeVisibleIfSubclassesExist(Cls cls, Set systemFrames) {
        if (cls.getDirectSubclassCount() > 0 || OWLMenuProjectPlugin.isUsedInRange(cls, systemFrames)) {
            cls.setVisible(true);
        }
    }

    public static void prepareWidgetsForSave(OWLModel owlModel) {
        Project p = owlModel.getProject();
        ArrayList<WidgetDescriptor> widgets = new ArrayList<WidgetDescriptor>();
        for (Cls cls : p.getClsesWithCustomizedForms()) {
            WidgetDescriptor d;
            if (cls.isSystem() || (d = p.getDesignTimeClsWidget(cls).getDescriptor()).isIncluded()) continue;
            widgets.add(d);
            d.setIncluded(true);
        }
        owlModel.getOWLProject().setSessionObject(CHANGED_WIDGETS, widgets);
    }

    public static void restoreWidgetsAfterSave(OWLModel owlModel) {
        OWLProject owlProject = owlModel.getOWLProject();
        Object widgets = owlProject.getSessionObject(CHANGED_WIDGETS);
        if (widgets instanceof Collection) {
            for (WidgetDescriptor d : (Collection)widgets) {
                d.setIncluded(false);
            }
            owlProject.setSessionObject(CHANGED_WIDGETS, null);
        }
    }
}

