/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class VisibilityPanel
extends JComponent {
    private boolean requiresReloadUI;

    public VisibilityPanel(OWLModel owlModel) {
        Cls[] metaClses = new Cls[]{owlModel.getRDFSNamedClassClass(), owlModel.getOWLNamedClassClass(), owlModel.getRDFPropertyClass(), owlModel.getOWLDatatypePropertyClass(), owlModel.getOWLObjectPropertyClass(), owlModel.getRDFSNamedClass("owl:AnnotationProperty"), owlModel.getRDFSNamedClass("owl:DeprecatedClass"), owlModel.getRDFSNamedClass("owl:DeprecatedProperty"), owlModel.getRDFSNamedClass("owl:FunctionalProperty"), owlModel.getRDFSNamedClass("owl:InverseFunctionalProperty"), owlModel.getRDFSNamedClass("owl:SymmetricProperty"), owlModel.getRDFSNamedClass("owl:TransitiveProperty")};
        Cls[] clses = new Cls[]{owlModel.getRDFSNamedClass("rdfs:Datatype"), owlModel.getRDFListClass(), owlModel.getRDFSNamedClass("rdfs:Container"), owlModel.getRDFSNamedClass("rdf:Alt"), owlModel.getRDFSNamedClass("rdf:Bag"), owlModel.getRDFSNamedClass("rdf:Seq"), owlModel.getRDFSNamedClass("rdfs:Literal"), owlModel.getRDFSNamedClass("rdf:Statement"), owlModel.getRDFSNamedClass("owl:AllDifferent"), owlModel.getOWLNothing(), owlModel.getOWLDataRangeClass()};
        Instance[] rdfProperties = new RDFProperty[]{owlModel.getRDFProperty("rdf:first"), owlModel.getRDFProperty("rdf:rest"), owlModel.getRDFProperty("rdfs:range"), owlModel.getRDFProperty("rdfs:member"), owlModel.getRDFProperty("rdf:type"), owlModel.getRDFProperty("rdf:object"), owlModel.getRDFProperty("rdf:predicate"), owlModel.getRDFProperty("rdf:subject"), owlModel.getRDFProperty("rdf:value")};
        Instance[] owlProperties = new RDFProperty[]{owlModel.getRDFProperty("owl:sameAs"), owlModel.getRDFProperty("owl:differentFrom"), owlModel.getRDFProperty("owl:disjointWith"), owlModel.getRDFProperty("owl:distinctMembers"), owlModel.getRDFProperty("owl:allValuesFrom"), owlModel.getRDFProperty("owl:someValuesFrom"), owlModel.getRDFProperty("owl:hasValue"), owlModel.getRDFProperty("owl:cardinality"), owlModel.getRDFProperty("owl:minCardinality"), owlModel.getRDFProperty("owl:maxCardinality"), owlModel.getRDFProperty("owl:oneOf"), owlModel.getRDFProperty("owl:onProperty")};
        Instance[] protegeInstances = new Instance[]{owlModel.getCls(":DIRECTED-BINARY-RELATION"), owlModel.getRDFProperty(":FROM"), owlModel.getRDFProperty(":TO")};
        Component metaClsesPanel = this.createCheckBoxesPanel("Metaclasses", (Instance[])metaClses);
        Component clsesPanel = this.createCheckBoxesPanel("Other Classes", (Instance[])clses);
        Component rdfPropertiesPanel = this.createCheckBoxesPanel("RDF Properties", rdfProperties);
        Component owlPropertiesPanel = this.createCheckBoxesPanel("OWL Properties", owlProperties);
        Component protegePanel = this.createCheckBoxesPanel("Native Protege Resources", protegeInstances);
        Component annotationsPanel = this.createCheckBoxesPanel("Annotation Properties", owlModel.getSystemAnnotationProperties());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add("Center", metaClsesPanel);
        leftPanel.add("South", clsesPanel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add("North", rdfPropertiesPanel);
        centerPanel.add("South", owlPropertiesPanel);
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add("North", annotationsPanel);
        rightPanel.add("Center", protegePanel);
        this.setLayout(new GridLayout(1, 3));
        this.add(leftPanel);
        this.add(centerPanel);
        this.add(rightPanel);
    }

    private Component createCheckBoxesPanel(String title, Instance[] instances) {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        int i = 0;
        while (i < instances.length) {
            Instance instance = instances[i];
            innerPanel.add(new VisibilityCheckBox(instance));
            ++i;
        }
        AllCheckBox allCheckBox = new AllCheckBox(innerPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(title));
        panel.add("North", allCheckBox);
        panel.add("West", Box.createHorizontalStrut(12));
        panel.add("Center", innerPanel);
        return panel;
    }

    public boolean getRequiresReloadUI() {
        return this.requiresReloadUI;
    }

    private class AllCheckBox
    extends JCheckBox {
        private Container container;

        AllCheckBox(Container container) {
            super("All");
            this.container = container;
            this.setSelected(this.isAllSelected());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AllCheckBox.this.updateDependents();
                    VisibilityPanel.this.requiresReloadUI = true;
                }
            });
        }

        private boolean isAllSelected() {
            int i = 0;
            while (i < this.container.getComponentCount()) {
                VisibilityCheckBox checkBox;
                if (this.container.getComponent(i) instanceof VisibilityCheckBox && !(checkBox = (VisibilityCheckBox)this.container.getComponent(i)).isSelected()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void updateDependents() {
            boolean value = this.isSelected();
            int i = 0;
            while (i < this.container.getComponentCount()) {
                if (this.container.getComponent(i) instanceof VisibilityCheckBox) {
                    VisibilityCheckBox checkBox = (VisibilityCheckBox)this.container.getComponent(i);
                    checkBox.setSelected(value);
                    checkBox.getInstance().setVisible(value);
                }
                ++i;
            }
        }
    }

    private class VisibilityCheckBox
    extends JCheckBox {
        private Instance instance;

        VisibilityCheckBox(Instance anInstance) {
            super(anInstance.getBrowserText(), anInstance.isVisible());
            this.instance = anInstance;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VisibilityCheckBox.this.updateVisibility();
                }
            });
        }

        Instance getInstance() {
            return this.instance;
        }

        private void updateVisibility() {
            boolean visible = this.isSelected();
            this.instance.setVisible(visible);
            if (this.instance instanceof Cls) {
                Cls cls = (Cls)this.instance;
                Collection dependents = visible ? cls.getSuperclasses() : cls.getSubclasses();
                this.setDependentCheckBoxesSelected(dependents, visible);
            }
            VisibilityPanel.this.requiresReloadUI = true;
        }

        private void setDependentCheckBoxesSelected(Collection dependents, boolean value) {
            for (Cls superCls : dependents) {
                if (superCls instanceof RDFSClass) {
                    superCls.setVisible(value);
                }
                Container cont = this.getParent();
                int i = 0;
                while (i < cont.getComponentCount()) {
                    if (cont.getComponent(i) instanceof VisibilityCheckBox) {
                        VisibilityCheckBox checkBox = (VisibilityCheckBox)cont.getComponent(i);
                        if (superCls.equals(checkBox.instance)) {
                            checkBox.setSelected(value);
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

