/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport;

import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.metadatatab.OntologyURIPanel;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport.EmptyImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport.LocalFileWizardPage;
import edu.stanford.smi.protegex.owl.ui.wizard.OWLWizard;
import edu.stanford.smi.protegex.owl.ui.wizard.OWLWizardPage;
import java.awt.Component;
import java.net.URI;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EmptyOntologyURIPage
extends OWLWizardPage {
    private OntologyURIPanel ontologyURIPanel;
    private OWLModel owlModel;
    private static final String HELP_TEXT = "<p>Please specify the URI of the new empty ontology.</p><p>In general, the URI should be an http URL that points to the location on the web where the new ontology will eventually be made available.</p>";

    public EmptyOntologyURIPage(OWLWizard wizard, OWLModel owlModel) {
        super("Specify Ontology URI", wizard);
        this.owlModel = owlModel;
        this.createUI();
        this.setPageComplete(this.validateData());
    }

    private void createUI() {
        this.ontologyURIPanel = new OntologyURIPanel(false, false);
        this.ontologyURIPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                EmptyOntologyURIPage.this.setPageComplete(EmptyOntologyURIPage.this.validateData());
            }
        });
        this.getContentComponent().add((Component)this.ontologyURIPanel, "North");
        this.setHelpText("Specifying the imported ontology URI", HELP_TEXT);
    }

    private boolean validateData() {
        if (this.ontologyURIPanel.getOntologyURI() != null) {
            URI uri = this.ontologyURIPanel.getOntologyURI();
            return uri != null;
        }
        return false;
    }

    public WizardPage getNextPage() {
        return new LocalFileWizardPage(this.getOWLWizard(), this.owlModel);
    }

    public URI getOntologyURI() {
        return this.ontologyURIPanel.getOntologyURI();
    }

    public void onFinish() {
        super.onFinish();
        ((EmptyImportWizard)this.getWizard()).setOntologyURI(this.getOntologyURI());
    }
}

