/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.prefixes;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.OWLNamespaceManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PrefixesTableModel
extends AbstractTableModel
implements Disposable {
    private NamespaceManagerListener listener = new NamespaceManagerListener(){

        public void defaultNamespaceChanged(String oldValue, String newValue) {
        }

        public void namespaceChanged(String prefix, String oldValue, String newValue) {
            int row = PrefixesTableModel.this.getPrefixRow(prefix);
            PrefixesTableModel.this.fireTableCellUpdated(row, 1);
        }

        public void prefixAdded(String prefix) {
            int index = PrefixesTableModel.this.prefixes.size();
            PrefixesTableModel.this.prefixes.add(prefix);
            PrefixesTableModel.this.fireTableRowsInserted(index, index);
        }

        public void prefixChanged(String namespace, String oldPrefix, String newPrefix) {
            int row = PrefixesTableModel.this.getPrefixRow(oldPrefix);
            if (row >= 0) {
                PrefixesTableModel.this.prefixes.remove(row);
                PrefixesTableModel.this.prefixes.add(row, newPrefix);
                PrefixesTableModel.this.fireTableCellUpdated(row, 0);
            }
        }

        public void prefixRemoved(String prefix) {
            int row = PrefixesTableModel.this.getPrefixRow(prefix);
            if (row >= 0) {
                PrefixesTableModel.this.prefixes.remove(row);
                PrefixesTableModel.this.fireTableRowsDeleted(row, row);
            }
        }
    };
    private OWLOntology ontology;
    public static final int COL_PREFIX = 0;
    public static final int COL_NAMESPACE = 1;
    public static final int COL_COUNT = 2;
    private List prefixes = new ArrayList();

    public PrefixesTableModel(OWLOntology ontology) {
        this.ontology = ontology;
        this.getNamespaceManager().addNamespaceManagerListener(this.listener);
        this.fill();
    }

    public void dispose() {
        this.getNamespaceManager().removeNamespaceManagerListener(this.listener);
    }

    private void fill() {
        this.prefixes = new ArrayList(this.getNamespaceManager().getPrefixes());
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Prefix";
        }
        if (column == 1) {
            return "Namespace";
        }
        return null;
    }

    public String getNamespace(int rowIndex) {
        String prefix = this.getPrefix(rowIndex);
        return this.getNamespaceManager().getNamespaceForPrefix(prefix);
    }

    NamespaceManager getNamespaceManager() {
        return this.ontology.getOWLModel().getNamespaceManager();
    }

    public String getPrefix(int row) {
        return (String)this.prefixes.get(row);
    }

    int getPrefixRow(String prefix) {
        return this.prefixes.indexOf(prefix);
    }

    public int getRowCount() {
        return this.prefixes.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getPrefix(rowIndex);
        }
        if (columnIndex == 1) {
            return this.getNamespace(rowIndex);
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String prefix = this.getPrefix(rowIndex);
        return this.isPrefixEditable(prefix);
    }

    public boolean isNamespaceEditable(String namespace) {
        String prefix = this.getNamespaceManager().getPrefix(namespace);
        return this.isPrefixEditable(prefix);
    }

    boolean isPrefixEditable(String prefix) {
        return this.getNamespaceManager().isModifiable(prefix);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String value;
        NamespaceManager nsm = this.getNamespaceManager();
        if (columnIndex == 0) {
            String value2 = (String)aValue;
            if (nsm.getNamespaceForPrefix(value2) == null && OWLNamespaceManager.isValidPrefix(value2)) {
                String namespace = this.getNamespace(rowIndex);
                this.setPrefixOfNamespace(namespace, value2);
            }
        } else if (columnIndex == 1 && nsm.getPrefix(value = (String)aValue) == null && !nsm.getDefaultNamespace().equals(value) && Jena.isNamespaceWithSeparator(value)) {
            String prefix = this.getPrefix(rowIndex);
            this.setNamespaceOfPrefix(prefix, value);
        }
    }

    private void setNamespaceOfPrefix(String prefix, String value) {
        OWLModel owlModel = this.ontology.getOWLModel();
        try {
            try {
                owlModel.beginTransaction("Change namespace of " + prefix + " to " + value);
                owlModel.getNamespaceManager().setPrefix(value, prefix);
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }

    private void setPrefixOfNamespace(String namespace, String value) {
        OWLModel owlModel = this.ontology.getOWLModel();
        try {
            try {
                owlModel.beginTransaction("Change prefix of " + namespace + " to " + value);
                owlModel.getNamespaceManager().setPrefix(namespace, value);
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }
}

